/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.HashSet;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Dn2id;

public class QueryUniqueKeyTest
extends AbstractClusterJModelTest {
    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.createDn2idInstances(10);
        try {
            this.tx.begin();
            this.session.deletePersistentAll(Dn2id.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.tx.begin();
        this.session.makePersistentAll((Iterable)this.dn2ids);
        this.tx.commit();
        this.addTearDownClasses(Dn2id.class);
    }

    public void testUniqueKey() {
        this.uniqueKeyBetweenQuery();
        this.uniqueKeyEqualQuery();
        this.uniqueKeyGreaterEqualQuery();
        this.uniqueKeyGreaterThanQuery();
        this.uniqueKeyLessEqualQuery();
        this.uniqueKeyLessThanQuery();
        this.failOnError();
    }

    public void uniqueKeyEqualQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Dn2id.class);
        PredicateOperand predicateOperand = queryDomainType.param("eid");
        PredicateOperand predicateOperand2 = queryDomainType.get("eid");
        Predicate predicate = predicateOperand2.equal(predicateOperand);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("eid", (Object)8L);
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(8L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("Wrong Dn2id eids returned from uniqueKeyEqualQuery query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    public void uniqueKeyGreaterThanQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Dn2id.class);
        PredicateOperand predicateOperand = queryDomainType.param("eid");
        PredicateOperand predicateOperand2 = queryDomainType.get("eid");
        Predicate predicate = predicateOperand2.greaterThan(predicateOperand);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("eid", (Object)6L);
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(7L);
        hashSet.add(8L);
        hashSet.add(9L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("Wrong Dn2id eids returned from uniqueKeyGreaterThanQuery query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    public void uniqueKeyGreaterEqualQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Dn2id.class);
        PredicateOperand predicateOperand = queryDomainType.param("eid");
        PredicateOperand predicateOperand2 = queryDomainType.get("eid");
        Predicate predicate = predicateOperand2.greaterEqual(predicateOperand);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("eid", (Object)7L);
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(7L);
        hashSet.add(8L);
        hashSet.add(9L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("Wrong Dn2id eids returned from uniqueKeyGreaterEqualQuery query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    public void uniqueKeyLessThanQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Dn2id.class);
        PredicateOperand predicateOperand = queryDomainType.param("eid");
        PredicateOperand predicateOperand2 = queryDomainType.get("eid");
        Predicate predicate = predicateOperand2.lessThan(predicateOperand);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("eid", (Object)3L);
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(0L);
        hashSet.add(1L);
        hashSet.add(2L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("Wrong Dn2id eids returned from uniqueKeyLessThanQuery query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    public void uniqueKeyLessEqualQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Dn2id.class);
        PredicateOperand predicateOperand = queryDomainType.param("eid");
        PredicateOperand predicateOperand2 = queryDomainType.get("eid");
        Predicate predicate = predicateOperand2.lessEqual(predicateOperand);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("eid", (Object)2L);
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(0L);
        hashSet.add(1L);
        hashSet.add(2L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("Wrong Dn2id eids returned from uniqueKeyLessEqualQuery query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    public void uniqueKeyBetweenQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Dn2id.class);
        PredicateOperand predicateOperand = queryDomainType.param("lower");
        PredicateOperand predicateOperand2 = queryDomainType.param("upper");
        PredicateOperand predicateOperand3 = queryDomainType.get("eid");
        Predicate predicate = predicateOperand3.between(predicateOperand, predicateOperand2);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("lower", (Object)5L);
        query.setParameter("upper", (Object)7L);
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(5L);
        hashSet.add(6L);
        hashSet.add(7L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("Wrong Dn2id eids returned from uniqueKeyBetweenQuery query: ", hashSet, hashSet2);
        this.tx.commit();
    }
}

