/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.math.BigDecimal;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.DecimalTypes;
import testsuite.clusterj.model.IdBase;

public class QueryDecimalTypesTest
extends AbstractQueryTest {
    public Class getInstanceType() {
        return DecimalTypes.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllDecimalTypesInstances(n);
    }

    public void test() {
        this.btreeIndexScanDecimal();
        this.hashIndexScanDecimal();
        this.bothIndexScanDecimal();
        this.noneIndexScanDecimal();
        this.failOnError();
    }

    public void btreeIndexScanDecimal() {
        this.equalQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(8), 8);
        this.greaterEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), this.getDecimal(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), this.getDecimal(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getDecimal(4), this.getDecimal(6), 5);
    }

    public void hashIndexScanDecimal() {
        this.equalQuery("decimal_null_hash", "idx_decimal_null_hash", this.getDecimal(8), 8);
        this.greaterEqualQuery("decimal_null_hash", "none", this.getDecimal(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_hash", "none", this.getDecimal(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_hash", "none", this.getDecimal(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_hash", "none", this.getDecimal(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_hash", "none", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_hash", "none", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_hash", "none", this.getDecimal(4), this.getDecimal(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_hash", "none", this.getDecimal(4), this.getDecimal(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_hash", "none", this.getDecimal(4), this.getDecimal(6), 5);
    }

    public void bothIndexScanDecimal() {
        this.equalQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(8), 8);
        this.greaterEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), this.getDecimal(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), this.getDecimal(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getDecimal(4), this.getDecimal(6), 5);
    }

    public void noneIndexScanDecimal() {
        this.equalQuery("decimal_null_none", "none", this.getDecimal(8), 8);
        this.greaterEqualQuery("decimal_null_none", "none", this.getDecimal(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_none", "none", this.getDecimal(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_none", "none", this.getDecimal(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_none", "none", this.getDecimal(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_none", "none", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_none", "none", this.getDecimal(4), this.getDecimal(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_none", "none", this.getDecimal(4), this.getDecimal(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_none", "none", this.getDecimal(4), this.getDecimal(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_none", "none", this.getDecimal(4), this.getDecimal(6), 5);
    }

    private void createAllDecimalTypesInstances(int n) {
        for (int i = 0; i < n; ++i) {
            DecimalTypes decimalTypes = (DecimalTypes)this.session.newInstance(DecimalTypes.class);
            decimalTypes.setId(i);
            decimalTypes.setDecimal_null_hash(this.getDecimal(i));
            decimalTypes.setDecimal_null_btree(this.getDecimal(i));
            decimalTypes.setDecimal_null_both(this.getDecimal(i));
            decimalTypes.setDecimal_null_none(this.getDecimal(i));
            this.instances.add(decimalTypes);
        }
    }

    protected BigDecimal getDecimal(int n) {
        return BigDecimal.valueOf(n, 5);
    }

    @Override
    protected void printResultInstance(IdBase idBase) {
        if (idBase instanceof DecimalTypes) {
            DecimalTypes decimalTypes = (DecimalTypes)idBase;
        }
    }

    public static String toString(IdBase idBase) {
        DecimalTypes decimalTypes = (DecimalTypes)idBase;
        StringBuffer stringBuffer = new StringBuffer("DecimalTypes id: ");
        stringBuffer.append(decimalTypes.getId());
        stringBuffer.append("; decimal_null_both: ");
        stringBuffer.append(decimalTypes.getDecimal_null_both().toString());
        stringBuffer.append("; decimal_null_btree: ");
        stringBuffer.append(decimalTypes.getDecimal_null_btree().toString());
        stringBuffer.append("; decimal_null_hash: ");
        stringBuffer.append(decimalTypes.getDecimal_null_hash().toString());
        stringBuffer.append("; decimal_null_none: ");
        stringBuffer.append(decimalTypes.getDecimal_null_none().toString());
        return stringBuffer.toString();
    }
}

