/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.store.ClusterTransaction;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.KeyPart;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.Ndb;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbIndexScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbInterpretedCode;
import com.mysql.ndbjtie.ndbapi.NdbScanFilter;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbTransaction;
import java.nio.ByteBuffer;
import java.util.List;

class DbImplForNdbRecord
implements Db {
    static final I18NHelper local = I18NHelper.getInstance(DbImplForNdbRecord.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(DbImplForNdbRecord.class);
    private Ndb ndb;
    private ByteBuffer errorBuffer;
    private NdbDictionary.Dictionary ndbDictionary;
    private ClusterConnectionImpl clusterConnection;
    private boolean closing = false;

    public DbImplForNdbRecord(ClusterConnectionImpl clusterConnectionImpl, Ndb ndb) {
        this.clusterConnection = clusterConnectionImpl;
        this.ndb = ndb;
        this.errorBuffer = this.clusterConnection.byteBufferPoolForDBImplError.borrowBuffer();
        int n = ndb.init(1);
        this.handleError(n, ndb);
        this.ndbDictionary = ndb.getDictionary();
        this.handleError(this.ndbDictionary, ndb);
    }

    @Override
    public void assertNotClosed(String string) {
        if (this.closing || this.ndb == null) {
            throw new ClusterJUserException(local.message("ERR_Db_Is_Closing", (Object)string));
        }
    }

    protected void closing() {
        this.closing = true;
    }

    @Override
    public void close() {
        this.clusterConnection.byteBufferPoolForDBImplError.returnBuffer(this.errorBuffer);
        Ndb.delete(this.ndb);
        this.clusterConnection.close(this);
    }

    @Override
    public Dictionary getDictionary() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public NdbDictionary.Dictionary getNdbDictionary() {
        return this.ndbDictionary;
    }

    @Override
    public ClusterTransaction startTransaction(String string) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    protected void handleError(int n, Ndb ndb) {
        if (n == 0) {
            return;
        }
        NdbErrorConst ndbErrorConst = ndb.getNdbError();
        String string = this.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(n, ndbErrorConst, string);
    }

    protected void handleError(Object object, Ndb ndb) {
        if (object != null) {
            return;
        }
        NdbErrorConst ndbErrorConst = ndb.getNdbError();
        String string = this.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(null, ndbErrorConst, string);
    }

    @Override
    public boolean isRetriable(ClusterJDatastoreException clusterJDatastoreException) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public String getNdbErrorDetail(NdbErrorConst ndbErrorConst) {
        return this.ndb.getNdbErrorDetail(ndbErrorConst, this.errorBuffer, this.errorBuffer.capacity());
    }

    public NdbTransaction enlist(String string, List<KeyPart> list) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public NdbTransaction enlist(String string, int n) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public NdbTransaction joinTransaction(String string) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeQueryObjects() {
        Class<ClusterConnectionImpl> clazz = ClusterConnectionImpl.class;
        synchronized (ClusterConnectionImpl.class) {
            NdbDictionary.Table table;
            NdbScanOperation.ScanOptions scanOptions;
            if (ClusterConnectionImpl.queryObjectsInitialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            NdbIndexScanOperation.IndexBound indexBound = NdbIndexScanOperation.IndexBound.create();
            if (indexBound != null) {
                NdbIndexScanOperation.IndexBound.delete(indexBound);
            }
            if ((scanOptions = NdbScanOperation.ScanOptions.create()) != null) {
                NdbScanOperation.ScanOptions.delete(scanOptions);
            }
            if ((table = NdbDictionary.Table.create("dummy")) != null) {
                NdbInterpretedCode ndbInterpretedCode = NdbInterpretedCode.create(table, null, 0);
                if (ndbInterpretedCode != null) {
                    NdbScanFilter ndbScanFilter = NdbScanFilter.create(ndbInterpretedCode);
                    if (ndbScanFilter != null) {
                        NdbScanFilter.delete(ndbScanFilter);
                    }
                    NdbInterpretedCode.delete(ndbInterpretedCode);
                }
                NdbDictionary.Table.delete(table);
            }
            ClusterConnectionImpl.queryObjectsInitialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

