/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Session;
import com.mysql.clusterj.SessionFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.AutoPKInt;

public class Reconnect2Test
extends AbstractClusterJTest {
    @Override
    protected boolean getDebug() {
        return false;
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.session.deletePersistentAll(AutoPKInt.class);
        this.addTearDownClasses(AutoPKInt.class);
        this.session.close();
    }

    private void millisleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void testAutoIncrementInsert() {
        this.runQueryAndReconnect("runAutoIncrementInsert");
    }

    public void runQueryAndReconnect(String string) {
        try {
            Method method = this.getClass().getMethod(string, Integer.TYPE);
            Thread thread = new Thread(new CodeRunner(this, method));
            thread.start();
            this.sessionFactory.reconnect(1);
            thread.join();
        }
        catch (InterruptedException | NoSuchMethodException | SecurityException exception) {
            throw new RuntimeException("Failed to load the test method.");
        }
        this.failOnError();
    }

    public void runAutoIncrementInsert(int n) {
        Session session = this.sessionFactory.getSession();
        AutoPKInt autoPKInt = (AutoPKInt)session.newInstance(AutoPKInt.class);
        autoPKInt.setVal(n);
        session.makePersistent((Object)autoPKInt);
    }

    class CodeRunner
    implements Runnable {
        private Object testObject;
        private Method testMethod;

        public CodeRunner(Object object, Method method) {
            this.testObject = object;
            this.testMethod = method;
        }

        @Override
        public void run() {
            boolean bl = false;
            for (int i = 0; i < 1000; ++i) {
                try {
                    this.testMethod.invoke(this.testObject, i);
                    if (!bl) continue;
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    String string = invocationTargetException.getCause().getMessage();
                    if (string.contains("SessionFactory is not open.")) {
                        do {
                            Reconnect2Test.this.millisleep(100L);
                        } while (Reconnect2Test.this.sessionFactory.currentState() != SessionFactory.State.Open);
                        bl = true;
                        continue;
                    }
                    Reconnect2Test.this.error(this.testMethod.getName() + ": caught " + string);
                    return;
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    Reconnect2Test.this.error("Failed to invoke the test method.");
                    return;
                }
            }
            Reconnect2Test.this.error("Reconnect did not happen.");
        }
    }
}

