/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.Persistent;
import com.mysql.clusterj.annotation.Projection;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;

public class ProjectionTest
extends AbstractClusterJTest {
    protected Hope hope0;
    protected Hope hope1;
    protected Hope hope2;
    protected Hope hope3;

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.session.deletePersistentAll(Hope.class);
        this.hope0 = this.setHopeFields((Hope)this.session.newInstance(Hope.class), 0, 0);
        this.hope1 = this.setHopeFields((Hope)this.session.newInstance(Hope.class), 1, 1);
        this.hope2 = this.setHopeFields((Hope)this.session.newInstance(Hope.class), 0, 2);
        this.hope3 = this.setHopeFields((Hope)this.session.newInstance(Hope.class), 1, 3);
        this.session.persist((Object)new Hope[]{this.hope0, this.hope1, this.hope2, this.hope3});
        this.addTearDownClasses(Hope.class);
    }

    protected Hope setHopeFields(Hope hope, int n, int n2) {
        hope.setPartitionId(n);
        hope.setId(n2);
        hope.setInt_col1(n2 + 100);
        hope.setInt_col2(n2 + 200);
        hope.setStr_col1("Column1 " + (n2 + 100));
        hope.setStr_col2("Column2 " + (n2 + 200));
        hope.setStr_col3("Column3 " + (n2 + 300));
        return hope;
    }

    protected ProjectHope setProjectHopeFields(ProjectHope projectHope, int n, int n2, int n3, int n4, String string) {
        projectHope.setPartitionId(n);
        this.errorIfNotEqual("setProjectHopeFields partition", n, projectHope.getPartitionId());
        projectHope.setId(n2);
        this.errorIfNotEqual("setProjectHopeFields id", n2, projectHope.getId());
        projectHope.setInt_col1(n3);
        this.errorIfNotEqual("setProjectHopeFields int_col1", n3, projectHope.getInt_col1());
        projectHope.setInt_col2(n4);
        this.errorIfNotEqual("setProjectHopeFields int_col2", n4, projectHope.getInt_col2());
        projectHope.setStr_col3(string);
        this.errorIfNotEqual("setProjectHopeFields str_col3", string, projectHope.getStr_col3());
        return projectHope;
    }

    protected HopeFulNotAllNonDefault setHopeFulNotAllNonDefaultFields(HopeFulNotAllNonDefault hopeFulNotAllNonDefault, int n, int n2) {
        hopeFulNotAllNonDefault.setPartitionId(n);
        hopeFulNotAllNonDefault.setId(n2);
        return hopeFulNotAllNonDefault;
    }

    public void test() {
        this.testPersistProjectHope();
        this.testPersistHopeful();
        this.testPersistHopeless();
        this.testFindProjectHope();
        this.testFindHopeful();
        this.testFindHopeless();
        this.testLoadProjectHope();
        this.testLoadHopeful();
        this.testUpdateProjectHope();
        this.testSaveProjectHope();
        this.testDeleteByClassAndKeyProjectHope();
        this.testDeleteByInstanceProjectHope();
        this.testDeleteByClassAndKeyHopeful();
        this.testDeleteByInstanceHopeful();
        this.testScanPartitionKeyProjectHope();
        this.testScanPartitionKeyHopeful();
        this.testTableScanIdProjectHope();
        this.testTableScanIdHopeful();
        this.failOnError();
    }

    protected void testPersistProjectHope() {
        this.session = this.sessionFactory.getSession();
        try {
            ProjectHope projectHope = (ProjectHope)this.session.newInstance(ProjectHope.class);
            this.session.persist((Object)this.setProjectHopeFields(projectHope, 10, 100, 1100, 1200, "Column 3 100"));
            this.session.persist((Object)this.setProjectHopeFields(projectHope, 10, 101, 1101, 1201, "Column 3 101"));
            this.session.persist((Object)this.setProjectHopeFields(projectHope, 10, 102, 1102, 1202, "Column 3 102"));
            this.session.persist((Object)this.setProjectHopeFields(projectHope, 10, 103, 1103, 1203, "Column 3 103"));
        }
        finally {
            this.session.close();
        }
    }

    protected void testPersistHopeful() {
        this.session = this.sessionFactory.getSession();
        try {
            HopeFulNotAllNonDefault hopeFulNotAllNonDefault = (HopeFulNotAllNonDefault)this.session.newInstance(HopeFulNotAllNonDefault.class);
            this.setHopeFulNotAllNonDefaultFields(hopeFulNotAllNonDefault, 0, 10000);
            this.session.persist((Object)hopeFulNotAllNonDefault);
            this.error("testPersistHopeful did not throw any exception.");
        }
        catch (Throwable throwable) {
            this.checkException("testPersistHopeful", "Illegal null attribute", throwable);
        }
        finally {
            this.session.close();
        }
    }

    protected void testPersistHopeless() {
        this.session = this.sessionFactory.getSession();
        try {
            this.session.newInstance(HopeLessNotAllPK.class);
            this.error("testPersistHopeless did not throw any exception.");
        }
        catch (Throwable throwable) {
            this.checkException("testPersistHopeless", "no field mapped to the primary key", throwable);
        }
        finally {
            this.session.close();
        }
    }

    protected void testSaveProjectHope() {
        this.testSave("testSaveProjectHope", new Integer[]{10, 102}, 600);
    }

    protected void testFindProjectHope() {
        ProjectHope projectHope = this.testFind("testFindProjectHope", ProjectHope.class, new Integer[]{0, 0});
        if (projectHope != null) {
            this.errorIfNotEqual("testFindProjectHope getPartitionId", 0, projectHope.getPartitionId());
            this.errorIfNotEqual("testFindProjectHope getId", 0, projectHope.getId());
            this.errorIfNotEqual("testFindProjectHope getInt_col1", 100, projectHope.getInt_col1());
        }
    }

    protected void testFindHopeful() {
        HopeFulNotAllNonDefault hopeFulNotAllNonDefault = this.testFind("testFindHopeful", HopeFulNotAllNonDefault.class, new Integer[]{1, 3});
        if (hopeFulNotAllNonDefault != null) {
            this.errorIfNotEqual("testFindHopeful getPartitionId", 1, hopeFulNotAllNonDefault.getPartitionId());
            this.errorIfNotEqual("testFindHopeful getId", 3, hopeFulNotAllNonDefault.getId());
        }
    }

    protected void testFindHopeless() {
        try {
            this.testFind("testFindHopeless", HopeLessNotAllPK.class, new Integer[]{0, 0});
            this.error("testFindHopeless did not throw any exception.");
        }
        catch (Throwable throwable) {
            this.checkException("testFindHopeless", "no field mapped to the primary key", throwable);
        }
    }

    protected void testLoadProjectHope() {
        ProjectHope projectHope = this.testLoad("testLoadProjectHope", ProjectHope.class, new Integer[]{1, 3});
        this.errorIfNotEqual("testLoadProjectHope getPartitionId", 1, projectHope.getPartitionId());
        this.errorIfNotEqual("testLoadProjectHope getId", 3, projectHope.getId());
        this.errorIfNotEqual("testLoadProjectHope getInt_col1", 103, projectHope.getInt_col1());
        this.errorIfNotEqual("testLoadProjectHope getStr_col3", "Column3 303", projectHope.getStr_col3());
    }

    protected void testLoadHopeful() {
        HopeFulNotAllNonDefault hopeFulNotAllNonDefault = this.testLoad("testLoadHopeful", HopeFulNotAllNonDefault.class, new Integer[]{1, 3});
        this.errorIfNotEqual("testLoadProjectHope getPartitionId", 1, hopeFulNotAllNonDefault.getPartitionId());
        this.errorIfNotEqual("testLoadProjectHope getId", 3, hopeFulNotAllNonDefault.getId());
    }

    protected void testUpdateProjectHope() {
        this.testUpdate("testUpdateProjectHope", ProjectHope.class, new Integer[]{10, 102}, 700);
    }

    protected void testUpdateHopeful() {
        this.testUpdate("testUpdateHopeful", HopeFulNotAllNonDefault.class, new Integer[]{10, 103}, 800);
    }

    protected void testDeleteByClassAndKeyProjectHope() {
        this.testDeleteByClassAndKey("testDeleteByClassAndKeyProjectHope", ProjectHope.class, new Integer[]{10, 100});
    }

    protected void testDeleteByInstanceProjectHope() {
        this.testDeleteByInstance("testLoadProjectHope", ProjectHope.class, new Integer[]{10, 101});
    }

    protected void testDeleteByClassAndKeyHopeful() {
        this.testDeleteByClassAndKey("testDeleteByClassAndKeyHopeful", HopeFulNotAllNonDefault.class, new Integer[]{10, 102});
    }

    protected void testDeleteByInstanceHopeful() {
        this.testDeleteByInstance("testDeleteByInstanceHopeful", HopeFulNotAllNonDefault.class, new Integer[]{10, 103});
    }

    protected void testScanPartitionKeyProjectHope() {
        List<ProjectHope> list = this.testScanPartitionKey(ProjectHope.class, 0);
        this.errorIfNotEqual("testScanPartitionKeyProjectHope", 2, list.size());
    }

    protected void testScanPartitionKeyHopeful() {
        List<HopeFulNotAllNonDefault> list = this.testScanPartitionKey(HopeFulNotAllNonDefault.class, 1);
        this.errorIfNotEqual("testScanPartitionKeyHopeful", 2, list.size());
    }

    protected void testTableScanIdProjectHope() {
        this.testTableScanId(ProjectHope.class, 100);
    }

    protected void testTableScanIdHopeful() {
        this.testTableScanId(HopeFulNotAllNonDefault.class, 101);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T testFind(String string, Class<T> clazz, Object object) {
        try {
            this.session = this.sessionFactory.getSession();
            Object object2 = this.session.find(clazz, object);
            if (object2 == null) {
                this.error(string + " testFind: instance was null for " + clazz.getName());
            }
            Object object3 = object2;
            return (T)object3;
        }
        finally {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T testLoad(String string, Class<T> clazz, Object object) {
        try {
            this.session = this.sessionFactory.getSession();
            Object object2 = this.session.newInstance(clazz, object);
            this.session.currentTransaction().begin();
            this.session.load(object2);
            this.session.flush();
            this.errorIfNotEqual(string + "testLoad", true, this.session.found(object2));
            Object object3 = object2;
            return (T)object3;
        }
        finally {
            this.session.currentTransaction().commit();
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends HopeFulNotAllNonDefault> HopeFulNotAllNonDefault testUpdate(String string, Class<T> clazz, Object object, int n) {
        try {
            this.session = this.sessionFactory.getSession();
            HopeFulNotAllNonDefault hopeFulNotAllNonDefault = (HopeFulNotAllNonDefault)this.session.find(clazz, object);
            hopeFulNotAllNonDefault.setInt_col1(n);
            this.session.updatePersistent((Object)hopeFulNotAllNonDefault);
            HopeFulNotAllNonDefault hopeFulNotAllNonDefault2 = (HopeFulNotAllNonDefault)this.session.find(clazz, object);
            if (hopeFulNotAllNonDefault2 == null) {
                this.error(string + " testUpdate find returned null");
                HopeFulNotAllNonDefault hopeFulNotAllNonDefault3 = null;
                return hopeFulNotAllNonDefault3;
            }
            this.errorIfNotEqual(string + "testUpdate", n, hopeFulNotAllNonDefault.getInt_col1());
            HopeFulNotAllNonDefault hopeFulNotAllNonDefault4 = hopeFulNotAllNonDefault;
            return hopeFulNotAllNonDefault4;
        }
        finally {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProjectHope testSave(String string, Object object, int n) {
        try {
            this.session = this.sessionFactory.getSession();
            ProjectHope projectHope = (ProjectHope)this.session.newInstance(ProjectHope.class, object);
            projectHope.setInt_col1(n);
            this.session.savePersistent((Object)projectHope);
            ProjectHope projectHope2 = (ProjectHope)this.session.find(ProjectHope.class, object);
            if (projectHope2 == null) {
                this.error(string + " testSave find returned null");
                ProjectHope projectHope3 = null;
                return projectHope3;
            }
            this.errorIfNotEqual(string + "testSave", true, this.session.found((Object)projectHope));
            this.errorIfNotEqual(string + "testSave", n, projectHope.getInt_col1());
            ProjectHope projectHope4 = projectHope;
            return projectHope4;
        }
        finally {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void testDeleteByClassAndKey(String string, Class<T> clazz, Object object) {
        try {
            this.session = this.sessionFactory.getSession();
            this.session.deletePersistent(clazz, object);
        }
        finally {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void testDeleteByInstance(String string, Class<T> clazz, Object object) {
        try {
            this.session = this.sessionFactory.getSession();
            Object object2 = this.session.newInstance(clazz, object);
            this.session.deletePersistent(object2);
        }
        finally {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> testScanPartitionKey(Class<T> clazz, int n) {
        try {
            List list;
            this.session = this.sessionFactory.getSession();
            QueryBuilder queryBuilder = this.session.getQueryBuilder();
            QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(clazz);
            Predicate predicate = queryDomainType.get("partitionId").equal(queryDomainType.param("partitionIDParam"));
            queryDomainType.where(predicate);
            Query query = this.session.createQuery((QueryDefinition)queryDomainType);
            query.setParameter("partitionIDParam", (Object)n);
            List list2 = list = query.getResultList();
            return list2;
        }
        finally {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> testTableScanId(Class<T> clazz, int n) {
        try {
            List list;
            this.session = this.sessionFactory.getSession();
            QueryBuilder queryBuilder = this.session.getQueryBuilder();
            QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(clazz);
            Predicate predicate = queryDomainType.get("id").equal(queryDomainType.param("idParam"));
            queryDomainType.where(predicate);
            Query query = this.session.createQuery((QueryDefinition)queryDomainType);
            query.setParameter("idParam", (Object)n);
            List list2 = list = query.getResultList();
            return list2;
        }
        finally {
            this.session.close();
        }
    }

    protected void checkException(String string, String string2, Throwable throwable) {
        if (!(throwable instanceof ClusterJException)) {
            this.error(string + " threw the wrong exception: " + throwable.getClass().getName() + " " + throwable.getMessage());
        } else if (!throwable.getMessage().contains(string2)) {
            this.error(string + " ClusterJException did not contain <" + string2 + "> in message: " + throwable.getMessage());
        }
    }

    @PersistenceCapable(table="hope")
    public static interface Hope {
        @Persistent(column="partition_id")
        public int getPartitionId();

        public void setPartitionId(int var1);

        public int getId();

        public void setId(int var1);

        public int getInt_col1();

        public void setInt_col1(int var1);

        public int getInt_col2();

        public void setInt_col2(int var1);

        public String getStr_col1();

        public void setStr_col1(String var1);

        public String getStr_col2();

        public void setStr_col2(String var1);

        public String getStr_col3();

        public void setStr_col3(String var1);
    }

    @Projection
    @PersistenceCapable(table="hope")
    public static interface ProjectHope
    extends HopeFulNotAllNonDefault {
        @Override
        @Persistent(column="partition_id")
        public int getPartitionId();

        @Override
        public void setPartitionId(int var1);

        @Override
        public int getId();

        @Override
        public void setId(int var1);

        @Override
        public int getInt_col1();

        @Override
        public void setInt_col1(int var1);

        public int getInt_col2();

        public void setInt_col2(int var1);

        public String getStr_col3();

        public void setStr_col3(String var1);
    }

    @Projection
    @PersistenceCapable(table="hope")
    public static interface HopeFulNotAllNonDefault {
        @Persistent(column="partition_id")
        public int getPartitionId();

        public void setPartitionId(int var1);

        public int getId();

        public void setId(int var1);

        public int getInt_col1();

        public void setInt_col1(int var1);
    }

    @Projection
    @PersistenceCapable(table="hope")
    public static interface HopeLessNotAllPK {
        @Persistent(column="partition_id")
        public int getPartitionId();

        public void setPartitionId(int var1);
    }
}

