/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.List;
import java.util.Map;
import testsuite.clusterj.AbstractClusterJModelTest;

public class SchemaChangeTest
extends AbstractClusterJModelTest {
    private static final String alterTableDropBtreeIndexStatement = "alter table maldacena drop index idx_string_not_null_btree";
    private static final String alterTableAddBtreeIndexStatement = "alter table maldacena add index idx_string_not_null_btree (string_not_null_btree)";
    private static final String alterTableDropHashIndexStatement = "alter table maldacena drop index idx_string_not_null_hash";
    private static final String alterTableAddHashIndexStatement = "alter table maldacena add unique index idx_string_not_null_hash (string_not_null_hash) using hash";
    private static final String alterTableDropBtreeColumnStatement = "alter table maldacena drop column string_not_null_btree";
    private static final String alterTableAddBtreeColumnStatement = "alter table maldacena add string_not_null_btree varchar(20) not null default '0'";
    private static final String alterTableDropHashColumnStatement = "alter table maldacena drop column string_not_null_hash";
    private static final String alterTableAddHashColumnStatement = "alter table maldacena add string_not_null_hash varchar(300) not null default '0'";
    private static final String dropTableStatement = "drop table if exists maldacena";
    private static final String createTableStatement = "create table maldacena (id int not null primary key,string_not_null_hash varchar(300) not null default '0',string_not_null_btree varchar(20) not null default '0',string_not_null_both varchar(300) not null default '0',string_not_null_none varchar(20) not null default '0',unique key idx_string_not_null_hash (string_not_null_hash) using hash,key idx_string_not_null_btree (string_not_null_btree),unique key idx_string_not_null_both (string_not_null_both)) ENGINE=ndbcluster DEFAULT CHARSET=latin1";
    private static final String truncateTableStatement = "truncate table maldacena";

    @Override
    public void localSetUp() {
        logger.info("PLEASE IGNORE THE FOLLOWING EXPECTED SEVERE ERRORS.");
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.executeSQL(dropTableStatement);
        this.executeSQL(createTableStatement);
        this.session.unloadSchema(Maldacena.class);
        this.session.makePersistent(this.session.newInstance(Maldacena.class, (Object)0));
    }

    @Override
    public void localTearDown() {
        this.executeSQL(dropTableStatement);
    }

    public void test() {
        this.testTruncate();
        this.testDropTable();
        this.testDropBtreeIndex();
        this.testDropHashIndex();
        this.testDropBtreeColumn();
        this.testDropHashColumn();
        this.testClassification();
        this.failOnError();
    }

    protected void testClassification() {
        this.errorIfNotEqual("wrong classification", 0, ClusterJDatastoreException.Classification.lookup((int)0).value);
        this.errorIfNotEqual("wrong classification", 1, ClusterJDatastoreException.Classification.lookup((int)1).value);
        this.errorIfNotEqual("wrong classification", 2, ClusterJDatastoreException.Classification.lookup((int)2).value);
        this.errorIfNotEqual("wrong classification", 3, ClusterJDatastoreException.Classification.lookup((int)3).value);
        this.errorIfNotEqual("wrong classification", 4, ClusterJDatastoreException.Classification.lookup((int)4).value);
        this.errorIfNotEqual("wrong classification", 5, ClusterJDatastoreException.Classification.lookup((int)5).value);
        this.errorIfNotEqual("wrong classification", 6, ClusterJDatastoreException.Classification.lookup((int)6).value);
        this.errorIfNotEqual("wrong classification", 7, ClusterJDatastoreException.Classification.lookup((int)7).value);
        this.errorIfNotEqual("wrong classification", 8, ClusterJDatastoreException.Classification.lookup((int)8).value);
        this.errorIfNotEqual("wrong classification", 9, ClusterJDatastoreException.Classification.lookup((int)9).value);
        this.errorIfNotEqual("wrong classification", 10, ClusterJDatastoreException.Classification.lookup((int)10).value);
        this.errorIfNotEqual("wrong classification", 11, ClusterJDatastoreException.Classification.lookup((int)11).value);
        this.errorIfNotEqual("wrong classification", 12, ClusterJDatastoreException.Classification.lookup((int)12).value);
        this.errorIfNotEqual("wrong classification", 13, ClusterJDatastoreException.Classification.lookup((int)13).value);
        this.errorIfNotEqual("wrong classification", 14, ClusterJDatastoreException.Classification.lookup((int)14).value);
        this.errorIfNotEqual("wrong classification", 15, ClusterJDatastoreException.Classification.lookup((int)15).value);
        this.errorIfNotEqual("wrong classification", 17, ClusterJDatastoreException.Classification.lookup((int)17).value);
        this.errorIfNotEqual("wrong classification", 18, ClusterJDatastoreException.Classification.lookup((int)18).value);
        if (ClusterJDatastoreException.Classification.lookup((int)16) != null) {
            this.error("wrong classification for Classification.lookup(16)");
        }
        if (ClusterJDatastoreException.Classification.lookup((int)19) != null) {
            this.error("wrong classification for Classification.lookup(19)");
        }
        if (ClusterJDatastoreException.Classification.lookup((int)100) != null) {
            this.error("wrong classification for Classification.lookup(100)");
        }
    }

    protected void testTruncate() {
        this.tryFind("testTruncate before truncate find", Maldacena.class, 0, 1, "no error");
        this.tryQuery("testTruncate before truncate unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "no error");
        this.tryQuery("testDropIndetestDropHashIndex before truncate unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "no error");
        this.tryQuery("testDropHashIndex before truncate index scan", Maldacena.class, "string_not_null_btree", "0", 1, "INDEX_SCAN", "idx_string_not_null_btree", "no error");
        this.tryQuery("testDropHashIndex before truncate table scan", Maldacena.class, "string_not_null_none", "0", 1, "TABLE_SCAN", "no index", "no error");
        this.executeSQL(truncateTableStatement);
        this.tryFind("testTruncate after truncate find", Maldacena.class, 0, 1, "code 241");
        this.tryQuery("testTruncate after truncate unique key", Maldacena.class, "string_not_null_hash", "0", 0, "UNIQUE_KEY", "idx_string_not_null_hash", "code 241");
        this.tryQuery("testTruncate after truncate index scan", Maldacena.class, "string_not_null_btree", "0", 0, "INDEX_SCAN", "idx_string_not_null_btree", "code 241");
        this.tryQuery("testTruncate after truncate table scan", Maldacena.class, "string_not_null_none", "0", 0, "TABLE_SCAN", "no index", "code 241");
        this.session.unloadSchema(Maldacena.class);
        this.session.makePersistent(this.session.newInstance(Maldacena.class, (Object)0));
        this.tryFind("testTruncate after unload schema find", Maldacena.class, 0, 1, "no error");
        this.tryQuery("testTruncate after unload schema unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "no error");
        this.tryQuery("testTruncate after unload schema index scan", Maldacena.class, "string_not_null_btree", "0", 1, "INDEX_SCAN", "idx_string_not_null_btree", "no error");
        this.tryQuery("testTruncate after unload schema table scan", Maldacena.class, "string_not_null_none", "0", 1, "TABLE_SCAN", "no index", "no error");
    }

    protected void testDropTable() {
        this.tryFind("testDropTable before drop table find", Maldacena.class, 0, 1, "no error");
        this.tryQuery("testDropTable before drop table unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "no error");
        this.tryQuery("testDropTable before drop table index scan", Maldacena.class, "string_not_null_btree", "0", 1, "INDEX_SCAN", "idx_string_not_null_btree", "no error");
        this.tryQuery("testDropTable before drop table table scan", Maldacena.class, "string_not_null_none", "0", 1, "TABLE_SCAN", "no index", "no error");
        this.executeSQL(dropTableStatement);
        this.tryFind("testDropTable after drop table find", Maldacena.class, 0, 1, "code 284");
        this.tryQuery("testDropTable after drop table unique key", Maldacena.class, "string_not_null_hash", "0", 0, "UNIQUE_KEY", "idx_string_not_null_hash", "code 284");
        this.tryQuery("testDropTable after drop table index scan", Maldacena.class, "string_not_null_btree", "0", 0, "INDEX_SCAN", "idx_string_not_null_btree", "code 284");
        this.tryQuery("testDropTable after drop table table scan", Maldacena.class, "string_not_null_none", "0", 0, "TABLE_SCAN", "no index", "code 284");
        this.executeSQL(createTableStatement);
        this.session.unloadSchema(Maldacena.class);
        this.session.makePersistent(this.session.newInstance(Maldacena.class, (Object)0));
        this.tryFind("testDropTable after create table find", Maldacena.class, 0, 1, "no error");
        this.tryQuery("testDropTable after create table unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "no error");
        this.tryQuery("testDropTable after create table index scan", Maldacena.class, "string_not_null_btree", "0", 1, "INDEX_SCAN", "idx_string_not_null_btree", "no error");
        this.tryQuery("testDropTable after create table table scan", Maldacena.class, "string_not_null_none", "0", 1, "TABLE_SCAN", "no index", "no error");
    }

    protected void testDropBtreeIndex() {
        this.tryFind("testDropBtreeIndex before drop btree index find", Maldacena.class, 0, 1, "no error");
        this.tryQuery("testDropBtreeIndex before drop btree index unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "no error");
        this.tryQuery("testDropHashIndex before drop btree index index scan", Maldacena.class, "string_not_null_btree", "0", 1, "INDEX_SCAN", "idx_string_not_null_btree", "no error");
        this.tryQuery("testDropHashIndex before drop btree index table scan", Maldacena.class, "string_not_null_none", "0", 1, "TABLE_SCAN", "no index", "no error");
        this.executeSQL(alterTableDropBtreeIndexStatement);
        this.tryFind("testDropBtreeIndex after drop btree index find", Maldacena.class, 0, 1, "no error");
        this.tryQuery("testDropBtreeIndex after drop btree index unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "no error");
        this.tryQuery("testDropBtreeIndex after drop btree index index scan", Maldacena.class, "string_not_null_btree", "0", 0, "INDEX_SCAN", "idx_string_not_null_btree", "code 284");
        this.tryQuery("testDropBtreeIndex after drop btree index table scan", Maldacena.class, "string_not_null_none", "0", 1, "TABLE_SCAN", "no index", "no error");
        this.executeSQL(alterTableAddBtreeIndexStatement);
        this.session.unloadSchema(Maldacena.class);
        this.tryFind("testDropBtreeIndex after add btree index find", Maldacena.class, 0, 1, "no error");
        this.tryQuery("testDropBtreeIndex after add btree index unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "no error");
        this.tryQuery("testDropBtreeIndex after add btree index index scan", Maldacena.class, "string_not_null_btree", "0", 1, "INDEX_SCAN", "idx_string_not_null_btree", "no error");
        this.tryQuery("testDropBtreeIndex after add btree index table scan", Maldacena.class, "string_not_null_none", "0", 1, "TABLE_SCAN", "no index", "no error");
    }

    protected void testDropHashIndex() {
        this.tryFind("testDropHashIndex before drop hash index find", Maldacena.class, 0, 1, "no error");
        this.executeSQL(alterTableDropHashIndexStatement);
        this.tryFind("testDropHashIndex after drop hash index find", Maldacena.class, 0, 1, "no error");
        this.tryQuery("testDropHashIndex after drop hash index unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "code 284");
        this.tryQuery("testDropHashIndex after drop hash index index scan", Maldacena.class, "string_not_null_btree", "0", 1, "INDEX_SCAN", "idx_string_not_null_btree", "no error");
        this.tryQuery("testDropHashIndex after drop hash index table scan", Maldacena.class, "string_not_null_none", "0", 1, "TABLE_SCAN", "no index", "no error");
        this.executeSQL(alterTableAddHashIndexStatement);
        this.session.unloadSchema(Maldacena.class);
        this.tryFind("testDropHashIndex after add hash index find", Maldacena.class, 0, 1, "no error");
        this.tryQuery("testDropHashIndex after add hash index unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "no error");
        this.tryQuery("testDropHashIndex after add hash index index scan", Maldacena.class, "string_not_null_btree", "0", 1, "INDEX_SCAN", "idx_string_not_null_btree", "no error");
        this.tryQuery("testDropHashIndex after add hash index table scan", Maldacena.class, "string_not_null_none", "0", 1, "TABLE_SCAN", "no index", "no error");
    }

    protected void testDropBtreeColumn() {
        this.tryFind("testDropBtreeColumn before drop btree column find", Maldacena.class, 0, 1, "no error");
        this.executeSQL(alterTableDropBtreeColumnStatement);
        this.tryFind("testDropBtreeColumn after drop btree column find", Maldacena.class, 0, 0, "code 284");
        this.tryQuery("testDropBtreeColumn after drop btree column unique key", Maldacena.class, "string_not_null_hash", "0", 0, "UNIQUE_KEY", "idx_string_not_null_hash", "284");
        this.tryQuery("testDropBtreeColumn after drop btree column index scan", Maldacena.class, "string_not_null_btree", "0", 0, "INDEX_SCAN", "idx_string_not_null_btree", "284");
        this.tryQuery("testDropBtreeColumn after drop btree column table scan", Maldacena.class, "string_not_null_none", "0", 0, "TABLE_SCAN", "no index", "code 284");
        this.executeSQL(alterTableAddBtreeColumnStatement);
        this.executeSQL(alterTableAddBtreeIndexStatement);
        this.session.unloadSchema(Maldacena.class);
        this.tryFind("testDropBtreeColumn after add btree index find", Maldacena.class, 0, 1, "no error");
        this.tryQuery("testDropBtreeColumn after add btree index unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "no error");
        this.tryQuery("testDropBtreeColumn after add btree index index scan", Maldacena.class, "string_not_null_btree", "0", 1, "INDEX_SCAN", "idx_string_not_null_btree", "no error");
        this.tryQuery("testDropBtreeColumn after add btree index table scan", Maldacena.class, "string_not_null_none", "0", 1, "TABLE_SCAN", "no index", "no error");
    }

    protected void testDropHashColumn() {
        this.tryFind("testDropHashColumn before drop hash column find", Maldacena.class, 0, 1, "no error");
        this.executeSQL(alterTableDropHashColumnStatement);
        this.tryFind("testDropHashColumn after drop hash column find", Maldacena.class, 0, 1, "code 284");
        this.tryQuery("testDropHashColumn after drop hash column unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "code 284");
        this.tryQuery("testDropHashColumn after drop hash column index scan", Maldacena.class, "string_not_null_btree", "0", 0, "INDEX_SCAN", "idx_string_not_null_btree", "code 284");
        this.tryQuery("testDropHashColumn after drop hash column table scan", Maldacena.class, "string_not_null_none", "0", 0, "TABLE_SCAN", "no index", "code 284");
        this.executeSQL(alterTableAddHashColumnStatement);
        this.executeSQL(alterTableAddHashIndexStatement);
        this.session.unloadSchema(Maldacena.class);
        this.tryFind("testDropHashColumn after add hash column find", Maldacena.class, 0, 1, "no error");
        this.tryQuery("testDropHashColumn after add hash column unique key", Maldacena.class, "string_not_null_hash", "0", 1, "UNIQUE_KEY", "idx_string_not_null_hash", "no error");
        this.tryQuery("testDropHashColumn after add hash column index scan", Maldacena.class, "string_not_null_btree", "0", 1, "INDEX_SCAN", "idx_string_not_null_btree", "no error");
        this.tryQuery("testDropHashColumn after add hash column table scan", Maldacena.class, "string_not_null_none", "0", 1, "TABLE_SCAN", "no index", "no error");
    }

    protected boolean tryFind(String string, Class<?> clazz, Object object, int n, String string2) {
        try {
            Object object2 = this.session.find(clazz, object);
            if (!string2.equals("no error")) {
                this.error(string + " unexpected success for find class: " + clazz.getName() + " key: " + object + " ");
            }
            if (n != 0 && object2 == null) {
                this.error(string + " row was not found for class: " + clazz.getName());
            }
            return true;
        }
        catch (ClusterJDatastoreException clusterJDatastoreException) {
            String string3 = clusterJDatastoreException.getMessage();
            if (string2 == null) {
                this.error(string + " unexpected failure for find class: " + clazz.getName() + " key: " + object + "  message: " + string3);
            } else {
                this.errorIfNotEqual(string + " wrong error message, expected contains " + string2 + " actual: " + string3, string3.contains(string2), true);
                if (clusterJDatastoreException.getMysqlCode() == 159) {
                    this.errorIfNotEqual(string + " wrong classification for mySqlCode 159", 4, clusterJDatastoreException.getClassification());
                }
            }
            return false;
        }
    }

    protected <T> QueryHandler<T> getQueryHandler(Class<T> clazz, String string, Object object) {
        QueryHandler queryHandler = new QueryHandler();
        queryHandler.qdt = this.session.getQueryBuilder().createQueryDefinition(clazz);
        queryHandler.field = queryHandler.qdt.get(string);
        queryHandler.param = queryHandler.qdt.param("param");
        queryHandler.qdt.where(queryHandler.field.equal(queryHandler.param));
        queryHandler.q = this.session.createQuery(queryHandler.qdt);
        queryHandler.q.setParameter("param", object);
        return queryHandler;
    }

    protected <T> boolean tryQuery(String string, Class<T> clazz, String string2, Object object, int n, String string3, String string4, String string5) {
        try {
            QueryHandler<T> queryHandler = this.getQueryHandler(clazz, string2, object);
            Map map = queryHandler.q.explain();
            this.errorIfNotEqual(string + " wrong scan type", string3, map.get("ScanType"));
            if (!string4.equals("no index")) {
                this.errorIfNotEqual(string + " wrong index used", string4, map.get("IndexUsed"));
            }
            List list = queryHandler.q.getResultList();
            this.errorIfNotEqual(string + " wrong number of result rows for query", n, list.size());
            if (!string5.equals("no error")) {
                this.error(string + " unexpected success for query by key class: " + clazz.getName() + " key: " + object + " ");
            }
            return true;
        }
        catch (ClusterJDatastoreException clusterJDatastoreException) {
            String string6 = clusterJDatastoreException.getMessage();
            if (string5.equals("no error")) {
                this.error(string + " unexpected failure for query by key class: " + clazz.getName() + " key: " + object + "  message: " + string6);
            } else {
                this.errorIfNotEqual(string + " wrong error message, expected contains " + string5 + " actual: " + string6, string6.contains(string5), true);
            }
            return false;
        }
    }

    @PersistenceCapable(table="maldacena")
    public static interface Maldacena {
        public int getId();

        public void setId(int var1);

        public String getString_not_null_hash();

        public void setString_not_null_hash(String var1);

        public String getString_not_null_btree();

        public void setString_not_null_btree(String var1);

        public String getString_not_null_both();

        public void setString_not_null_both(String var1);

        public String getString_not_null_none();

        public void setString_not_null_none(String var1);
    }

    protected class QueryHandler<T> {
        QueryDomainType<T> qdt;
        PredicateOperand field;
        PredicateOperand param;
        Query<T> q;

        protected QueryHandler() {
        }
    }
}

