/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import java.util.Arrays;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.LongIntStringIndex;

public class QueryMultiColumnIndexInTest
extends AbstractQueryTest {
    private static final int MULTI_RANGE_IN_ITERATIONS = 1;
    protected int PK_MODULUS = 3;
    protected long PRETTY_BIG_NUMBER = 1000000000000000L;

    @Override
    public Class<?> getInstanceType() {
        return LongIntStringIndex.class;
    }

    @Override
    protected boolean getCleanupAfterTest() {
        return true;
    }

    public void testInAndBetween() {
        this.inAndBetweenQuery("longix", new Object[]{1000000000000000L, 0L}, "intix", 1, 2, "idx_long_int_string", 3, 4, 5, 6, 7, 8);
        this.inAndBetweenQuery("longix", Arrays.asList(1000000000000000L, 0L), "stringix", "1", "4", "idx_long_int_string", 1, 2, 4, 5, 7, 8);
        this.failOnError();
    }

    public void testBetweenAndIn() {
        this.betweenAndInQuery("longix", 0L, 3000000000000000L, "intix", new Object[]{2, 0}, "idx_long_int_string", 0, 1, 2, 6, 7, 8, 9);
        this.betweenAndInQuery("longix", 0L, 1000000000000000L, "intix", Arrays.asList(2, 1), "idx_long_int_string", 3, 4, 5, 6, 7, 8);
        this.failOnError();
    }

    public void testPartialBoundsAndEqual() {
        this.greaterThanAnd1ExtraQuery("longix", 0, "intix", this.extraEqualPredicateProvider, 0, "idx_long_int_string", 9);
        this.greaterEqualAnd1ExtraQuery("longix", 0, "intix", this.extraEqualPredicateProvider, 0, "idx_long_int_string", 0, 1, 2, 9);
        this.lessThanAnd1ExtraQuery("longix", 1000000000000000L, "intix", this.extraEqualPredicateProvider, 0, "idx_long_int_string", 0, 1, 2);
        this.lessEqualAnd1ExtraQuery("longix", 1000000000000000L, "intix", this.extraEqualPredicateProvider, 0, "idx_long_int_string", 0, 1, 2, 9);
        this.failOnError();
    }

    public void testGapBoundsAndEqual() {
        this.greaterThanAnd1ExtraQuery("longix", 0, "stringix", this.extraEqualPredicateProvider, "0", "idx_long_int_string", 9);
        this.greaterEqualAnd1ExtraQuery("longix", 0, "stringix", this.extraEqualPredicateProvider, "0", "idx_long_int_string", 0, 3, 6, 9);
        this.lessThanAnd1ExtraQuery("longix", 1000000000000000L, "stringix", this.extraEqualPredicateProvider, "0", "idx_long_int_string", 0, 3, 6);
        this.lessEqualAnd1ExtraQuery("longix", 1000000000000000L, "stringix", this.extraEqualPredicateProvider, "0", "idx_long_int_string", 0, 3, 6, 9);
        this.failOnError();
    }

    public void testNegativeInParameter() {
        block3: {
            int[] nArray = new int[]{};
            try {
                this.inQuery("id", nArray, "PRIMARY", nArray);
                this.error("Query with ''in'' parameter of int[] type should fail.");
            }
            catch (ClusterJUserException clusterJUserException) {
                String string;
                if (this.getDebug()) {
                    clusterJUserException.printStackTrace();
                }
                if ((string = clusterJUserException.getMessage()).contains("id")) break block3;
                this.error("Query with ''in'' parameter of int[] type should fail.");
            }
        }
        this.failOnError();
    }

    public void testPrettyBigIn() {
        int n = 4096;
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = i;
        }
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        for (int i = 0; i < 1; ++i) {
            this.inQuery("iteration " + Integer.toString(i) + " ", "id", integerArray, "PRIMARY", nArray);
        }
        this.failOnError();
    }

    public void testNegativeInTooBig() {
        block4: {
            int n = 4097;
            Integer[] integerArray = new Integer[n];
            for (int i = 0; i < n; ++i) {
                integerArray[i] = i;
            }
            int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
            try {
                this.inQuery("id", integerArray, "PRIMARY", nArray);
                this.error("Query with more than 4096 elements should fail.");
            }
            catch (ClusterJUserException clusterJUserException) {
                String string;
                if (this.getDebug()) {
                    clusterJUserException.printStackTrace();
                }
                if ((string = clusterJUserException.getMessage()).contains("4097")) break block4;
                this.error("Query with more than 4096 elements should fail.");
            }
        }
        this.failOnError();
    }

    @Override
    protected void createInstances(int n) {
        for (int i = 0; i < n; ++i) {
            LongIntStringIndex longIntStringIndex = this.createInstance(i);
            this.instances.add(longIntStringIndex);
        }
    }

    protected LongIntStringIndex createInstance(int n) {
        LongIntStringIndex longIntStringIndex = (LongIntStringIndex)this.session.newInstance(LongIntStringIndex.class);
        longIntStringIndex.setId(n);
        longIntStringIndex.setLongix(this.getPK1(n));
        longIntStringIndex.setIntix(this.getPK2(n));
        longIntStringIndex.setStringix(this.getPK3(n));
        longIntStringIndex.setStringvalue(this.getValue(n));
        return longIntStringIndex;
    }

    protected long getPK1(int n) {
        return this.PRETTY_BIG_NUMBER * (long)(n / this.PK_MODULUS / this.PK_MODULUS % this.PK_MODULUS);
    }

    protected int getPK2(int n) {
        return n / this.PK_MODULUS % this.PK_MODULUS;
    }

    protected String getPK3(int n) {
        return "" + n % this.PK_MODULUS;
    }

    protected String getValue(int n) {
        return "Value " + n;
    }

    protected String toString(LongIntStringIndex longIntStringIndex) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LongIntStringIndex[");
        stringBuffer.append(longIntStringIndex.getId());
        stringBuffer.append("]: ");
        stringBuffer.append(longIntStringIndex.getLongix());
        stringBuffer.append(", ");
        stringBuffer.append(longIntStringIndex.getIntix());
        stringBuffer.append(", \"");
        stringBuffer.append(longIntStringIndex.getStringix());
        stringBuffer.append("\", \"");
        stringBuffer.append(longIntStringIndex.getStringvalue());
        stringBuffer.append("\".");
        return stringBuffer.toString();
    }
}

