/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.BlobTypes;
import testsuite.clusterj.model.IdBase;

public class QueryBlobTypesTest
extends AbstractQueryTest {
    protected BlobTypes[] instancesToUpdate = new BlobTypes[this.getNumberOfInstances()];

    @Override
    public Class<?> getInstanceType() {
        return BlobTypes.class;
    }

    @Override
    void createInstances(int n) {
        for (int i = 0; i < n; ++i) {
            BlobTypes blobTypes = (BlobTypes)this.session.newInstance(BlobTypes.class);
            blobTypes.setId(i);
            blobTypes.setId_null_none(i);
            blobTypes.setId_null_hash(i);
            blobTypes.setBlobbytes(this.getByteArray(i));
            this.instances.add(blobTypes);
        }
    }

    public void testIndexScan() {
        this.testSinglePredicateQueries("id", "PRIMARY");
        this.testUpdate(5);
        this.testUpdate(7);
        this.testDelete(5);
        this.testDelete(8);
        this.failOnError();
    }

    public void testUniqueIndexScan() {
        this.equalQuery("id_null_hash", "idx_id_null_hash", 5, 5);
        this.equalQuery("id_null_hash", "idx_id_null_hash", 20, new int[0]);
        this.failOnError();
    }

    public void testTableScan() {
        this.testSinglePredicateQueries("id_null_none", "none");
        this.failOnError();
    }

    protected byte[] getByteArray(int n) {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, (byte)n};
    }

    protected void testSinglePredicateQueries(String string, String string2) {
        this.equalQuery(string, string2, 5, 5);
        this.greaterEqualQuery(string, string2, 7, 7, 8, 9);
        this.greaterThanQuery(string, string2, 6, 7, 8, 9);
        this.lessEqualQuery(string, string2, 4, 4, 3, 2, 1, 0);
        this.lessThanQuery(string, string2, 4, 3, 2, 1, 0);
        this.betweenQuery(string, string2, 2, 4, 2, 3, 4);
        this.greaterEqualAndLessEqualQuery(string, string2, 2, 4, 2, 3, 4);
        this.greaterThanAndLessEqualQuery(string, string2, 2, 4, 3, 4);
        this.greaterEqualAndLessThanQuery(string, string2, 2, 4, 2, 3);
        this.greaterThanAndLessThanQuery(string, string2, 2, 4, 3);
        this.equalQuery(string, string2, 20, new int[0]);
        this.betweenQuery(string, string2, 21, 40, new int[0]);
    }

    protected void testUpdate(int n) {
        try {
            BlobTypes blobTypes = this.instancesToUpdate[n];
            byte[] byArray = blobTypes.getBlobbytes();
            byArray[0] = -128;
            blobTypes.setBlobbytes(byArray);
            this.session.updatePersistent((Object)blobTypes);
            BlobTypes blobTypes2 = (BlobTypes)this.session.find(BlobTypes.class, (Object)n);
            String string = this.compareBytes(byArray, blobTypes2.getBlobbytes());
            if (string != null) {
                this.error("Mismatch on update " + n + ": " + string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void testDelete(int n) {
        BlobTypes blobTypes = this.instancesToUpdate[n];
        BlobTypes blobTypes2 = null;
        this.session.deletePersistent((Object)blobTypes);
        blobTypes2 = (BlobTypes)this.session.find(BlobTypes.class, (Object)n);
        if (blobTypes2 != null) {
            this.error("Failed to delete " + n + ".");
        }
    }

    @Override
    protected void printResultInstance(IdBase idBase) {
        BlobTypes blobTypes = (BlobTypes)idBase;
        int n = blobTypes.getId();
        this.instancesToUpdate[n] = blobTypes;
        String string = this.compareBytes(this.getByteArray(n), blobTypes.getBlobbytes());
        if (string != null) {
            this.error("Mismatch reading instance " + n + ": " + string);
        }
    }
}

