/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.query.ParameterImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.query.PropertyImpl;
import com.mysql.clusterj.core.spi.DomainFieldHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.spi.SessionSPI;
import com.mysql.clusterj.core.spi.ValueHandlerBatching;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.IndexOperation;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryDomainTypeImpl<T>
implements QueryDomainType<T> {
    static final I18NHelper local = I18NHelper.getInstance(QueryDomainTypeImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(QueryDomainTypeImpl.class);
    protected Class<T> cls;
    protected DomainTypeHandler<T> domainTypeHandler;
    protected PredicateImpl where;
    protected Map<String, ParameterImpl> parameters = new HashMap<String, ParameterImpl>();
    protected Map<String, PropertyImpl> properties = new HashMap<String, PropertyImpl>();
    CandidateIndexImpl index = null;
    String[] orderingFields = null;
    Query.Ordering ordering = null;
    private ResultData resultDataEmpty = new ResultData(){

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public BigInteger getBigInteger(Column column) {
            return null;
        }

        @Override
        public BigInteger getBigInteger(int n) {
            return null;
        }

        @Override
        public Blob getBlob(Column column) {
            return null;
        }

        @Override
        public Blob getBlob(int n) {
            return null;
        }

        @Override
        public boolean getBoolean(Column column) {
            return false;
        }

        @Override
        public boolean getBoolean(int n) {
            return false;
        }

        @Override
        public boolean[] getBooleans(Column column) {
            return null;
        }

        @Override
        public boolean[] getBooleans(int n) {
            return null;
        }

        @Override
        public byte getByte(Column column) {
            return 0;
        }

        @Override
        public byte getByte(int n) {
            return 0;
        }

        @Override
        public byte[] getBytes(Column column) {
            return null;
        }

        @Override
        public byte[] getBytes(int n) {
            return null;
        }

        @Override
        public Column[] getColumns() {
            return null;
        }

        @Override
        public BigDecimal getDecimal(Column column) {
            return null;
        }

        @Override
        public BigDecimal getDecimal(int n) {
            return null;
        }

        @Override
        public double getDouble(Column column) {
            return 0.0;
        }

        @Override
        public double getDouble(int n) {
            return 0.0;
        }

        @Override
        public float getFloat(Column column) {
            return 0.0f;
        }

        @Override
        public float getFloat(int n) {
            return 0.0f;
        }

        @Override
        public int getInt(Column column) {
            return 0;
        }

        @Override
        public int getInt(int n) {
            return 0;
        }

        @Override
        public long getLong(Column column) {
            return 0L;
        }

        @Override
        public long getLong(int n) {
            return 0L;
        }

        @Override
        public Object getObject(Column column) {
            return null;
        }

        @Override
        public Object getObject(int n) {
            return null;
        }

        @Override
        public Boolean getObjectBoolean(Column column) {
            return null;
        }

        @Override
        public Boolean getObjectBoolean(int n) {
            return null;
        }

        @Override
        public Byte getObjectByte(Column column) {
            return null;
        }

        @Override
        public Byte getObjectByte(int n) {
            return null;
        }

        @Override
        public Double getObjectDouble(Column column) {
            return null;
        }

        @Override
        public Double getObjectDouble(int n) {
            return null;
        }

        @Override
        public Float getObjectFloat(Column column) {
            return null;
        }

        @Override
        public Float getObjectFloat(int n) {
            return null;
        }

        @Override
        public Integer getObjectInteger(Column column) {
            return null;
        }

        @Override
        public Integer getObjectInteger(int n) {
            return null;
        }

        @Override
        public Long getObjectLong(Column column) {
            return null;
        }

        @Override
        public Long getObjectLong(int n) {
            return null;
        }

        @Override
        public Short getObjectShort(Column column) {
            return null;
        }

        @Override
        public Short getObjectShort(int n) {
            return null;
        }

        @Override
        public short getShort(Column column) {
            return 0;
        }

        @Override
        public short getShort(int n) {
            return 0;
        }

        @Override
        public String getString(Column column) {
            return null;
        }

        @Override
        public String getString(int n) {
            return null;
        }
    };

    public QueryDomainTypeImpl(DomainTypeHandler<T> domainTypeHandler, Class<T> clazz) {
        this.cls = clazz;
        this.domainTypeHandler = domainTypeHandler;
    }

    public QueryDomainTypeImpl(DomainTypeHandler<T> domainTypeHandler) {
        this.domainTypeHandler = domainTypeHandler;
    }

    @Override
    public PredicateOperand get(String string) {
        PropertyImpl propertyImpl = this.properties.get(string);
        if (propertyImpl != null) {
            return propertyImpl;
        }
        DomainFieldHandler domainFieldHandler = this.domainTypeHandler.getFieldHandler(string);
        propertyImpl = new PropertyImpl(this, domainFieldHandler);
        this.properties.put(string, propertyImpl);
        return propertyImpl;
    }

    @Override
    public QueryDefinition<T> where(Predicate predicate) {
        if (predicate == null) {
            throw new ClusterJUserException(local.message("ERR_Query_Where_Must_Not_Be_Null"));
        }
        if (!(predicate instanceof PredicateImpl)) {
            throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
        }
        if (this.where != null) {
            this.where.unmarkParameters();
            this.where = null;
        }
        this.where = (PredicateImpl)predicate;
        this.where.markParameters();
        this.where.prepare();
        return this;
    }

    @Override
    public PredicateOperand param(String string) {
        ParameterImpl parameterImpl = this.parameters.get(string);
        if (parameterImpl != null) {
            return parameterImpl;
        }
        ParameterImpl parameterImpl2 = new ParameterImpl(this, string);
        this.parameters.put(string, parameterImpl2);
        return parameterImpl2;
    }

    @Override
    public Predicate not(Predicate predicate) {
        return predicate.not();
    }

    public List<T> getResultList(QueryExecutionContext queryExecutionContext, long l, long l2, Query.Ordering ordering, String[] stringArray) {
        this.assertAllParametersBound(queryExecutionContext);
        SessionSPI sessionSPI = queryExecutionContext.getSession();
        sessionSPI.startAutoTransaction();
        ArrayList<T> arrayList = new ArrayList<T>();
        try {
            ResultData resultData = this.getResultData(queryExecutionContext, l, l2, ordering, stringArray);
            while (resultData.next()) {
                T t = sessionSPI.newInstance(resultData, this.domainTypeHandler);
                arrayList.add(t);
            }
            sessionSPI.endAutoTransaction();
            return arrayList;
        }
        catch (ClusterJException clusterJException) {
            sessionSPI.failAutoTransaction();
            throw clusterJException;
        }
        catch (Exception exception) {
            sessionSPI.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Exception_On_Query"), exception);
        }
    }

    public ResultData getResultData(QueryExecutionContext queryExecutionContext, long l, long l2, Query.Ordering ordering, String[] stringArray) {
        SessionSPI sessionSPI = queryExecutionContext.getSession();
        this.ordering = ordering;
        this.orderingFields = stringArray;
        this.index = this.getCandidateIndex(queryExecutionContext);
        PredicateImpl.ScanType scanType = this.index.getScanType();
        if (logger.isDebugEnabled()) {
            logger.debug("using index " + this.index.getIndexName() + " with scanType " + (Object)((Object)scanType));
        }
        Map<String, Object> map = this.newExplain(this.index, scanType);
        queryExecutionContext.setExplain(map);
        ResultData resultData = null;
        Operation operation = null;
        try {
            switch (scanType) {
                case PRIMARY_KEY: {
                    if (l > 0L || l2 < 1L) {
                        return this.resultDataEmpty;
                    }
                    operation = sessionSPI.getSelectOperation(this.domainTypeHandler.getStoreTable());
                    operation.beginDefinition();
                    this.index.operationSetKeys(queryExecutionContext, operation);
                    this.domainTypeHandler.operationGetValues(operation);
                    operation.endDefinition();
                    resultData = operation.resultData();
                    break;
                }
                case INDEX_SCAN: {
                    Index index = this.index.getStoreIndex();
                    operation = this.index.isMultiRange() ? sessionSPI.getIndexScanOperationMultiRange(index, this.domainTypeHandler.getStoreTable()) : sessionSPI.getIndexScanOperation(index, this.domainTypeHandler.getStoreTable());
                    operation.beginDefinition();
                    if (ordering == null && (l != 0L || l2 != Long.MAX_VALUE)) {
                        ordering = Query.Ordering.ASCENDING;
                    }
                    ((ScanOperation)operation).setOrdering(ordering);
                    this.domainTypeHandler.operationGetValues(operation);
                    this.index.operationSetBounds(queryExecutionContext, (IndexScanOperation)operation);
                    if (this.where != null) {
                        this.where.filterCmpValue(queryExecutionContext, (IndexScanOperation)operation);
                    }
                    operation.endDefinition();
                    resultData = ((ScanOperation)operation).resultData(true, l, l2);
                    break;
                }
                case TABLE_SCAN: {
                    if (ordering != null) {
                        throw new ClusterJUserException(local.message("ERR_Cannot_Use_Ordering_With_Table_Scan"));
                    }
                    operation = sessionSPI.getTableScanOperation(this.domainTypeHandler.getStoreTable());
                    operation.beginDefinition();
                    this.domainTypeHandler.operationGetValues(operation);
                    if (this.where != null) {
                        this.where.filterCmpValue(queryExecutionContext, (ScanOperation)operation);
                    }
                    operation.endDefinition();
                    resultData = ((ScanOperation)operation).resultData(true, l, l2);
                    break;
                }
                case UNIQUE_KEY: {
                    if (l > 0L || l2 < 1L) {
                        return this.resultDataEmpty;
                    }
                    Index index = this.index.getStoreIndex();
                    operation = sessionSPI.getUniqueIndexOperation(index, this.domainTypeHandler.getStoreTable());
                    operation.beginDefinition();
                    this.where.operationEqual(queryExecutionContext, operation);
                    this.domainTypeHandler.operationGetValues(operation);
                    operation.endDefinition();
                    resultData = operation.resultData();
                    break;
                }
                default: {
                    sessionSPI.failAutoTransaction();
                    throw new ClusterJFatalInternalException(local.message("ERR_Illegal_Scan_Type", (Object)scanType));
                }
            }
        }
        catch (ClusterJException clusterJException) {
            if (operation != null) {
                operation.freeResourcesAfterExecute();
            }
            sessionSPI.failAutoTransaction();
            throw clusterJException;
        }
        catch (Exception exception) {
            if (operation != null) {
                operation.freeResourcesAfterExecute();
            }
            sessionSPI.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Exception_On_Query"), exception);
        }
        return resultData;
    }

    public int deletePersistentAll(QueryExecutionContext queryExecutionContext) {
        SessionSPI sessionSPI = queryExecutionContext.getSession();
        this.index = this.getCandidateIndex(queryExecutionContext);
        PredicateImpl.ScanType scanType = this.index.getScanType();
        Map<String, Object> map = this.newExplain(this.index, scanType);
        queryExecutionContext.setExplain(map);
        int n = 0;
        int n2 = 0;
        sessionSPI.startAutoTransaction();
        Operation operation = null;
        try {
            switch (scanType) {
                case PRIMARY_KEY: {
                    if (logger.isDetailEnabled()) {
                        logger.detail("Using delete by primary key.");
                    }
                    operation = sessionSPI.getDeleteOperation(this.domainTypeHandler.getStoreTable());
                    operation.beginDefinition();
                    this.index.operationSetKeys(queryExecutionContext, operation);
                    operation.endDefinition();
                    sessionSPI.executeNoCommit(false, true);
                    n2 = operation.errorCode();
                    n = n2 == 0 ? 1 : 0;
                    break;
                }
                case UNIQUE_KEY: {
                    Index index = this.index.getStoreIndex();
                    if (logger.isDetailEnabled()) {
                        logger.detail("Using delete by unique key  " + this.index.getIndexName());
                    }
                    operation = sessionSPI.getUniqueIndexDeleteOperation(index, this.domainTypeHandler.getStoreTable());
                    this.where.operationEqual(queryExecutionContext, operation);
                    sessionSPI.executeNoCommit(false, true);
                    n2 = operation.errorCode();
                    n = n2 == 0 ? 1 : 0;
                    break;
                }
                case INDEX_SCAN: {
                    Index index = this.index.getStoreIndex();
                    if (logger.isDetailEnabled()) {
                        logger.detail("Using delete by index scan with index " + this.index.getIndexName());
                    }
                    operation = sessionSPI.getIndexScanDeleteOperation(index, this.domainTypeHandler.getStoreTable());
                    this.domainTypeHandler.operationGetValues(operation);
                    this.index.operationSetBounds(queryExecutionContext, (IndexScanOperation)operation);
                    this.where.filterCmpValue(queryExecutionContext, (IndexScanOperation)operation);
                    n = sessionSPI.deletePersistentAll((IndexScanOperation)operation, false);
                    break;
                }
                case TABLE_SCAN: {
                    if (logger.isDetailEnabled()) {
                        logger.detail("Using delete by table scan");
                    }
                    operation = sessionSPI.getTableScanDeleteOperation(this.domainTypeHandler.getStoreTable());
                    this.domainTypeHandler.operationGetValues(operation);
                    if (this.where != null) {
                        this.where.filterCmpValue(queryExecutionContext, (ScanOperation)operation);
                    }
                    n = sessionSPI.deletePersistentAll((ScanOperation)operation, false);
                    break;
                }
                default: {
                    throw new ClusterJFatalInternalException(local.message("ERR_Illegal_Scan_Type", (Object)scanType));
                }
            }
            sessionSPI.endAutoTransaction();
            return n;
        }
        catch (ClusterJException clusterJException) {
            if (operation != null) {
                operation.freeResourcesAfterExecute();
            }
            sessionSPI.failAutoTransaction();
            throw clusterJException;
        }
        catch (Exception exception) {
            if (operation != null) {
                operation.freeResourcesAfterExecute();
            }
            sessionSPI.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Exception_On_Query"), exception);
        }
    }

    public long[] updatePersistentAll(QueryExecutionContext queryExecutionContext, ValueHandlerBatching valueHandlerBatching) {
        SessionSPI sessionSPI = queryExecutionContext.getSession();
        this.index = this.getCandidateIndex(queryExecutionContext);
        PredicateImpl.ScanType scanType = this.index.getScanType();
        Map<String, Object> map = this.newExplain(this.index, scanType);
        queryExecutionContext.setExplain(map);
        long[] lArray = null;
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        try {
            switch (scanType) {
                case PRIMARY_KEY: {
                    lArray = new long[valueHandlerBatching.getNumberOfStatements()];
                    sessionSPI.startAutoTransaction();
                    if (logger.isDetailEnabled()) {
                        logger.detail("Update by primary key.");
                    }
                    while (valueHandlerBatching.next()) {
                        Operation operation = sessionSPI.getUpdateOperation(this.domainTypeHandler.getStoreTable());
                        this.index.operationSetKeys(queryExecutionContext, operation);
                        this.domainTypeHandler.operationSetModifiedNonPKValues(valueHandlerBatching, operation);
                        arrayList.add(operation);
                    }
                    sessionSPI.endAutoTransaction();
                    if (sessionSPI.currentTransaction().isActive()) {
                        sessionSPI.executeNoCommit(false, true);
                    }
                    for (int i = 0; i < lArray.length; ++i) {
                        int n = ((Operation)arrayList.get(i)).errorCode();
                        lArray[i] = n == 0 ? 1 : 0;
                    }
                    break;
                }
                case UNIQUE_KEY: {
                    lArray = new long[valueHandlerBatching.getNumberOfStatements()];
                    sessionSPI.startAutoTransaction();
                    Index index = this.index.getStoreIndex();
                    if (logger.isDetailEnabled()) {
                        logger.detail("Update by unique key.");
                    }
                    while (valueHandlerBatching.next()) {
                        IndexOperation indexOperation = sessionSPI.getUniqueIndexUpdateOperation(index, this.domainTypeHandler.getStoreTable());
                        this.index.operationSetKeys(queryExecutionContext, indexOperation);
                        this.domainTypeHandler.operationSetModifiedNonPKValues(valueHandlerBatching, indexOperation);
                        arrayList.add(indexOperation);
                    }
                    sessionSPI.endAutoTransaction();
                    if (sessionSPI.currentTransaction().isActive()) {
                        sessionSPI.executeNoCommit(false, true);
                    }
                    for (int i = 0; i < lArray.length; ++i) {
                        int n = ((Operation)arrayList.get(i)).errorCode();
                        lArray[i] = n == 0 ? 1 : 0;
                    }
                    break;
                }
                case INDEX_SCAN: {
                    break;
                }
                case TABLE_SCAN: {
                    break;
                }
                default: {
                    throw new ClusterJFatalInternalException(local.message("ERR_Illegal_Scan_Type", (Object)scanType));
                }
            }
            return lArray;
        }
        catch (ClusterJException clusterJException) {
            for (Operation operation : arrayList) {
                operation.freeResourcesAfterExecute();
            }
            sessionSPI.failAutoTransaction();
            throw clusterJException;
        }
        catch (Exception exception) {
            for (Operation operation : arrayList) {
                operation.freeResourcesAfterExecute();
            }
            sessionSPI.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Exception_On_Query"), exception);
        }
    }

    protected CandidateIndexImpl[] createCandidateIndexes() {
        return this.domainTypeHandler.createCandidateIndexes();
    }

    public void explain(QueryExecutionContext queryExecutionContext) {
        this.assertAllParametersBound(queryExecutionContext);
        CandidateIndexImpl candidateIndexImpl = this.getCandidateIndex(queryExecutionContext);
        PredicateImpl.ScanType scanType = candidateIndexImpl.getScanType();
        Map<String, Object> map = this.newExplain(candidateIndexImpl, scanType);
        queryExecutionContext.setExplain(map);
    }

    private CandidateIndexImpl getCandidateIndex(QueryExecutionContext queryExecutionContext) {
        if (this.where == null) {
            CandidateIndexImpl[] candidateIndexImplArray;
            for (CandidateIndexImpl candidateIndexImpl : candidateIndexImplArray = this.domainTypeHandler.createCandidateIndexes()) {
                if (!candidateIndexImpl.containsAllOrderingFields(this.orderingFields)) continue;
                this.index = candidateIndexImpl;
                return this.index;
            }
            this.index = CandidateIndexImpl.getIndexForNullWhereClause();
        } else {
            this.index = this.where.getBestCandidateIndex(queryExecutionContext, this.orderingFields);
        }
        return this.index;
    }

    protected Map<String, Object> newExplain(CandidateIndexImpl candidateIndexImpl, PredicateImpl.ScanType scanType) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ScanType", scanType.toString());
        hashMap.put("IndexUsed", candidateIndexImpl.getIndexName());
        return hashMap;
    }

    protected void assertAllParametersBound(QueryExecutionContext queryExecutionContext) {
        if (this.where != null) {
            for (ParameterImpl parameterImpl : this.parameters.values()) {
                if (!parameterImpl.isMarkedAndUnbound(queryExecutionContext)) continue;
                throw new ClusterJUserException(local.message("ERR_Parameter_Not_Bound", (Object)parameterImpl.getName()));
            }
        }
    }

    @Override
    public Class<T> getType() {
        return this.cls;
    }
}

