/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Constants;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.core.SessionImpl;
import com.mysql.clusterj.core.metadata.DomainTypeHandlerFactoryImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandlerFactory;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.ClusterConnection;
import com.mysql.clusterj.core.store.ClusterConnectionService;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SessionFactoryImpl
implements SessionFactory,
Constants {
    static final I18NHelper local = I18NHelper.getInstance(SessionFactoryImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(SessionFactoryImpl.class);
    static final ClassLoader SESSION_FACTORY_IMPL_CLASS_LOADER = SessionFactoryImpl.class.getClassLoader();
    protected Map<?, ?> props;
    String CLUSTER_CONNECTION_SERVICE;
    String CLUSTER_CONNECT_STRING;
    int CLUSTER_CONNECT_TIMEOUT_MGM;
    int CLUSTER_CONNECT_RETRIES;
    int CLUSTER_CONNECT_DELAY;
    int CLUSTER_CONNECT_VERBOSE;
    int CLUSTER_CONNECT_TIMEOUT_BEFORE;
    int CLUSTER_CONNECT_TIMEOUT_AFTER;
    String CLUSTER_DATABASE;
    int CLUSTER_MAX_TRANSACTIONS;
    int CLUSTER_CONNECT_AUTO_INCREMENT_BATCH_SIZE;
    long CLUSTER_CONNECT_AUTO_INCREMENT_STEP;
    long CLUSTER_CONNECT_AUTO_INCREMENT_START;
    int[] CLUSTER_BYTE_BUFFER_POOL_SIZES;
    List<Integer> nodeIds;
    int connectionPoolSize;
    private static Map<Class<?>, Class<?>> proxyClassToDomainClass = new HashMap();
    protected static final Map<Class<?>, DomainTypeHandler<?>> typeToHandlerMap = new HashMap();
    DomainTypeHandlerFactory domainTypeHandlerFactory;
    protected static final Map<String, SessionFactoryImpl> sessionFactoryMap = new HashMap<String, SessionFactoryImpl>();
    final String key;
    private List<ClusterConnection> pooledConnections;
    protected ValueHandlerFactory smartValueHandlerFactory;

    protected ClusterConnectionService getClusterConnectionService() {
        return ClusterJHelper.getServiceInstance(ClusterConnectionService.class, this.CLUSTER_CONNECTION_SERVICE, SESSION_FACTORY_IMPL_CLASS_LOADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionFactoryImpl getSessionFactory(Map<?, ?> map) {
        int n = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connection.pool.size", 1);
        String string = SessionFactoryImpl.getSessionFactoryKey(map);
        SessionFactoryImpl sessionFactoryImpl = null;
        if (n != 0) {
            Map<String, SessionFactoryImpl> map2 = sessionFactoryMap;
            synchronized (map2) {
                sessionFactoryImpl = sessionFactoryMap.get(string);
                if (sessionFactoryImpl == null) {
                    sessionFactoryImpl = new SessionFactoryImpl(map);
                    sessionFactoryMap.put(string, sessionFactoryImpl);
                }
            }
        } else {
            sessionFactoryImpl = new SessionFactoryImpl(map);
        }
        return sessionFactoryImpl;
    }

    private static String getSessionFactoryKey(Map<?, ?> map) {
        String string = SessionFactoryImpl.getRequiredStringProperty(map, "com.mysql.clusterj.connectstring");
        String string2 = SessionFactoryImpl.getStringProperty(map, "com.mysql.clusterj.database", "test");
        return string + "+" + string2;
    }

    protected SessionFactoryImpl(Map<?, ?> map) {
        List<Integer> list;
        block5: {
            this.nodeIds = new ArrayList<Integer>();
            this.domainTypeHandlerFactory = new DomainTypeHandlerFactoryImpl();
            this.pooledConnections = new ArrayList<ClusterConnection>();
            this.props = map;
            this.key = SessionFactoryImpl.getSessionFactoryKey(map);
            this.connectionPoolSize = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connection.pool.size", 1);
            this.CLUSTER_CONNECT_STRING = SessionFactoryImpl.getRequiredStringProperty(map, "com.mysql.clusterj.connectstring");
            this.CLUSTER_CONNECT_RETRIES = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.retries", 4);
            this.CLUSTER_CONNECT_TIMEOUT_MGM = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.timeout.mgm", 30000);
            this.CLUSTER_CONNECT_DELAY = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.delay", 5);
            this.CLUSTER_CONNECT_VERBOSE = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.verbose", 0);
            this.CLUSTER_CONNECT_TIMEOUT_BEFORE = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.timeout.before", 30);
            this.CLUSTER_CONNECT_TIMEOUT_AFTER = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.timeout.after", 20);
            this.CLUSTER_DATABASE = SessionFactoryImpl.getStringProperty(map, "com.mysql.clusterj.database", "test");
            this.CLUSTER_MAX_TRANSACTIONS = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.max.transactions", 4);
            this.CLUSTER_CONNECT_AUTO_INCREMENT_BATCH_SIZE = SessionFactoryImpl.getIntProperty(map, "com.mysql.clusterj.connect.autoincrement.batchsize", 10);
            this.CLUSTER_CONNECT_AUTO_INCREMENT_STEP = SessionFactoryImpl.getLongProperty(map, "com.mysql.clusterj.connect.autoincrement.increment", 1L);
            this.CLUSTER_CONNECT_AUTO_INCREMENT_START = SessionFactoryImpl.getLongProperty(map, "com.mysql.clusterj.connect.autoincrement.offset", 1L);
            this.CLUSTER_CONNECTION_SERVICE = SessionFactoryImpl.getStringProperty(map, "com.mysql.clusterj.connection.service");
            this.CLUSTER_BYTE_BUFFER_POOL_SIZES = this.getByteBufferPoolSizes(map);
            this.createClusterConnectionPool();
            list = null;
            try {
                ArrayList arrayList = new ArrayList(this.pooledConnections.size());
                for (ClusterConnection clusterConnection : this.pooledConnections) {
                    arrayList.add(this.getSession(null));
                }
                list = this.getConnectionPoolSessionCounts();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Session session = (Session)iterator.next();
                    session.currentTransaction().begin();
                    session.currentTransaction().commit();
                    session.close();
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof ClusterJException)) break block5;
                logger.warn(local.message("ERR_Session_Factory_Impl_Failed_To_Complete_Transaction"));
                throw (ClusterJException)exception;
            }
        }
        for (Integer n : list) {
            if (n == 1) continue;
            throw new ClusterJFatalInternalException(local.message("ERR_Session_Counts_Wrong_Creating_Factory", (Object)list.toString()));
        }
    }

    protected void createClusterConnectionPool() {
        String[] stringArray;
        String string = SessionFactoryImpl.getStringProperty(this.props, "com.mysql.clusterj.connection.pool.nodeids");
        if (string != null) {
            for (String string2 : stringArray = string.split("[,; \t\n\r]+", 48)) {
                try {
                    int n = Integer.parseInt(string2);
                    this.nodeIds.add(n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ClusterJFatalUserException(local.message("ERR_Node_Ids_Format", (Object)string), numberFormatException);
                }
            }
            if (this.connectionPoolSize != 1) {
                if (this.nodeIds.size() == 1) {
                    for (int i = 1; i < this.connectionPoolSize; ++i) {
                        this.nodeIds.add(this.nodeIds.get(i - 1) + 1);
                    }
                }
                if (this.connectionPoolSize != this.nodeIds.size()) {
                    throw new ClusterJFatalUserException(local.message("ERR_Node_Ids_Must_Match_Connection_Pool_Size", (Object)string, (Object)this.connectionPoolSize));
                }
            } else {
                this.connectionPoolSize = this.nodeIds.size();
            }
        }
        stringArray = this.getClusterConnectionService();
        if (this.nodeIds.size() == 0) {
            for (int i = 0; i < this.connectionPoolSize; ++i) {
                this.createClusterConnection((ClusterConnectionService)stringArray, this.props, 0);
            }
        } else {
            for (int i = 0; i < this.connectionPoolSize; ++i) {
                this.createClusterConnection((ClusterConnectionService)stringArray, this.props, this.nodeIds.get(i));
            }
        }
        if (this.pooledConnections.size() != 0) {
            this.smartValueHandlerFactory = this.pooledConnections.get(0).getSmartValueHandlerFactory();
        }
    }

    protected ClusterConnection createClusterConnection(ClusterConnectionService clusterConnectionService, Map<?, ?> map, int n) {
        int[] nArray = this.getByteBufferPoolSizes(map);
        ClusterConnection clusterConnection = null;
        try {
            clusterConnection = clusterConnectionService.create(this.CLUSTER_CONNECT_STRING, n, this.CLUSTER_CONNECT_TIMEOUT_MGM);
            clusterConnection.setByteBufferPoolSizes(this.CLUSTER_BYTE_BUFFER_POOL_SIZES);
            clusterConnection.connect(this.CLUSTER_CONNECT_RETRIES, this.CLUSTER_CONNECT_DELAY, true);
            clusterConnection.waitUntilReady(this.CLUSTER_CONNECT_TIMEOUT_BEFORE, this.CLUSTER_CONNECT_TIMEOUT_AFTER);
        }
        catch (Exception exception) {
            for (ClusterConnection clusterConnection2 : this.pooledConnections) {
                clusterConnection2.close();
            }
            this.pooledConnections.clear();
            throw new ClusterJFatalUserException(local.message("ERR_Connecting", (Object)map), exception);
        }
        this.pooledConnections.add(clusterConnection);
        clusterConnection.initializeAutoIncrement(new long[]{this.CLUSTER_CONNECT_AUTO_INCREMENT_BATCH_SIZE, this.CLUSTER_CONNECT_AUTO_INCREMENT_STEP, this.CLUSTER_CONNECT_AUTO_INCREMENT_START});
        return clusterConnection;
    }

    int[] getByteBufferPoolSizes(Map<?, ?> map) {
        String string = SessionFactoryImpl.getStringProperty(map, "com.mysql.clusterj.byte.buffer.pool.sizes", "256, 10240, 102400, 1048576");
        String[] stringArray = string.split("[,; \t\n\r]+", 48);
        int n = stringArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ClusterJFatalUserException(local.message("ERR_Byte_Buffer_Pool_Sizes_Format", (Object)string), numberFormatException);
            }
        }
        return nArray;
    }

    @Override
    public Session getSession() {
        return this.getSession(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(Map map) {
        ClusterConnection clusterConnection = this.getClusterConnectionFromPool();
        try {
            Db db = null;
            Object object = this;
            synchronized (object) {
                this.checkConnection(clusterConnection);
                db = clusterConnection.createDb(this.CLUSTER_DATABASE, this.CLUSTER_MAX_TRANSACTIONS);
            }
            object = db.getDictionary();
            return new SessionImpl(this, map, db, (Dictionary)object);
        }
        catch (ClusterJException clusterJException) {
            throw clusterJException;
        }
        catch (Exception exception) {
            throw new ClusterJFatalException(local.message("ERR_Create_Ndb"), exception);
        }
    }

    private ClusterConnection getClusterConnectionFromPool() {
        if (this.connectionPoolSize <= 1) {
            return this.pooledConnections.get(0);
        }
        ClusterConnection clusterConnection = null;
        int n = Integer.MAX_VALUE;
        for (ClusterConnection clusterConnection2 : this.pooledConnections) {
            int n2 = clusterConnection2.dbCount();
            if (n2 >= n) continue;
            n = n2;
            clusterConnection = clusterConnection2;
        }
        return clusterConnection;
    }

    private void checkConnection(ClusterConnection clusterConnection) {
        if (clusterConnection == null) {
            throw new ClusterJUserException(local.message("ERR_Session_Factory_Closed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> DomainTypeHandler<T> getDomainTypeHandler(Class<T> clazz) {
        Map<Class<?>, DomainTypeHandler<?>> map = typeToHandlerMap;
        synchronized (map) {
            DomainTypeHandler<?> domainTypeHandler = typeToHandlerMap.get(clazz);
            return domainTypeHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> DomainTypeHandler<T> getDomainTypeHandler(Class<T> clazz, Dictionary dictionary) {
        Map<Class<?>, DomainTypeHandler<?>> map = typeToHandlerMap;
        synchronized (map) {
            DomainTypeHandler<Object> domainTypeHandler = typeToHandlerMap.get(clazz);
            if (logger.isDetailEnabled()) {
                logger.detail("DomainTypeToHandler for " + clazz.getName() + "(" + clazz + ") returned " + domainTypeHandler);
            }
            if (domainTypeHandler == null) {
                domainTypeHandler = this.domainTypeHandlerFactory.createDomainTypeHandler(clazz, dictionary, this.smartValueHandlerFactory);
                if (logger.isDetailEnabled()) {
                    logger.detail("createDomainTypeHandler for " + clazz.getName() + "(" + clazz + ") returned " + domainTypeHandler);
                }
                typeToHandlerMap.put(clazz, domainTypeHandler);
                Class<Object> clazz2 = domainTypeHandler.getProxyClass();
                if (clazz2 != null) {
                    proxyClassToDomainClass.put(clazz2, clazz);
                }
            }
            return domainTypeHandler;
        }
    }

    public <T> DomainTypeHandler<T> getDomainTypeHandler(T t, Dictionary dictionary) {
        Class<T> clazz = SessionFactoryImpl.getClassForProxy(t);
        DomainTypeHandler<T> domainTypeHandler = SessionFactoryImpl.getDomainTypeHandler(clazz);
        if (domainTypeHandler != null) {
            return domainTypeHandler;
        }
        return this.getDomainTypeHandler((T)clazz, dictionary);
    }

    protected static <T> Class<T> getClassForProxy(T t) {
        Class<?> clazz = t.getClass();
        if (Proxy.isProxyClass(clazz)) {
            clazz = proxyClassToDomainClass.get(clazz);
        }
        return clazz;
    }

    public <T> T newInstance(Class<T> clazz, Dictionary dictionary, Db db) {
        DomainTypeHandler<Class<T>> domainTypeHandler = this.getDomainTypeHandler((T)clazz, dictionary);
        return (T)domainTypeHandler.newInstance(db);
    }

    public Table getTable(String string, Dictionary dictionary) {
        Table table;
        try {
            table = dictionary.getTable(string);
        }
        catch (Exception exception) {
            throw new ClusterJFatalInternalException(local.message("ERR_Get_Table"), exception);
        }
        return table;
    }

    protected static String getStringProperty(Map<?, ?> map, String string) {
        return (String)map.get(string);
    }

    protected static String getStringProperty(Map<?, ?> map, String string, String string2) {
        String string3 = (String)map.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    protected static String getRequiredStringProperty(Map<?, ?> map, String string) {
        String string2 = (String)map.get(string);
        if (string2 == null) {
            throw new ClusterJFatalUserException(local.message("ERR_NullProperty", (Object)string));
        }
        return string2;
    }

    protected static int getIntProperty(Map<?, ?> map, String string, int n) {
        Object obj = map.get(string);
        if (obj == null) {
            return n;
        }
        if (Number.class.isAssignableFrom(obj.getClass())) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                int n2 = Integer.parseInt((String)obj);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ClusterJFatalUserException(local.message("ERR_NumericFormat", (Object)string, obj));
            }
        }
        throw new ClusterJUserException(local.message("ERR_NumericFormat", (Object)string, obj));
    }

    protected static long getLongProperty(Map<?, ?> map, String string, long l) {
        Object obj = map.get(string);
        if (obj == null) {
            return l;
        }
        if (Number.class.isAssignableFrom(obj.getClass())) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                long l2 = Long.parseLong((String)obj);
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ClusterJFatalUserException(local.message("ERR_NumericFormat", (Object)string, obj));
            }
        }
        throw new ClusterJUserException(local.message("ERR_NumericFormat", (Object)string, obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        for (ClusterConnection clusterConnection : this.pooledConnections) {
            clusterConnection.close();
        }
        this.pooledConnections.clear();
        Map<String, SessionFactoryImpl> map = sessionFactoryMap;
        synchronized (map) {
            sessionFactoryMap.remove(this.key);
        }
    }

    public void setDomainTypeHandlerFactory(DomainTypeHandlerFactory domainTypeHandlerFactory) {
        this.domainTypeHandlerFactory = domainTypeHandlerFactory;
    }

    public DomainTypeHandlerFactory getDomainTypeHandlerFactory() {
        return this.domainTypeHandlerFactory;
    }

    @Override
    public List<Integer> getConnectionPoolSessionCounts() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (ClusterConnection clusterConnection : this.pooledConnections) {
            arrayList.add(clusterConnection.dbCount());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String unloadSchema(Class<?> clazz, Dictionary dictionary) {
        Map<Class<?>, DomainTypeHandler<?>> map = typeToHandlerMap;
        synchronized (map) {
            String string = null;
            DomainTypeHandler<?> domainTypeHandler = typeToHandlerMap.remove(clazz);
            if (domainTypeHandler != null && (string = domainTypeHandler.getTableName()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing dictionary entry for table " + string + " for class " + clazz.getName());
                }
                dictionary.removeCachedTable(string);
                for (ClusterConnection clusterConnection : this.pooledConnections) {
                    clusterConnection.unloadSchema(string);
                }
            }
            return string;
        }
    }
}

