/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.Map;
import java.util.Properties;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class DefaultConnectValuesTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 1;

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createEmployeeInstances(1);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Employee.class);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    @Override
    protected Properties modifyProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)props);
        properties.remove("com.mysql.clusterj.connect.delay");
        properties.remove("com.mysql.clusterj.connect.retries");
        properties.remove("com.mysql.clusterj.connect.timeout.after");
        properties.remove("com.mysql.clusterj.connect.timeout.before");
        properties.remove("com.mysql.clusterj.connect.verbose");
        properties.remove("com.mysql.clusterj.database");
        properties.remove("com.mysql.clusterj.max.transactions");
        return properties;
    }

    public void testFind() {
        int n;
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        int n2 = 0;
        for (n = 0; n < 1; ++n) {
            this.session.makePersistent(this.employees.get(n));
            ++n2;
        }
        this.tx.commit();
        this.tx.begin();
        for (n = 0; n < 1; ++n) {
            Employee employee = (Employee)this.session.find(Employee.class, (Object)n);
            this.consistencyCheck(employee);
            int n3 = employee.getId();
            if (n3 == n) continue;
            this.error("Expected Employee.id " + n + " but got " + n3);
        }
        this.tx.commit();
        this.failOnError();
    }
}

