/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.metadata.DomainTypeHandlerImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandlerFactory;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.util.List;

public class DomainTypeHandlerFactoryImpl
implements DomainTypeHandlerFactory {
    static final I18NHelper local = I18NHelper.getInstance(DomainTypeHandlerFactoryImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(DomainTypeHandlerFactoryImpl.class);
    static final ClassLoader DOMAIN_TYPE_HANDLER_FACTORY_IMPL_CLASS_LOADER = DomainTypeHandlerFactoryImpl.class.getClassLoader();
    protected static List<DomainTypeHandlerFactory> domainTypeHandlerFactories;
    protected static StringBuffer domainTypeHandlerFactoryErrorMessages;

    @Override
    public <T> DomainTypeHandler<T> createDomainTypeHandler(Class<T> clazz, Dictionary dictionary, ValueHandlerFactory valueHandlerFactory) {
        DomainTypeHandler<T> domainTypeHandler = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (DomainTypeHandlerFactory object : domainTypeHandlerFactories) {
            try {
                stringBuffer.append("Trying factory ");
                stringBuffer.append(object.toString());
                stringBuffer.append("\n");
                domainTypeHandler = object.createDomainTypeHandler(clazz, dictionary, valueHandlerFactory);
                if (domainTypeHandler == null) continue;
                return domainTypeHandler;
            }
            catch (Exception exception) {
                stringBuffer.append("Caught exception: ");
                stringBuffer.append(exception.toString());
                stringBuffer.append("\n");
            }
        }
        try {
            stringBuffer.append("Trying standard factory com.mysql.clusterj.core.metadata.DomainTypeHandlerImpl.\n");
            domainTypeHandler = new DomainTypeHandlerImpl<T>(clazz, dictionary, valueHandlerFactory);
            DomainTypeHandlerImpl<T> domainTypeHandlerImpl = domainTypeHandler;
            return domainTypeHandlerImpl;
        }
        catch (ClusterJException clusterJException) {
            stringBuffer.append(clusterJException.toString());
            throw clusterJException;
        }
        catch (Exception exception) {
            stringBuffer.append(exception.toString());
            throw new ClusterJUserException(stringBuffer.toString(), exception);
        }
        finally {
            String string;
            if (domainTypeHandler == null && (string = DomainTypeHandlerImpl.getTableName(clazz)) != null) {
                logger.info(local.message("MSG_Removing_Schema", (Object)string, (Object)clazz.getName()));
                dictionary.removeCachedTable(string);
            }
        }
    }

    static {
        domainTypeHandlerFactoryErrorMessages = new StringBuffer();
        domainTypeHandlerFactories = ClusterJHelper.getServiceInstances(DomainTypeHandlerFactory.class, DOMAIN_TYPE_HANDLER_FACTORY_IMPL_CLASS_LOADER, domainTypeHandlerFactoryErrorMessages);
        logger.info("Found " + domainTypeHandlerFactories.size() + " DomainTypeHandlerFactories");
        for (DomainTypeHandlerFactory domainTypeHandlerFactory : domainTypeHandlerFactories) {
            logger.info(domainTypeHandlerFactory.toString());
        }
    }
}

