/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.ColumnType;
import com.mysql.clusterj.DynamicObject;
import java.nio.ByteBuffer;
import org.junit.Ignore;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.IdBase;

@Ignore
public class StressTest
extends AbstractClusterJModelTest {
    protected static final Runtime rt = Runtime.getRuntime();
    private static final int NUMBER_TO_INSERT = 4000;
    private static final int ITERATIONS = 7;
    private static final int ITERATIONS_TO_DROP = 3;
    private static final String STRESS_TEST_TABLE_PROPERTY_NAME = "com.mysql.clusterj.StressTestTable";
    private static String tableName = ClusterJHelper.getStringProperty((String)"com.mysql.clusterj.StressTestTable", (String)"stress");
    private ColumnMetadata[] columnMetadatas;
    private ColumnMetadata keyMetadata;
    private Timer timer = new Timer();
    private static int BYTES_LENGTH = 12000;
    private static ByteBuffer BYTES = ByteBuffer.allocate(BYTES_LENGTH);
    private static final byte[] DIGITS;
    private static int STRING_LENGTH;
    private static String STRING;

    @Override
    Class<? extends IdBase> getModelClass() {
        return Stress.class;
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.session.deletePersistentAll(Stress.class);
        this.columnMetadatas = ((Stress)this.session.newInstance(Stress.class)).columnMetadata();
        this.findKeyMetadata();
    }

    public void testIndy() {
        this.insAattr_indy();
        this.getA_indy();
        this.delA_indy();
    }

    public void testEach() {
        this.insAattr_each();
        this.getA_each();
        this.delA_each();
    }

    public void testBulk() {
        this.insAattr_bulk();
        this.getA_bulk();
        this.delA_bulk();
    }

    public void insAattr_indy() {
        long l = 0L;
        for (int i = 0; i < 7; ++i) {
            if (this.tx.isActive()) {
                this.tx.rollback();
            }
            this.session.deletePersistentAll(Stress.class);
            StressTest.gc();
            this.timer.start();
            for (int j = 0; j < 4000; ++j) {
                Stress stress = this.createObject(j);
                this.session.makePersistent((Object)stress);
            }
            this.timer.stop();
            if (i >= 3) {
                l += this.timer.time();
            }
            System.out.println("insAattr_indy: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + l / 4L + "\n");
    }

    public void insAattr_each() {
        long l = 0L;
        for (int i = 0; i < 7; ++i) {
            if (this.tx.isActive()) {
                this.tx.rollback();
            }
            this.session.deletePersistentAll(Stress.class);
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int j = 0; j < 4000; ++j) {
                Stress stress = this.createObject(j);
                this.session.makePersistent((Object)stress);
                this.session.flush();
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                l += this.timer.time();
            }
            System.out.println("insAattr_each: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + l / 4L + "\n");
    }

    public void insAattr_bulk() {
        long l = 0L;
        for (int i = 0; i < 7; ++i) {
            if (this.tx.isActive()) {
                this.tx.rollback();
            }
            this.session.deletePersistentAll(Stress.class);
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int j = 0; j < 4000; ++j) {
                Stress stress = this.createObject(j);
                this.session.makePersistent((Object)stress);
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                l += this.timer.time();
            }
            System.out.println("insAattr_bulk: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + l / 4L + "\n");
    }

    public void getA_indy() {
        long l = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            for (int j = 0; j < 4000; ++j) {
                this.session.find(Stress.class, this.createKey(j));
            }
            this.timer.stop();
            if (i >= 3) {
                l += this.timer.time();
            }
            System.out.println("getA_indy: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + l / 4L + "\n");
    }

    public void getA_each() {
        long l = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int j = 0; j < 4000; ++j) {
                this.session.find(Stress.class, this.createKey(j));
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                l += this.timer.time();
            }
            System.out.println("getA_each: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + l / 4L + "\n");
    }

    public void getA_bulk() {
        long l = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int j = 0; j < 4000; ++j) {
                Stress stress = (Stress)this.session.newInstance(Stress.class, this.createKey(j));
                this.session.load((Object)stress);
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                l += this.timer.time();
            }
            System.out.println("getA_bulk: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + l / 4L + "\n");
    }

    public void delA_indy() {
        long l = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            for (int j = 0; j < 4000; ++j) {
                this.session.deletePersistent(Stress.class, this.createKey(j));
            }
            this.timer.stop();
            if (i >= 3) {
                l += this.timer.time();
            }
            System.out.println("delA_indy: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + l / 4L + "\n");
    }

    public void delA_each() {
        long l = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int j = 0; j < 4000; ++j) {
                this.session.deletePersistent(Stress.class, this.createKey(j));
                this.session.flush();
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                l += this.timer.time();
            }
            System.out.println("delA_each: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + l / 4L + "\n");
    }

    public void delA_bulk() {
        long l = 0L;
        for (int i = 0; i < 7; ++i) {
            StressTest.gc();
            this.timer.start();
            this.session.currentTransaction().begin();
            for (int j = 0; j < 4000; ++j) {
                this.session.deletePersistent(Stress.class, this.createKey(j));
            }
            this.session.currentTransaction().commit();
            this.timer.stop();
            if (i >= 3) {
                l += this.timer.time();
            }
            System.out.println("delA_bulk: " + this.timer.time());
        }
        System.out.println("Excluding 3 Average: " + l / 4L + "\n");
    }

    protected Stress createObject(int n) {
        Stress stress = (Stress)this.session.newInstance(Stress.class);
        for (int i = 0; i < this.columnMetadatas.length; ++i) {
            Object object = null;
            ColumnMetadata columnMetadata = this.columnMetadatas[i];
            Class clazz = columnMetadata.javaType();
            int n2 = columnMetadata.maximumLength();
            if (columnMetadata.isPrimaryKey()) {
                object = this.createKey(n);
            } else if (Integer.TYPE == clazz) {
                object = n + i;
            } else if (Long.TYPE == clazz) {
                object = (long)(n + i);
            } else if (Float.TYPE == clazz) {
                object = Float.valueOf(n + i);
            } else if (Double.TYPE == clazz) {
                object = (double)(n + i);
            } else if (Short.TYPE == clazz) {
                object = (short)(n + i);
            } else if (Byte.TYPE == clazz) {
                object = (byte)(n + i);
            } else if (Integer.class == clazz) {
                object = n + i;
            } else if (Long.class == clazz) {
                object = (long)(n + i);
            } else if (Float.class == clazz) {
                object = Float.valueOf(n + i);
            } else if (Double.class == clazz) {
                object = (double)(n + i);
            } else if (Short.class == clazz) {
                object = (short)(n + i);
            } else if (Byte.class == clazz) {
                object = (byte)(n + i);
            } else if (String.class == clazz) {
                object = STRING.substring(n + i, n + i + n2);
            } else if (byte[].class == clazz) {
                object = new byte[n2];
                BYTES.position(n + i);
                BYTES.get((byte[])object);
            } else {
                throw new ClusterJFatalUserException("Unsupported column type " + clazz.getName() + " for column " + columnMetadata.name());
            }
            stress.set(i, object);
        }
        return stress;
    }

    private Object createKey(int n) {
        Object object = null;
        Class clazz = this.keyMetadata.javaType();
        int n2 = this.keyMetadata.maximumLength();
        if (Integer.TYPE == clazz) {
            object = n;
        } else if (Long.TYPE == clazz) {
            object = (long)n;
        } else if (String.class == clazz) {
            object = String.valueOf(n);
        } else if (byte[].class == clazz) {
            String string = String.valueOf(n);
            if (this.keyMetadata.columnType() == ColumnType.Binary) {
                object = new byte[n2];
            } else if (this.keyMetadata.columnType() == ColumnType.Varbinary) {
                object = new byte[string.length()];
            }
            this.convertToBytes((byte[])object, string);
            if (this.debug) {
                System.out.println("Key: " + this.dump((byte[])object));
            }
        } else {
            throw new ClusterJFatalUserException("Unsupported column type " + clazz.getName() + " for column " + this.keyMetadata.name());
        }
        return object;
    }

    private void findKeyMetadata() {
        for (ColumnMetadata columnMetadata : this.columnMetadatas) {
            if (!columnMetadata.isPrimaryKey()) continue;
            if (this.keyMetadata != null) {
                throw new RuntimeException("Compound primary keys are not supported.");
            }
            this.keyMetadata = columnMetadata;
        }
    }

    private String dump(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append("0123456789".charAt(byArray[i] - 48));
        }
        return stringBuilder.toString();
    }

    private void convertToBytes(byte[] byArray, String string) {
        int n = string.length();
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (n-- > 0) {
                int n2 = string.charAt(n) - 48;
                byArray[i] = DIGITS[n2];
                continue;
            }
            byArray[i] = 48;
        }
    }

    private static void gc() {
        for (int i = 0; i < 10; ++i) {
            long l;
            long l2 = rt.freeMemory();
            do {
                l = l2;
                rt.runFinalization();
                rt.gc();
            } while ((l2 = rt.freeMemory()) > l);
        }
    }

    static {
        for (int i = 0; i < BYTES_LENGTH; ++i) {
            BYTES.put((byte)(i % 32 + 65));
        }
        DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        STRING_LENGTH = 12000;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < STRING_LENGTH; ++i) {
            stringBuilder.append((byte)(i % 32 + 65));
        }
        STRING = stringBuilder.toString();
    }

    private static class Timer {
        private long time;

        private Timer() {
        }

        public void start() {
            this.time = System.nanoTime() / 1000000L;
        }

        public long stop() {
            this.time = System.nanoTime() / 1000000L - this.time;
            return this.time;
        }

        public long time() {
            return this.time;
        }
    }

    public static class Stress
    extends DynamicObject
    implements IdBase {
        public String table() {
            System.out.println("Stress table being used: " + tableName);
            return tableName;
        }

        @Override
        public int getId() {
            return (Integer)this.get(0);
        }

        @Override
        public void setId(int n) {
            this.set(0, n);
        }
    }
}

