/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.query;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.query.InPredicateImpl;
import com.mysql.clusterj.core.query.PredicateImpl;
import com.mysql.clusterj.core.spi.QueryExecutionContext;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.util.ArrayList;

public final class CandidateIndexImpl {
    static final I18NHelper local = I18NHelper.getInstance(CandidateIndexImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(CandidateIndexImpl.class);
    private String className = "none";
    private Index storeIndex;
    private String indexName = "none";
    private boolean unique;
    private boolean multiRange = false;
    private CandidateColumnImpl[] candidateColumns = null;
    private PredicateImpl.ScanType scanType = PredicateImpl.ScanType.TABLE_SCAN;
    private int fieldScore = 1;
    protected int score = 0;
    private boolean canBound = true;
    static CandidateIndexImpl indexForNullWhereClause = new CandidateIndexImpl();
    CandidateColumnImpl lastLowerBoundColumn = null;
    CandidateColumnImpl lastUpperBoundColumn = null;
    private final int BOUND_STATUS_NO_BOUND_DONE = 0;
    private final int BOUND_STATUS_LOWER_BOUND_DONE = 1;
    private final int BOUND_STATUS_UPPER_BOUND_DONE = 2;
    private final int BOUND_STATUS_BOTH_BOUNDS_DONE = 3;

    public CandidateIndexImpl(String string, Index index, boolean bl, AbstractDomainFieldHandlerImpl[] abstractDomainFieldHandlerImplArray) {
        if (logger.isDebugEnabled()) {
            logger.debug("className: " + string + " storeIndex: " + index.getName() + " unique: " + Boolean.toString(bl) + " fields: " + this.toString(abstractDomainFieldHandlerImplArray));
        }
        this.className = string;
        this.storeIndex = index;
        this.indexName = index.getName();
        this.unique = bl;
        this.candidateColumns = new CandidateColumnImpl[abstractDomainFieldHandlerImplArray.length];
        if (abstractDomainFieldHandlerImplArray.length == 1) {
            this.fieldScore = abstractDomainFieldHandlerImplArray[0].getColumnNames().length;
        }
        int n = 0;
        for (AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl : abstractDomainFieldHandlerImplArray) {
            CandidateColumnImpl candidateColumnImpl = new CandidateColumnImpl(abstractDomainFieldHandlerImpl);
            this.candidateColumns[n++] = candidateColumnImpl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.toString());
        }
    }

    private String toString(AbstractDomainFieldHandlerImpl[] abstractDomainFieldHandlerImplArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 91;
        for (AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl : abstractDomainFieldHandlerImplArray) {
            stringBuilder.append((char)n);
            stringBuilder.append(abstractDomainFieldHandlerImpl.getName());
            n = 32;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static CandidateIndexImpl getIndexForNullWhereClause() {
        return indexForNullWhereClause;
    }

    protected CandidateIndexImpl() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CandidateIndexImpl for class: ");
        stringBuilder.append(this.className);
        stringBuilder.append(" index: ");
        stringBuilder.append(this.indexName);
        stringBuilder.append(" unique: ");
        stringBuilder.append(this.unique);
        if (this.candidateColumns != null) {
            for (CandidateColumnImpl candidateColumnImpl : this.candidateColumns) {
                stringBuilder.append(" field: ");
                stringBuilder.append(candidateColumnImpl.domainFieldHandler.getName());
            }
        } else {
            stringBuilder.append(" no fields.");
        }
        return stringBuilder.toString();
    }

    public void markLowerBound(int n, PredicateImpl predicateImpl, boolean bl) {
        if (this.candidateColumns != null) {
            this.candidateColumns[n].markLowerBound(predicateImpl, bl);
        }
    }

    public void markUpperBound(int n, PredicateImpl predicateImpl, boolean bl) {
        if (this.candidateColumns != null) {
            this.candidateColumns[n].markUpperBound(predicateImpl, bl);
        }
    }

    public void markEqualBound(int n, PredicateImpl predicateImpl) {
        if (this.candidateColumns != null) {
            this.candidateColumns[n].markEqualBound(predicateImpl);
        }
    }

    public void markInBound(int n, InPredicateImpl inPredicateImpl) {
        if (this.candidateColumns != null) {
            this.candidateColumns[n].markInBound(inPredicateImpl);
        }
    }

    String getIndexName() {
        return this.indexName;
    }

    synchronized void score() {
        this.score = 0;
        if (this.candidateColumns == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.unique) {
            for (CandidateColumnImpl candidateColumnImpl : this.candidateColumns) {
                if (candidateColumnImpl.equalBound) continue;
                return;
            }
            this.scanType = "PRIMARY".equals(this.indexName) ? PredicateImpl.ScanType.PRIMARY_KEY : PredicateImpl.ScanType.UNIQUE_KEY;
            this.score = 100;
            return;
        }
        boolean bl3 = true;
        for (CandidateColumnImpl candidateColumnImpl : this.candidateColumns) {
            if (candidateColumnImpl.equalBound) {
                this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
                if (!bl) {
                    this.score += this.fieldScore;
                    this.lastLowerBoundColumn = candidateColumnImpl;
                }
                if (!bl2) {
                    this.score += this.fieldScore;
                    this.lastUpperBoundColumn = candidateColumnImpl;
                }
            } else if (candidateColumnImpl.inBound) {
                this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
                if (bl3) {
                    this.multiRange = true;
                }
                if (!bl) {
                    this.score += this.fieldScore;
                    this.lastLowerBoundColumn = candidateColumnImpl;
                }
                if (!bl2) {
                    this.score += this.fieldScore;
                    this.lastUpperBoundColumn = candidateColumnImpl;
                }
            } else if (!bl || !bl2) {
                boolean bl4 = candidateColumnImpl.hasLowerBound();
                boolean bl5 = candidateColumnImpl.hasUpperBound();
                if (bl4 || bl5) {
                    this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
                }
                if (!bl) {
                    if (bl4) {
                        this.score += this.fieldScore;
                        this.lastLowerBoundColumn = candidateColumnImpl;
                    } else {
                        bl = true;
                    }
                }
                if (!bl2) {
                    if (bl5) {
                        this.score += this.fieldScore;
                        this.lastUpperBoundColumn = candidateColumnImpl;
                    } else {
                        bl2 = true;
                    }
                }
                if (bl && bl2) continue;
            }
            bl3 = false;
        }
        if (this.lastLowerBoundColumn != null) {
            this.lastLowerBoundColumn.markLastLowerBoundColumn();
        }
        if (this.lastUpperBoundColumn != null) {
            this.lastUpperBoundColumn.markLastUpperBoundColumn();
        }
    }

    public PredicateImpl.ScanType getScanType() {
        return this.scanType;
    }

    void operationSetBounds(QueryExecutionContext queryExecutionContext, IndexScanOperation indexScanOperation) {
        if (this.multiRange) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (CandidateColumnImpl candidateColumnImpl : this.candidateColumns) {
                if (!candidateColumnImpl.hasInBound()) continue;
                arrayList.add(candidateColumnImpl.getParameterSize(queryExecutionContext));
            }
            if (arrayList.size() > 1) {
                throw new ClusterJUserException(local.message("ERR_Too_Many_In_For_Index", (Object)this.indexName));
            }
            if (this.candidateColumns.length == 1) {
                this.candidateColumns[0].operationSetAllBounds(queryExecutionContext, indexScanOperation);
            } else {
                for (int i = 0; i < (Integer)arrayList.get(0); ++i) {
                    int n = 0;
                    for (CandidateColumnImpl candidateColumnImpl : this.candidateColumns) {
                        if (logger.isDetailEnabled()) {
                            logger.detail("parameterIndex: " + i + " boundStatus: " + n + " candidateColumn: " + candidateColumnImpl.domainFieldHandler.getName());
                        }
                        if (n == 3) continue;
                        n = candidateColumnImpl.operationSetBounds(queryExecutionContext, indexScanOperation, i, n);
                    }
                    indexScanOperation.endBound(i);
                }
            }
        } else {
            int n = 0;
            for (CandidateColumnImpl candidateColumnImpl : this.candidateColumns) {
                if (logger.isDetailEnabled()) {
                    logger.detail("boundStatus: " + n + " candidateColumn: " + candidateColumnImpl.domainFieldHandler.getName());
                }
                if (n == 3) continue;
                n = candidateColumnImpl.operationSetBounds(queryExecutionContext, indexScanOperation, -1, n);
            }
        }
    }

    void operationSetKeys(QueryExecutionContext queryExecutionContext, Operation operation) {
        for (CandidateColumnImpl candidateColumnImpl : this.candidateColumns) {
            candidateColumnImpl.operationSetKeys(queryExecutionContext, operation);
        }
    }

    public boolean supportsConditionsOfLength(int n) {
        if (this.unique) {
            return n == this.candidateColumns.length;
        }
        return true;
    }

    public Index getStoreIndex() {
        return this.storeIndex;
    }

    public int getScore() {
        return this.score;
    }

    public boolean isMultiRange() {
        return this.multiRange;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int isUsable(QueryExecutionContext queryExecutionContext, String[] stringArray) {
        boolean bl;
        boolean bl2 = bl = stringArray != null;
        if (bl && !this.containsAllOrderingFields(stringArray)) {
            return -1;
        }
        if (this.unique && this.score > 0) {
            return queryExecutionContext.hasNoNullParameters() ? 1 : -1;
        }
        if (this.candidateColumns == null) {
            this.canBound = false;
        } else {
            CandidateColumnImpl candidateColumnImpl = this.candidateColumns[0];
            PredicateImpl predicateImpl = candidateColumnImpl.predicate;
            boolean bl3 = this.canBound = predicateImpl != null && predicateImpl.isUsable(queryExecutionContext);
        }
        if (this.canBound) {
            if (logger.isDebugEnabled()) {
                logger.debug("for " + this.indexName + " canBound true -> returns 1");
            }
            this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
            return 1;
        }
        if (bl) {
            if (logger.isDebugEnabled()) {
                logger.debug("for " + this.indexName + " canBound false -> returns 0");
            }
            this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
            return 0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("for " + this.indexName + " canBound false -> returns -1");
        }
        return -1;
    }

    public boolean containsAllOrderingFields(String[] stringArray) {
        if (this.isUnique()) {
            return false;
        }
        int n = 0;
        if (stringArray != null) {
            for (String string : stringArray) {
                if (n >= this.candidateColumns.length) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Index " + this.indexName + " cannot be used because " + string + " is not part of this index.");
                    }
                    return false;
                }
                CandidateColumnImpl candidateColumnImpl = this.candidateColumns[n++];
                if (string.equals(candidateColumnImpl.domainFieldHandler.getName())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Index " + this.indexName + " cannot be used because CandidateColumn " + candidateColumnImpl.domainFieldHandler.getName() + " does not match " + string);
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("CandidateIndexImpl.containsAllOrderingFields found possible index (unique: " + this.unique + ") " + this.indexName);
            }
            this.scanType = PredicateImpl.ScanType.INDEX_SCAN;
            return true;
        }
        return false;
    }

    class CandidateColumnImpl {
        protected AbstractDomainFieldHandlerImpl domainFieldHandler;
        protected PredicateImpl predicate;
        protected PredicateImpl lowerBoundPredicate;
        protected PredicateImpl upperBoundPredicate;
        protected PredicateImpl equalPredicate;
        protected InPredicateImpl inPredicate;
        protected Boolean lowerBoundStrict = null;
        protected Boolean upperBoundStrict = null;
        protected boolean equalBound = false;
        protected boolean inBound = false;
        protected boolean lastLowerBoundColumn = false;
        protected boolean lastUpperBoundColumn = false;

        protected boolean hasLowerBound() {
            return this.lowerBoundPredicate != null || this.equalPredicate != null || this.inPredicate != null;
        }

        public void operationSetAllBounds(QueryExecutionContext queryExecutionContext, IndexScanOperation indexScanOperation) {
            this.inPredicate.operationSetAllBounds(queryExecutionContext, indexScanOperation);
        }

        public int getParameterSize(QueryExecutionContext queryExecutionContext) {
            return this.inPredicate.getParameterSize(queryExecutionContext);
        }

        protected boolean hasUpperBound() {
            return this.upperBoundPredicate != null || this.equalPredicate != null || this.inPredicate != null;
        }

        protected boolean hasInBound() {
            return this.inBound;
        }

        private CandidateColumnImpl(AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl) {
            this.domainFieldHandler = abstractDomainFieldHandlerImpl;
        }

        private void markLastLowerBoundColumn() {
            this.lastLowerBoundColumn = true;
        }

        private void markLastUpperBoundColumn() {
            this.lastUpperBoundColumn = true;
        }

        private void markLowerBound(PredicateImpl predicateImpl, boolean bl) {
            this.lowerBoundStrict = bl;
            this.lowerBoundPredicate = predicateImpl;
            this.predicate = predicateImpl;
        }

        private void markUpperBound(PredicateImpl predicateImpl, boolean bl) {
            this.upperBoundStrict = bl;
            this.upperBoundPredicate = predicateImpl;
            this.predicate = predicateImpl;
        }

        private void markEqualBound(PredicateImpl predicateImpl) {
            this.equalBound = true;
            this.equalPredicate = predicateImpl;
            this.predicate = predicateImpl;
        }

        public void markInBound(InPredicateImpl inPredicateImpl) {
            this.inBound = true;
            this.inPredicate = inPredicateImpl;
            this.predicate = inPredicateImpl;
        }

        private int operationSetBounds(QueryExecutionContext queryExecutionContext, IndexScanOperation indexScanOperation, int n, int n2) {
            if (this.inPredicate != null && n == -1 || !CandidateIndexImpl.this.canBound) {
                return 3;
            }
            int n3 = PredicateImpl.NO_BOUND_SET;
            if (logger.isDetailEnabled()) {
                logger.detail("column: " + this.domainFieldHandler.getName() + " boundStatus: " + n2 + " lastLowerBoundColumn: " + this.lastLowerBoundColumn + " lastUpperBoundColumn: " + this.lastUpperBoundColumn);
            }
            switch (n2) {
                case 3: {
                    return 3;
                }
                case 0: {
                    if (this.equalPredicate != null) {
                        n3 |= this.equalPredicate.operationSetBounds(queryExecutionContext, indexScanOperation, true);
                    }
                    if (this.inPredicate != null) {
                        n3 |= this.inPredicate.operationSetBound(queryExecutionContext, indexScanOperation, n, true);
                    }
                    if (this.lowerBoundPredicate != null) {
                        n3 |= this.lowerBoundPredicate.operationSetLowerBound(queryExecutionContext, indexScanOperation, this.lastLowerBoundColumn);
                    }
                    if (this.upperBoundPredicate == null) break;
                    n3 |= this.upperBoundPredicate.operationSetUpperBound(queryExecutionContext, indexScanOperation, this.lastUpperBoundColumn);
                    break;
                }
                case 1: {
                    if (this.equalPredicate != null) {
                        n3 |= this.equalPredicate.operationSetUpperBound(queryExecutionContext, indexScanOperation, this.lastUpperBoundColumn);
                    }
                    if (this.inPredicate != null) {
                        n3 |= this.inPredicate.operationSetUpperBound(queryExecutionContext, indexScanOperation, n);
                    }
                    if (this.upperBoundPredicate == null) break;
                    n3 |= this.upperBoundPredicate.operationSetUpperBound(queryExecutionContext, indexScanOperation, this.lastUpperBoundColumn);
                    break;
                }
                case 2: {
                    if (this.equalPredicate != null) {
                        n3 |= this.equalPredicate.operationSetLowerBound(queryExecutionContext, indexScanOperation, this.lastLowerBoundColumn);
                    }
                    if (this.inPredicate != null) {
                        n3 |= this.inPredicate.operationSetLowerBound(queryExecutionContext, indexScanOperation, n);
                    }
                    if (this.lowerBoundPredicate == null) break;
                    n3 |= this.lowerBoundPredicate.operationSetLowerBound(queryExecutionContext, indexScanOperation, this.lastLowerBoundColumn);
                }
            }
            if (0 == (n3 & PredicateImpl.LOWER_BOUND_SET)) {
                n2 |= 1;
            }
            if (0 == (n3 & PredicateImpl.UPPER_BOUND_SET)) {
                n2 |= 2;
            }
            return n2;
        }

        private void operationSetKeys(QueryExecutionContext queryExecutionContext, Operation operation) {
            this.equalPredicate.operationEqual(queryExecutionContext, operation);
        }
    }
}

