/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.DynamicObject;
import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class LoadTest
extends AbstractClusterJModelTest {
    private static final String tablename = "t_basic";
    private static final int NUMBER_TO_INSERT = 3;
    List<DynamicEmployee> loaded = new ArrayList<DynamicEmployee>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createEmployeeInstances(3);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(DynamicEmployee.class);
        this.tx.commit();
    }

    public void test() {
        this.foundIllegalType();
        this.foundNull();
        this.create();
        this.findFound();
        this.findFoundAutocommit();
        this.load();
        this.loadAutocommit();
        this.loadNoFlush();
        this.loadNotFound();
        this.loadFindNoFlush();
        this.failOnError();
    }

    private void create() {
        this.tx = this.session.currentTransaction();
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            this.session.makePersistent(this.employees.get(i));
            ++n;
        }
    }

    private void load() {
        DynamicEmployee dynamicEmployee;
        int n;
        this.loaded.clear();
        this.tx.begin();
        for (n = 0; n < 3; ++n) {
            dynamicEmployee = (DynamicEmployee)((Object)this.session.newInstance(DynamicEmployee.class, (Object)n));
            this.errorIfNotEqual("load after create new employee id mismatch", n, dynamicEmployee.getId());
            this.errorIfNotEqual("load before load found mismatch", null, this.session.found((Object)dynamicEmployee));
            this.session.load((Object)dynamicEmployee);
            this.errorIfNotEqual("load after load newInstance employee id mismatch", n, dynamicEmployee.getId());
            this.errorIfNotEqual("load after load found mismatch", null, this.session.found((Object)dynamicEmployee));
            this.loaded.add(dynamicEmployee);
        }
        this.session.flush();
        for (n = 0; n < 3; ++n) {
            dynamicEmployee = this.loaded.get(n);
            this.errorIfNotEqual("load after flush found mismatch", true, this.session.found((Object)dynamicEmployee));
            this.errorIfNotEqual("load after flush employee id mismatch", n, dynamicEmployee.getId());
            this.consistencyCheckDynamicEmployee("load after flush", dynamicEmployee);
        }
        this.tx.commit();
    }

    private void loadFindNoFlush() {
        DynamicEmployee dynamicEmployee;
        int n;
        this.loaded.clear();
        this.tx.begin();
        for (n = 0; n < 3; ++n) {
            dynamicEmployee = (DynamicEmployee)((Object)this.session.newInstance(DynamicEmployee.class, (Object)n));
            this.errorIfNotEqual("loadFindNoFlush after newInstance employee id mismatch", n, dynamicEmployee.getId());
            this.errorIfNotEqual("loadFindNoFlush after newInstance found mismatch", null, this.session.found((Object)dynamicEmployee));
            this.session.load((Object)dynamicEmployee);
            this.errorIfNotEqual("loadFindNoFlush after load employee id mismatch", n, dynamicEmployee.getId());
            this.errorIfNotEqual("loadFindNoFlush after load found mismatch", null, this.session.found((Object)dynamicEmployee));
            this.loaded.add(dynamicEmployee);
        }
        this.session.find(Employee.class, (Object)0);
        for (n = 0; n < 3; ++n) {
            dynamicEmployee = this.loaded.get(n);
            this.errorIfNotEqual("loadFindNoFlush after find found mismatch", true, this.session.found((Object)dynamicEmployee));
            this.errorIfNotEqual("loadFindNoFlush after find employee id mismatch", n, dynamicEmployee.getId());
            this.consistencyCheckDynamicEmployee("loadFindNoFlush", dynamicEmployee);
        }
        this.tx.commit();
    }

    private void consistencyCheckDynamicEmployee(String string, DynamicEmployee dynamicEmployee) {
        int n = dynamicEmployee.getId();
        String string2 = dynamicEmployee.getName();
        this.errorIfNotEqual(string + " consistencyCheckDynamicEmployee name mismatch", "Employee number " + n, string2);
        this.errorIfNotEqual(string + " consistencyCheckDynamicEmployee age mismatch", n, dynamicEmployee.getAge());
        this.errorIfNotEqual(string + " consistencyCheckDynamicEmployee magic mismatch", n, dynamicEmployee.getMagic());
    }

    private void loadNoFlush() {
        this.loaded.clear();
        this.tx.begin();
        DynamicEmployee dynamicEmployee = (DynamicEmployee)((Object)this.session.newInstance(DynamicEmployee.class, (Object)0));
        this.errorIfNotEqual("loadNoFlush after newInstance employee id mismatch", 0, dynamicEmployee.getId());
        this.errorIfNotEqual("loadNoFlush after newInstance employee name mismatch", null, dynamicEmployee.getName());
        this.session.load((Object)dynamicEmployee);
        this.errorIfNotEqual("loadNoFlush after load employee id mismatch", 0, dynamicEmployee.getId());
        this.errorIfNotEqual("loadNoFlush after load employee name mismatch", null, dynamicEmployee.getName());
        this.tx.commit();
    }

    private void loadAutocommit() {
        DynamicEmployee dynamicEmployee = (DynamicEmployee)((Object)this.session.newInstance(DynamicEmployee.class, (Object)0));
        try {
            this.session.load((Object)dynamicEmployee);
            this.error("loadAutocommit expected exception not thrown: a transaction must be in progress for load.");
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
    }

    private void loadNotFound() {
        this.tx.begin();
        DynamicEmployee dynamicEmployee = (DynamicEmployee)((Object)this.session.newInstance(DynamicEmployee.class, (Object)10000));
        this.session.load((Object)dynamicEmployee);
        this.errorIfNotEqual("loadNotFound dynamic after load session.found(e)", null, this.session.found((Object)dynamicEmployee));
        this.errorIfNotEqual("loadNofFound dynamic after load mismatch in id", 10000, dynamicEmployee.get(0));
        this.session.flush();
        this.errorIfNotEqual("loadNotFound dynamic after load, flush session.found(e)", false, this.session.found((Object)dynamicEmployee));
        this.errorIfNotEqual("loadNofFound dynamic after load mismatch in id", 10000, dynamicEmployee.get(0));
        this.tx.commit();
        this.errorIfNotEqual("loadNotFound dynamic after load, flush, commit session.found(e)", false, this.session.found((Object)dynamicEmployee));
        this.errorIfNotEqual("loadNofFound dynamic after load, flush, commit mismatch in id", 10000, dynamicEmployee.get(0));
    }

    private void findFound() {
        this.tx.begin();
        DynamicEmployee dynamicEmployee = (DynamicEmployee)((Object)this.session.find(DynamicEmployee.class, (Object)0));
        this.errorIfNotEqual("findFound dynamic existing found mismatch", true, this.session.found((Object)dynamicEmployee));
        Employee employee = (Employee)this.session.find(Employee.class, (Object)0);
        this.errorIfNotEqual("findFound existing found mismatch", true, this.session.found((Object)employee));
        this.tx.commit();
    }

    private void findFoundAutocommit() {
        DynamicEmployee dynamicEmployee = (DynamicEmployee)((Object)this.session.find(DynamicEmployee.class, (Object)0));
        this.errorIfNotEqual("findFoundAutocommit dynamic existing found mismatch", true, this.session.found((Object)dynamicEmployee));
        Employee employee = (Employee)this.session.find(Employee.class, (Object)0);
        this.errorIfNotEqual("findFoundAutocommit existing found mismatch", true, this.session.found((Object)employee));
    }

    private void foundIllegalType() {
        try {
            this.session.found((Object)0);
            this.error("foundIllegalType expected exception not thrown: ClusterJUserException");
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
    }

    private void foundNull() {
        this.errorIfNotEqual("foundNull found mismatch", null, this.session.found(null));
    }

    public static class DynamicEmployee
    extends DynamicObject {
        public String table() {
            return LoadTest.tablename;
        }

        public int getId() {
            return (Integer)this.get(0);
        }

        public String getName() {
            return (String)this.get(1);
        }

        public int getAge() {
            return (Integer)this.get(2);
        }

        public int getMagic() {
            return (Integer)this.get(3);
        }
    }
}

