/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ColumnImpl;
import com.mysql.clusterj.tie.PartitionKeyImpl;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class TableImpl
implements Table {
    static final I18NHelper local = I18NHelper.getInstance(TableImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(TableImpl.class);
    protected NdbDictionary.TableConst ndbTable;
    private String tableName;
    private String[] columnNames;
    private String[] primaryKeyColumnNames;
    private String[] partitionKeyColumnNames;
    private Map<String, ColumnImpl> columns = new HashMap<String, ColumnImpl>();
    private String[] indexNames;
    private int[] lengths;
    private int[] offsets;
    private int bufferSize;
    private int maximumColumnId;
    private int maximumColumnLength = 0;
    private Column autoIncrementColumn = null;

    public TableImpl(NdbDictionary.TableConst tableConst, String[] stringArray) {
        int n;
        Object object;
        int n2;
        this.ndbTable = tableConst;
        this.tableName = tableConst.getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n3 = tableConst.getNoOfColumns();
        ColumnImpl[] columnImplArray = new ColumnImpl[n3];
        this.columnNames = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            NdbDictionary.ColumnConst columnConst = tableConst.getColumn(n2);
            if (columnConst.getPartitionKey()) {
                arrayList.add(columnConst.getName());
            }
            if (columnConst.getPrimaryKey()) {
                arrayList2.add(columnConst.getName());
            }
            object = columnConst.getName();
            ColumnImpl columnImpl = new ColumnImpl(this.tableName, columnConst);
            if (columnConst.getAutoIncrement()) {
                this.autoIncrementColumn = columnImpl;
            }
            this.columns.put((String)object, columnImpl);
            columnImplArray[n2] = columnImpl;
            this.columnNames[n2] = object;
            n = columnConst.getColumnNo();
            if (n <= this.maximumColumnId) continue;
            this.maximumColumnId = n;
        }
        this.offsets = new int[this.maximumColumnId + 1];
        this.lengths = new int[this.maximumColumnId + 1];
        n2 = 0;
        for (int i = 0; i < n3; ++i) {
            object = columnImplArray[i];
            int n4 = ((ColumnImpl)object).getColumnId();
            this.lengths[n4] = n = ((ColumnImpl)object).getColumnSpace();
            this.offsets[n4] = n2;
            n2 += n;
            if (n <= this.maximumColumnLength) continue;
            this.maximumColumnLength = n;
        }
        this.bufferSize = n2;
        this.primaryKeyColumnNames = arrayList2.toArray(new String[arrayList2.size()]);
        this.partitionKeyColumnNames = arrayList.toArray(new String[arrayList.size()]);
        this.indexNames = stringArray;
    }

    @Override
    public Column getAutoIncrementColumn() {
        return this.autoIncrementColumn;
    }

    @Override
    public Column getColumn(String string) {
        return this.columns.get(string);
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    @Override
    public String[] getPrimaryKeyColumnNames() {
        return this.primaryKeyColumnNames;
    }

    @Override
    public String[] getPartitionKeyColumnNames() {
        return this.partitionKeyColumnNames;
    }

    @Override
    public PartitionKey createPartitionKey() {
        PartitionKeyImpl partitionKeyImpl = new PartitionKeyImpl();
        partitionKeyImpl.setTable(this.tableName);
        return partitionKeyImpl;
    }

    @Override
    public String[] getIndexNames() {
        return this.indexNames;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int getMaximumColumnId() {
        return this.maximumColumnId;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public int getMaximumColumnLength() {
        return this.maximumColumnLength;
    }
}

