/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.metadata;

import com.mysql.clusterj.core.metadata.AbstractDomainFieldHandlerImpl;
import com.mysql.clusterj.core.query.CandidateIndexImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.util.Arrays;

public class IndexHandlerImpl {
    static final I18NHelper local = I18NHelper.getInstance(IndexHandlerImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(IndexHandlerImpl.class);
    static final String UNIQUE_SUFFIX = "$unique";
    protected String className;
    protected String tableName;
    private String indexName;
    protected Index storeIndex;
    protected boolean unique = true;
    protected AbstractDomainFieldHandlerImpl[] fields;
    protected final String[] columnNames;
    private boolean usable = true;
    private String reason = null;

    public IndexHandlerImpl(DomainTypeHandler<?> domainTypeHandler, Dictionary dictionary, Index index, String[] stringArray) {
        this.className = domainTypeHandler.getName();
        this.storeIndex = index;
        this.indexName = index.getName();
        this.tableName = domainTypeHandler.getTableName();
        this.columnNames = stringArray;
        int n = stringArray.length;
        this.fields = new AbstractDomainFieldHandlerImpl[n];
        this.unique = index.isUnique();
        if (logger.isDebugEnabled()) {
            logger.debug(this.toString());
        }
    }

    public IndexHandlerImpl(DomainTypeHandler<?> domainTypeHandler, Dictionary dictionary, String string, AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl) {
        this.className = domainTypeHandler.getName();
        this.indexName = string;
        this.tableName = domainTypeHandler.getTableName();
        this.storeIndex = this.getIndex(dictionary, this.tableName, string);
        this.unique = this.isUnique(this.storeIndex);
        this.columnNames = abstractDomainFieldHandlerImpl.getColumnNames();
        this.fields = new AbstractDomainFieldHandlerImpl[]{abstractDomainFieldHandlerImpl};
        if (logger.isDebugEnabled()) {
            logger.debug(this.toString());
        }
    }

    public CandidateIndexImpl toCandidateIndexImpl() {
        if (!this.usable) {
            return CandidateIndexImpl.getIndexForNullWhereClause();
        }
        return new CandidateIndexImpl(this.className, this.storeIndex, this.unique, this.fields);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IndexHandler for class ");
        stringBuffer.append(this.className);
        stringBuffer.append(" index: ");
        stringBuffer.append(this.indexName);
        stringBuffer.append(" unique: ");
        stringBuffer.append(this.unique);
        stringBuffer.append(" columns: ");
        stringBuffer.append(Arrays.toString(this.columnNames));
        return stringBuffer.toString();
    }

    public void setDomainFieldHandlerFor(int n, AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl) {
        this.fields[n] = abstractDomainFieldHandlerImpl;
        abstractDomainFieldHandlerImpl.validateIndexType(this.indexName, this.unique);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void assertAllColumnsHaveFields() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            AbstractDomainFieldHandlerImpl abstractDomainFieldHandlerImpl = this.fields[i];
            if (abstractDomainFieldHandlerImpl != null && this.columnNames[i].equals(abstractDomainFieldHandlerImpl.getColumnName())) continue;
            this.usable = false;
            this.reason = local.message("ERR_Index_Mismatch", this.className, this.indexName, this.columnNames[i]);
        }
    }

    protected boolean isUnique(Index index) {
        return index.isUnique();
    }

    public boolean isUsable() {
        return this.usable;
    }

    public String getReason() {
        return this.reason;
    }

    protected Index getIndex(Dictionary dictionary, String string, String string2) {
        return dictionary.getIndex(string2, string, string2);
    }

    public String getIndexName() {
        return this.indexName;
    }
}

