/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.HashSet;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class QueryPrimaryKeyTest
extends AbstractClusterJModelTest {
    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.createEmployeeInstances(10);
        try {
            this.tx.begin();
            this.session.deletePersistentAll(Employee.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.tx.begin();
        this.session.makePersistentAll((Iterable)this.employees);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    public void testPrimaryKey() {
        this.primaryKeyBetweenQuery();
        this.primaryKeyEqualQuery();
        this.primaryKeyGreaterEqualQuery();
        this.primaryKeyGreaterThanQuery();
        this.primaryKeyLessEqualQuery();
        this.primaryKeyLessThanQuery();
        this.failOnError();
    }

    public void primaryKeyEqualQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Employee.class);
        PredicateOperand predicateOperand = queryDomainType.param("id");
        PredicateOperand predicateOperand2 = queryDomainType.get("id");
        Predicate predicate = predicateOperand2.equal(predicateOperand);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("id", (Object)8);
        List list = query.getResultList();
        this.consistencyCheck(list);
        this.errorIfNotEqual("Wrong employee id returned from query: ", 8, ((Employee)list.get(0)).getId());
        this.tx.commit();
    }

    public void primaryKeyGreaterThanQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Employee.class);
        PredicateOperand predicateOperand = queryDomainType.param("id");
        PredicateOperand predicateOperand2 = queryDomainType.get("id");
        Predicate predicate = predicateOperand2.greaterThan(predicateOperand);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("id", (Object)6);
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(7);
        hashSet.add(8);
        hashSet.add(9);
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        for (Employee employee : list) {
            hashSet2.add(employee.getId());
        }
        this.errorIfNotEqual("Wrong employee ids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    public void primaryKeyGreaterEqualQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Employee.class);
        PredicateOperand predicateOperand = queryDomainType.param("id");
        PredicateOperand predicateOperand2 = queryDomainType.get("id");
        Predicate predicate = predicateOperand2.greaterEqual(predicateOperand);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("id", (Object)7);
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(7);
        hashSet.add(8);
        hashSet.add(9);
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        for (Employee employee : list) {
            hashSet2.add(employee.getId());
        }
        this.errorIfNotEqual("Wrong employee ids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    public void primaryKeyLessThanQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Employee.class);
        PredicateOperand predicateOperand = queryDomainType.param("id");
        PredicateOperand predicateOperand2 = queryDomainType.get("id");
        Predicate predicate = predicateOperand2.lessThan(predicateOperand);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("id", (Object)3);
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(0);
        hashSet.add(1);
        hashSet.add(2);
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        for (Employee employee : list) {
            hashSet2.add(employee.getId());
        }
        this.errorIfNotEqual("Wrong employee ids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    public void primaryKeyLessEqualQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Employee.class);
        PredicateOperand predicateOperand = queryDomainType.param("id");
        PredicateOperand predicateOperand2 = queryDomainType.get("id");
        Predicate predicate = predicateOperand2.lessEqual(predicateOperand);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("id", (Object)2);
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(0);
        hashSet.add(1);
        hashSet.add(2);
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        for (Employee employee : list) {
            hashSet2.add(employee.getId());
        }
        this.errorIfNotEqual("Wrong employee ids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    public void primaryKeyBetweenQuery() {
        this.tx.begin();
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Employee.class);
        PredicateOperand predicateOperand = queryDomainType.param("lower");
        PredicateOperand predicateOperand2 = queryDomainType.param("upper");
        PredicateOperand predicateOperand3 = queryDomainType.get("id");
        Predicate predicate = predicateOperand3.between(predicateOperand, predicateOperand2);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("lower", (Object)5);
        query.setParameter("upper", (Object)7);
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(5);
        hashSet.add(6);
        hashSet.add(7);
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        for (Employee employee : list) {
            hashSet2.add(employee.getId());
        }
        this.errorIfNotEqual("Wrong employee ids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }
}

