/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import sun.misc.Cleaner;

class VariableByteBufferPoolImpl {
    static final I18NHelper local = I18NHelper.getInstance(VariableByteBufferPoolImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(VariableByteBufferPoolImpl.class);
    TreeMap<Integer, ConcurrentLinkedQueue<ByteBuffer>> queues = new TreeMap();
    int biggest = 0;
    static Field cleanerField = null;
    static byte[] guard;

    static void clean(ByteBuffer byteBuffer) {
        if (cleanerField != null) {
            try {
                ((Cleaner)cleanerField.get(byteBuffer)).clean();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void initializeGuard(ByteBuffer byteBuffer) {
        byteBuffer.position(byteBuffer.capacity() - guard.length);
        byteBuffer.put(guard);
    }

    void checkGuard(ByteBuffer byteBuffer) {
        if (byteBuffer.limit() == 0) {
            return;
        }
        byteBuffer.limit(byteBuffer.capacity());
        byteBuffer.position(byteBuffer.capacity() - guard.length);
        for (int i = 0; i < guard.length; ++i) {
            if (byteBuffer.get() == guard[i]) continue;
            throw new RuntimeException("ByteBufferPool failed guard test with buffer of length " + (byteBuffer.capacity() - guard.length) + ": " + byteBuffer.toString());
        }
    }

    public VariableByteBufferPoolImpl(int[] nArray) {
        for (int n : nArray) {
            this.queues.put(n + 1, new ConcurrentLinkedQueue());
            if (this.biggest >= n) continue;
            this.biggest = n;
        }
        logger.info(local.message("MSG_ByteBuffer_Pools_Initialized", (Object)Arrays.toString(nArray)));
    }

    public ByteBuffer borrowBuffer(int n) {
        Map.Entry<Integer, ConcurrentLinkedQueue<ByteBuffer>> entry = this.queues.higherEntry(n);
        ByteBuffer byteBuffer = null;
        if (entry == null) {
            if (logger.isDetailEnabled()) {
                logger.detail(local.message("MSG_Cannot_allocate_byte_buffer_from_pool", (Object)n, (Object)this.biggest));
            }
            byteBuffer = ByteBuffer.allocateDirect(n + guard.length);
            this.initializeGuard(byteBuffer);
            return byteBuffer;
        }
        ConcurrentLinkedQueue<ByteBuffer> concurrentLinkedQueue = entry.getValue();
        int n2 = entry.getKey() - 1;
        byteBuffer = concurrentLinkedQueue.poll();
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocateDirect(n2 + guard.length);
            this.initializeGuard(byteBuffer);
        }
        byteBuffer.limit(n);
        byteBuffer.position(0);
        return byteBuffer;
    }

    public void returnBuffer(int n, ByteBuffer byteBuffer) {
        this.checkGuard(byteBuffer);
        Map.Entry<Integer, ConcurrentLinkedQueue<ByteBuffer>> entry = this.queues.higherEntry(n);
        if (entry != null) {
            int n2 = entry.getKey() - 1;
            ConcurrentLinkedQueue<ByteBuffer> concurrentLinkedQueue = entry.getValue();
            concurrentLinkedQueue.add(byteBuffer);
        } else {
            byteBuffer.limit(0);
            VariableByteBufferPoolImpl.clean(byteBuffer);
        }
    }

    static {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
            cleanerField = byteBuffer.getClass().getDeclaredField("cleaner");
            cleanerField.setAccessible(true);
            VariableByteBufferPoolImpl.clean(byteBuffer);
        }
        catch (Throwable throwable) {
            String string = local.message("WARN_Buffer_Cleaning_Unusable", (Object)throwable.getClass().getName(), (Object)throwable.getMessage());
            logger.warn(string);
            cleanerField = null;
        }
        guard = new byte[0];
        for (int i = 0; i < guard.length; ++i) {
            VariableByteBufferPoolImpl.guard[i] = 10;
        }
    }
}

