/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class UpdateTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 4;

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Employee.class);
        this.tx.commit();
        this.createEmployeeInstances(4);
        this.tx.begin();
        this.session.makePersistentAll((Iterable)this.employees);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    public void testUpdate() {
        Employee employee;
        int n;
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            employee.setAge(4 - n);
            this.session.updatePersistent((Object)employee);
        }
        this.tx.commit();
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            int n2 = 4 - n;
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            int n3 = employee.getAge();
            if (n2 == n3) continue;
            this.error("Failed update: for employee " + n + " expected age " + n2 + " actual age " + n3);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testBlindUpdate() {
        Employee employee;
        int n;
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            employee = (Employee)this.session.newInstance(Employee.class);
            employee.setId(n);
            employee.setAge(4 - n);
            this.session.updatePersistent((Object)employee);
        }
        this.tx.commit();
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            int n2 = 4 - n;
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            int n3 = employee.getAge();
            if (n2 == n3) continue;
            this.error("Failed update: for employee " + n + " expected age " + n2 + " actual age " + n3);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testUpdateAll() {
        Employee employee;
        int n;
        ArrayList<Employee> arrayList = new ArrayList<Employee>();
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            employee.setAge(4 - n);
            arrayList.add(employee);
        }
        this.session.updatePersistentAll(arrayList);
        this.tx.commit();
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            int n2 = 4 - n;
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            int n3 = employee.getAge();
            if (n2 == n3) continue;
            this.error("Failed update: for employee " + n + " expected age " + n2 + " actual age " + n3);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testBlindUpdateAll() {
        Employee employee;
        int n;
        ArrayList<Employee> arrayList = new ArrayList<Employee>();
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            employee = (Employee)this.session.newInstance(Employee.class);
            employee.setId(n);
            employee.setAge(4 - n);
            arrayList.add(employee);
        }
        this.session.updatePersistentAll(arrayList);
        this.tx.commit();
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            int n2 = 4 - n;
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            int n3 = employee.getAge();
            if (n2 == n3) continue;
            this.error("Failed update: for employee " + n + " expected age " + n2 + " actual age " + n3);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testUpdateAllAutocommit() {
        Employee employee;
        int n;
        ArrayList<Employee> arrayList = new ArrayList<Employee>();
        for (n = 0; n < 4; ++n) {
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            employee.setAge(4 - n);
            arrayList.add(employee);
        }
        this.session.updatePersistentAll(arrayList);
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            int n2 = 4 - n;
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            int n3 = employee.getAge();
            if (n2 == n3) continue;
            this.error("Failed update: for employee " + n + " expected age " + n2 + " actual age " + n3);
        }
        this.tx.commit();
        this.failOnError();
    }

    public void testBlindUpdateAllAutocommit() {
        Employee employee;
        int n;
        ArrayList<Employee> arrayList = new ArrayList<Employee>();
        for (n = 0; n < 4; ++n) {
            employee = (Employee)this.session.newInstance(Employee.class);
            employee.setId(n);
            employee.setAge(4 - n);
            arrayList.add(employee);
        }
        this.session.updatePersistentAll(arrayList);
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            int n2 = 4 - n;
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            int n3 = employee.getAge();
            if (n2 == n3) continue;
            this.error("Failed update: for employee " + n + " expected age " + n2 + " actual age " + n3);
        }
        this.tx.commit();
        this.failOnError();
    }
}

