/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.DoubleTypes;
import testsuite.clusterj.model.IdBase;

public class QueryDoubleTypesTest
extends AbstractQueryTest {
    public Class getInstanceType() {
        return DoubleTypes.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllDoubleTypesInstances(n);
    }

    public void test() {
        this.btreeIndexScanDouble();
        this.hashIndexScanDouble();
        this.bothIndexScanDouble();
        this.noneIndexScanDouble();
        this.failOnError();
    }

    public void btreeIndexScanDouble() {
        this.equalQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(8), 8);
        this.greaterEqualQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_not_null_btree", "idx_double_not_null_btree", this.getDouble(4), this.getDouble(6), 5);
        this.equalQuery("double_null_btree", "idx_double_null_btree", this.getDouble(8), 8);
        this.greaterEqualQuery("double_null_btree", "idx_double_null_btree", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_null_btree", "idx_double_null_btree", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_null_btree", "idx_double_null_btree", this.getDouble(4), this.getDouble(6), 5);
    }

    public void hashIndexScanDouble() {
        this.equalQuery("double_not_null_hash", "idx_double_not_null_hash", this.getDouble(8), 8);
        this.greaterEqualQuery("double_not_null_hash", "none", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_not_null_hash", "none", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_not_null_hash", "none", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_not_null_hash", "none", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_not_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_not_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_not_null_hash", "none", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_not_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_not_null_hash", "none", this.getDouble(4), this.getDouble(6), 5);
        this.equalQuery("double_null_hash", "idx_double_null_hash", this.getDouble(8), 8);
        this.greaterEqualQuery("double_null_hash", "none", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_null_hash", "none", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_null_hash", "none", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_null_hash", "none", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_null_hash", "none", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_null_hash", "none", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_null_hash", "none", this.getDouble(4), this.getDouble(6), 5);
    }

    public void bothIndexScanDouble() {
        this.equalQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(8), 8);
        this.greaterEqualQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_not_null_both", "idx_double_not_null_both", this.getDouble(4), this.getDouble(6), 5);
        this.equalQuery("double_null_both", "idx_double_null_both", this.getDouble(8), 8);
        this.greaterEqualQuery("double_null_both", "idx_double_null_both", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_null_both", "idx_double_null_both", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_null_both", "idx_double_null_both", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_null_both", "idx_double_null_both", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_null_both", "idx_double_null_both", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_null_both", "idx_double_null_both", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_null_both", "idx_double_null_both", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_null_both", "idx_double_null_both", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_null_both", "idx_double_null_both", this.getDouble(4), this.getDouble(6), 5);
    }

    public void noneIndexScanDouble() {
        this.equalQuery("double_not_null_none", "none", this.getDouble(8), 8);
        this.greaterEqualQuery("double_not_null_none", "none", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_not_null_none", "none", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_not_null_none", "none", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_not_null_none", "none", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_not_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_not_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_not_null_none", "none", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_not_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_not_null_none", "none", this.getDouble(4), this.getDouble(6), 5);
        this.equalQuery("double_null_none", "none", this.getDouble(8), 8);
        this.greaterEqualQuery("double_null_none", "none", this.getDouble(7), 7, 8, 9);
        this.greaterThanQuery("double_null_none", "none", this.getDouble(6), 7, 8, 9);
        this.lessEqualQuery("double_null_none", "none", this.getDouble(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("double_null_none", "none", this.getDouble(4), 3, 2, 1, 0);
        this.betweenQuery("double_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("double_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("double_null_none", "none", this.getDouble(4), this.getDouble(6), 5, 6);
        this.greaterEqualAndLessThanQuery("double_null_none", "none", this.getDouble(4), this.getDouble(6), 4, 5);
        this.greaterThanAndLessThanQuery("double_null_none", "none", this.getDouble(4), this.getDouble(6), 5);
    }

    private void createAllDoubleTypesInstances(int n) {
        for (int i = 0; i < n; ++i) {
            DoubleTypes doubleTypes = (DoubleTypes)this.session.newInstance(DoubleTypes.class);
            doubleTypes.setId(i);
            doubleTypes.setDouble_not_null_hash(this.getDouble(i));
            doubleTypes.setDouble_not_null_btree(this.getDouble(i));
            doubleTypes.setDouble_not_null_both(this.getDouble(i));
            doubleTypes.setDouble_not_null_none(this.getDouble(i));
            doubleTypes.setDouble_null_hash(this.getDouble(i));
            doubleTypes.setDouble_null_btree(this.getDouble(i));
            doubleTypes.setDouble_null_both(this.getDouble(i));
            doubleTypes.setDouble_null_none(this.getDouble(i));
            this.instances.add(doubleTypes);
        }
    }

    protected Double getDouble(int n) {
        return 1.0E-5 * (double)n;
    }

    @Override
    protected void printResultInstance(IdBase idBase) {
        if (idBase instanceof DoubleTypes) {
            DoubleTypes doubleTypes = (DoubleTypes)idBase;
        }
    }

    public static String toString(IdBase idBase) {
        DoubleTypes doubleTypes = (DoubleTypes)idBase;
        StringBuffer stringBuffer = new StringBuffer("DoubleTypes id: ");
        stringBuffer.append(doubleTypes.getId());
        stringBuffer.append("; double_not_null_both: ");
        stringBuffer.append(doubleTypes.getDouble_not_null_both());
        stringBuffer.append("; double_not_null_btree: ");
        stringBuffer.append(doubleTypes.getDouble_not_null_btree());
        stringBuffer.append("; double_not_null_hash: ");
        stringBuffer.append(doubleTypes.getDouble_not_null_hash());
        stringBuffer.append("; double_not_null_none: ");
        stringBuffer.append(doubleTypes.getDouble_not_null_none());
        stringBuffer.append("; double_null_both: ");
        stringBuffer.append(doubleTypes.getDouble_null_both().toString());
        stringBuffer.append("; double_null_btree: ");
        stringBuffer.append(doubleTypes.getDouble_null_btree().toString());
        stringBuffer.append("; double_null_hash: ");
        stringBuffer.append(doubleTypes.getDouble_null_hash().toString());
        stringBuffer.append("; double_null_none: ");
        stringBuffer.append(doubleTypes.getDouble_null_none().toString());
        return stringBuffer.toString();
    }
}

