/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.LongvarbinaryPK;

public class LongvarbinaryPKTest
extends AbstractClusterJTest {
    protected int NUMBER_OF_INSTANCES = 15;
    protected List<LongvarbinaryPK> instances = new ArrayList<LongvarbinaryPK>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        try {
            this.tx.begin();
            this.session.deletePersistentAll(LongvarbinaryPK.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.createInstances();
        this.addTearDownClasses(LongvarbinaryPK.class);
    }

    public void test() {
        this.insert();
        this.find();
        this.update();
        this.delete();
        this.failOnError();
    }

    protected void insert() {
        this.session.makePersistentAll(this.instances);
    }

    protected void find() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            byte[] byArray = this.getPK(i);
            LongvarbinaryPK longvarbinaryPK = (LongvarbinaryPK)this.session.find(LongvarbinaryPK.class, (Object)byArray);
            this.verify(longvarbinaryPK, i, false);
        }
    }

    protected void update() {
        Object object;
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            object = this.createInstance(n);
            object.setName(this.getValue(this.NUMBER_OF_INSTANCES - n));
            this.session.updatePersistent(object);
            this.verify((LongvarbinaryPK)object, n, true);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            object = this.getPK(n);
            LongvarbinaryPK longvarbinaryPK = (LongvarbinaryPK)this.session.find(LongvarbinaryPK.class, object);
            this.verify(longvarbinaryPK, n, true);
        }
    }

    protected void delete() {
        Object object;
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            object = this.createInstance(n);
            this.session.deletePersistent(object);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            object = this.getPK(n);
            LongvarbinaryPK longvarbinaryPK = (LongvarbinaryPK)this.session.find(LongvarbinaryPK.class, object);
            this.errorIfNotEqual("Failed to delete instance: " + n, null, longvarbinaryPK);
        }
    }

    protected void createInstances() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            LongvarbinaryPK longvarbinaryPK = this.createInstance(i);
            if (this.getDebug()) {
                System.out.println(this.toString(longvarbinaryPK));
            }
            this.instances.add(longvarbinaryPK);
        }
    }

    protected LongvarbinaryPK createInstance(int n) {
        LongvarbinaryPK longvarbinaryPK = (LongvarbinaryPK)this.session.newInstance(LongvarbinaryPK.class);
        longvarbinaryPK.setId(this.getPK(n));
        longvarbinaryPK.setNumber(n);
        longvarbinaryPK.setName(this.getValue(n));
        return longvarbinaryPK;
    }

    protected String toString(LongvarbinaryPK longvarbinaryPK) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LongvarbinaryPK[");
        stringBuffer.append(this.toString(longvarbinaryPK.getId()));
        stringBuffer.append("]: ");
        stringBuffer.append(longvarbinaryPK.getNumber());
        stringBuffer.append(", \"");
        stringBuffer.append(longvarbinaryPK.getName());
        stringBuffer.append("\".");
        return stringBuffer.toString();
    }

    protected byte[] getPK(int n) {
        return new byte[]{0, (byte)(n / 256), (byte)(n % 256)};
    }

    protected String getValue(int n) {
        return "Value " + n;
    }

    protected void verify(LongvarbinaryPK longvarbinaryPK, int n, boolean bl) {
        this.errorIfNotEqual("id failed", this.toString(this.getPK(n)), this.toString(longvarbinaryPK.getId()));
        this.errorIfNotEqual("number failed", n, longvarbinaryPK.getNumber());
        if (bl) {
            this.errorIfNotEqual("Value failed", this.getValue(this.NUMBER_OF_INSTANCES - n), longvarbinaryPK.getName());
        } else {
            this.errorIfNotEqual("Value failed", this.getValue(n), longvarbinaryPK.getName());
        }
    }

    private String toString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.valueOf(byArray[i]));
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }
}

