CREATE DATABASE mysql;
CREATE DATABASE test;
use mysql;
set table_type=myisam;
 CREATE TABLE db (   Host char(60) binary DEFAULT '' NOT NULL,   Db char(64) binary DEFAULT '' NOT NULL,   User char(16) binary DEFAULT '' NOT NULL,   Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, PRIMARY KEY Host (Host,Db,User), KEY User (User) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin comment='Database privileges';
INSERT INTO db VALUES ('%','test','','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y');
  INSERT INTO db VALUES ('%','test\_%','','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y');

 CREATE TABLE host (  Host char(60) binary DEFAULT '' NOT NULL,  Db char(64) binary DEFAULT '' NOT NULL,  Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,  PRIMARY KEY Host (Host,Db) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin comment='Host privileges;  Merged with database privileges';


 CREATE TABLE user (   Host char(60) binary DEFAULT '' NOT NULL,   User char(16) binary DEFAULT '' NOT NULL,   Password char(41) binary DEFAULT '' NOT NULL,   Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Reload_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Shutdown_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Process_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   File_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Show_db_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Super_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Repl_slave_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   Repl_client_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   ssl_type enum('','ANY','X509', 'SPECIFIED') COLLATE utf8_general_ci DEFAULT '' NOT NULL,   ssl_cipher BLOB NOT NULL,   x509_issuer BLOB NOT NULL,   x509_subject BLOB NOT NULL,   max_questions int(11) unsigned DEFAULT 0  NOT NULL,   max_updates int(11) unsigned DEFAULT 0  NOT NULL,   max_connections int(11) unsigned DEFAULT 0  NOT NULL,   PRIMARY KEY Host (Host,User) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin comment='Users and global privileges';
INSERT INTO user VALUES ('localhost','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0);
           INSERT INTO user VALUES ('%','root','','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0);
           INSERT INTO user (host,user) values ('%','');
           INSERT INTO user (host,user) values ('localhost','');

 CREATE TABLE func (   name char(64) binary DEFAULT '' NOT NULL,   ret tinyint(1) DEFAULT '0' NOT NULL,   dl char(128) DEFAULT '' NOT NULL,   type enum ('function','aggregate') COLLATE utf8_general_ci NOT NULL,   PRIMARY KEY (name) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin   comment='User defined functions';


 CREATE TABLE tables_priv (   Host char(60) binary DEFAULT '' NOT NULL,   Db char(64) binary DEFAULT '' NOT NULL,   User char(16) binary DEFAULT '' NOT NULL,   Table_name char(64) binary DEFAULT '' NOT NULL,   Grantor char(77) DEFAULT '' NOT NULL,   Timestamp timestamp(14),   Table_priv set('Select','Insert','Update','Delete','Create','Drop','Grant','References','Index','Alter') COLLATE utf8_general_ci DEFAULT '' NOT NULL,   Column_priv set('Select','Insert','Update','References') COLLATE utf8_general_ci DEFAULT '' NOT NULL,   PRIMARY KEY (Host,Db,User,Table_name),   KEY Grantor (Grantor) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin   comment='Table privileges';
 CREATE TABLE columns_priv (   Host char(60) binary DEFAULT '' NOT NULL,   Db char(64) binary DEFAULT '' NOT NULL,   User char(16) binary DEFAULT '' NOT NULL,   Table_name char(64) binary DEFAULT '' NOT NULL,   Column_name char(64) binary DEFAULT '' NOT NULL,   Timestamp timestamp(14),   Column_priv set('Select','Insert','Update','References') COLLATE utf8_general_ci DEFAULT '' NOT NULL,   PRIMARY KEY (Host,Db,User,Table_name,Column_name) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin   comment='Column privileges';

 CREATE TABLE help_topic (   help_topic_id    int unsigned not null,   name             varchar(64) not null,   help_category_id smallint unsigned not null,   description      text not null,   example          text not null,   url              varchar(128) not null,   primary key      (help_topic_id),   unique index     (name) ) engine=MyISAM CHARACTER SET utf8   comment='help topics';
 CREATE TABLE help_category (   help_category_id   smallint unsigned not null,   name               varchar(64) not null,   parent_category_id smallint unsigned null,   url                varchar(128) not null,   primary key        (help_category_id),   unique index       (name) ) engine=MyISAM CHARACTER SET utf8   comment='help categories';
 CREATE TABLE help_relation (   help_topic_id    int unsigned not null references help_topic,   help_keyword_id  int unsigned not null references help_keyword,   primary key      (help_keyword_id, help_topic_id) ) engine=MyISAM CHARACTER SET utf8   comment='keyword-topic relation';
 CREATE TABLE help_keyword (   help_keyword_id  int unsigned not null,   name             varchar(64) not null,   primary key      (help_keyword_id),   unique index     (name) ) engine=MyISAM CHARACTER SET utf8   comment='help keywords';

 CREATE TABLE time_zone_name (   Name char(64) NOT NULL,   Time_zone_id int unsigned NOT NULL,   PRIMARY KEY Name (Name) ) engine=MyISAM CHARACTER SET utf8   comment='Time zone names';

 CREATE TABLE time_zone (   Time_zone_id int unsigned NOT NULL auto_increment,   Use_leap_seconds enum('Y','N') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,   PRIMARY KEY TzId (Time_zone_id) ) engine=MyISAM CHARACTER SET utf8   comment='Time zones';

 CREATE TABLE time_zone_transition (   Time_zone_id int unsigned NOT NULL,   Transition_time bigint signed NOT NULL,   Transition_type_id int unsigned NOT NULL,   PRIMARY KEY TzIdTranTime (Time_zone_id, Transition_time) ) engine=MyISAM CHARACTER SET utf8   comment='Time zone transitions';

 CREATE TABLE time_zone_transition_type (   Time_zone_id int unsigned NOT NULL,   Transition_type_id int unsigned NOT NULL,   Offset int signed DEFAULT 0 NOT NULL,   Is_DST tinyint unsigned DEFAULT 0 NOT NULL,   Abbreviation char(8) DEFAULT '' NOT NULL,   PRIMARY KEY TzIdTrTId (Time_zone_id, Transition_type_id) ) engine=MyISAM CHARACTER SET utf8   comment='Time zone transition types';

 CREATE TABLE time_zone_leap_second (   Transition_time bigint signed NOT NULL,   Correction int signed NOT NULL,   PRIMARY KEY TranTime (Transition_time) ) engine=MyISAM CHARACTER SET utf8   comment='Leap seconds information for time zones';

