// $Id: jmsadmin.java,v 1.1 1997/11/08 16:16:43 xzhu Exp $
// jmsadmin.java
//
// MySQL system administer with java
//
// Author: Xiaokun Kelvin ZHU
// Address: kelvinxz@iname.com
// 1997/09/11
//
// Copyright (C) 1997, X.K.ZHU
//   The `jmsadmin.java' is free software and comes with NO WARRANTY of any
//   kind; you can redistribute it and/or modify it under the terms of the 
//   GNU Library General Public License as published by the Free Software 
//   Foundation; either version 2 of the License, or (at your option) any 
//   later version.

//
// The original mysqladmin.c:
//
// Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
//   This file is public domain and comes with NO WARRANTY of any kind 
//
package jms;

import java.net.URL;
import java.sql.*;
import java.io.*;
import zxk.util.*;

public class jmsadmin implements DBugConstant
{
  private jmsadmin()
  {}

  public void doit(String[] args)
  {
    String[] loName = { "force", "help", "host", "password", "port",
      "sleep", "user", "debug" };
    int[] loHasArg = { GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.REQ_ARG,
      GetOpt.OPT_ARG, GetOpt.REQ_ARG, GetOpt.REQ_ARG,
      GetOpt.REQ_ARG, GetOpt.REQ_ARG };
    int[] loValue = { 'f', '?', 'h', 'p', 'P', 'i', 'u', '#' };
    GetOpt g = new GetOpt();
    g.setInputArgs(args);
    g.setShortOption("#:?fh:p::P:i:u:");
    g.setLongOptionName(loName);
    g.setLongOptionHasArg(loHasArg);
    g.setLongOptionValue(loValue);
    g.setOptionMode(GetOpt.LONG_OPT);

    String host = null;
    String port = null;
    String user = null;
    String password = null;
    String command = null;
    String debugStr = null;
    String extra = new String("");;
    long interval = 0L;
    int c;
    boolean tty_password = false;
    boolean error = false;
    boolean option_quick = false;

    try
    {
      while ( (c=g.getopt()) != GetOpt.EOF)
      {
        switch(c)
        {
          case '#':
	    debugStr = g.getOptarg();
	    break;
          case 'h':
	    host = g.getOptarg();
	    break;
  	  case 'f':
	    option_quick = true;
	    break;
	  case 'p':
	    password = g.getOptarg();
	    if (password == null)
	      tty_password = true;
	    break;
	  case 'u':
	    user = g.getOptarg();
	    break;
	  case 'i':
	    interval = new Long(g.getOptarg()).longValue();
	    break;
	  case 'P':
	    port = g.getOptarg();
	    break;
	  default:
	    String s = new Character((char)c).toString();
	    System.err.println("Illegal option character '" + s + "'");
	  case '?':
	    error = true;
	    break;
        }
      }
    }
    catch (GetOptException e)
    {
      System.err.println(e.getMessage());
      error = true;
    }

    if (debugStr == null)
      debugStr = new String("");
    if (zxk_debug)
      DBug.dbug.dbPush(debugStr);

    int optind = g.getOptind();
    if (optind < args.length)
    {
      command = args[optind++];
  //System.out.println("optind" + optind + "," + args.length);
      if ((optind == args.length) && (command.equals("create") ||
         command.equals("drop") || command.equals("kill")))
      {
        System.err.println(command + " need one more argument.");
        error = true;
      }
      else if (optind < args.length)
      {
        extra = args[optind++] + " ";
	for (int i=optind; i<args.length; ++i)
	  extra += args[i] + " ";
      }
    }
    else
    {
      System.err.println("Need to provide one command.");
      error = true;
    }

    if (error)
    {
      System.out.println("MySQL system administer with Java");
      System.out.println("Copyright (C) Xiaokun Kelvin ZHU, 1997");
      System.out.println("Usage: java jmsadmin [OPTIONS] command");
      System.out.println("\n" +
  "-f, --force		don't ask for confirmation on drop table\n" + 
  "-?, --help		display this help and exit\n" + 
  "-h, --host=#		connect to host\n" +
  "-p, --password[=...]	password to use when connecting to server\n" +
  "                     If password is not given it's asked from the tty.\n" +
  "-P  --port=...	Port number to use for connection\n" + 
  "-i, --sleep=sec	execute commands again and again with a sleep between\n" +
  "-u, --user=#		user for login if not current user\n" + 
  "-V, --version		output version information and exit");
      System.out.println("\nWhere command is a one or more of: " + 
      "(Commands may be shortened)\n" + 
      "  create db_name	Create a new database\n" + 
      "  drop db_name	Delete a database and all its tables\n" +
      "  kill id	Kill mysql threads\n" +
      "  proclist	Show list of active threads in server\n" +
      "  reload		Reload grant table\n" +
      "  refresh	Flush all tables and close and open logfiles\n"+
      "  shutdown	Take server down\n" +
      "  status		Gives a short status message from the server\n" +
      "  version	Get version info from server");
      if (zxk_debug)
        DBug.dbug.dbPop();
      System.exit(1);
    }

    if (tty_password)
      password = getTtyPassword();

    while (true)
    {
      if (!option_quick && command.equals("drop"))
      {
        System.out.println("Dropping the database is potentially a very bad thing to do.");
	System.out.println("Any data stored in the database will be destroyed.");
	System.out.print("Do you really want to drop the " + extra + " database [y/N]");
	String t = readline();
	if (!t.equals("y") && !t.equals("Y"))
	  break;
      }
      executeCommand(host, port, user, password, command, extra);
      if (interval > 0)
      {
        try
	{
          Thread.sleep(interval);
	} catch (InterruptedException e) {}
	System.out.println("");
      }
      else
        break;
    }

    if (zxk_debug)
      DBug.dbug.dbPop();
  }

  private String readline()
  {
    StringBuffer line = new StringBuffer();
    int in = -1;
    
    try
    {
      while ( (in = System.in.read()) != 10 && in != 13 && in != -1)
        line.append(new Character((char)in));
    } catch (IOException e)
    { e.printStackTrace(); }
    
    return line.toString();
  }

  private String getTtyPassword()
  {
    System.out.print("Password:");
    return readline();
  }

  private void executeCommand(String host, String port, String user, 
    String password, String command, String extra)
  {
    if (zxk_debug)
      DBug.dbug.dbEnter("executeCommand()", "jmsadmin", 220);

    boolean specialVersion = false;
    try
    {
      Class.forName ("gwe.sql.gweMysqlDriver");

      StringBuffer bufferURL = new StringBuffer();
      bufferURL.append("jdbc:mysql:");
      if (host != null && host.length() != 0)
      {
        bufferURL.append("//" + host);
        if (port != null && port.length() != 0)
          bufferURL.append(":" + port + "/");
        else
          bufferURL.append("/");
      }
      else if (port != null && port.length() != 0)
      {
        bufferURL.append("//localhost:" + port + "/");
      }
      if (command.equals("create") || command.equals("drop"))
        bufferURL.append(extra);
      if (user == null || user.length() == 0)
        user = System.getProperty("user.name");
      bufferURL.append("?user=" + user);
      if (password == null)
        password = "";
      bufferURL.append(";password=" + password);
      if (command.equals("version"))
      {
        command = new String("status");
	specialVersion = true;
      }
      bufferURL.append(";command=" + command);
      if (command.equals("kill"))
        bufferURL.append(" " + extra + ";");
      else
        bufferURL.append(";");
      String url = new String(bufferURL);
      if (zxk_debug)
       DBug.dbug.dbPrint(257, "ec_1", url);

      Connection con = DriverManager.getConnection (url);
      String str = getMessageFromServer(con.getWarnings ());
      if (specialVersion)
      {
        DatabaseMetaData dma = con.getMetaData ();
	String s1 = dma.getDatabaseProductVersion();
	int i = s1.indexOf(' ');
	System.out.println("MySQL system administer with Java, by X.K.ZHU");
	System.out.print("Server version\t" + s1.substring(0,i));
	System.out.println("\t\tProtocol version\t" + s1.substring(i+1));
        System.out.print("JDBC driver\t" + dma.getDriverName());
        System.out.println("\tVersion\t" + dma.getDriverVersion());
        System.out.println("Connected to\t" + dma.getURL());
	i = str.indexOf(' ');
	int j = str.indexOf(' ', i+1);
	System.out.println("Uptime\t\t" + nice_time(str.substring(i+1,j)));
	System.out.println(str.substring(j+1));
      }
      else
        System.out.println(str);
      con.close(); 
    } 
    catch (SQLException e) 
    {
      System.out.println (e.getMessage ());
      e.printStackTrace();
      System.exit(1);
    } 
    catch (Exception e)
    { 
      e.printStackTrace(); 
      System.exit(1);
    }
    
    if (zxk_debug)
      DBug.dbug.dbReturn(294);
  }

  private String  getMessageFromServer(SQLWarning warn)
    throws SQLException  
  {
    if (warn != null) 
    {
      String s = warn.getMessage ();
      int i = s.indexOf(':');
      if (i == -1)
        throw new SQLException("Wrong and expected message started with Command=xxxx:");
      else
        return s.substring(i+2);
    }
    return null;
  }       

  private String nice_time(String secStr)
  {
    long tmp;
    long sec = new Long(secStr).longValue();
    StringBuffer sb = new StringBuffer();

    if (sec >= 3600L*24)
    {
      tmp=sec/(3600L*24);
      sec-=3600L*24*tmp;
      sb.append(tmp);
      if (tmp > 1)
        sb.append(" days ");
      else
        sb.append(" day ");
    }
    if (sec >= 3600L)
    {
      tmp=sec/3600L;
      sec-=3600L*tmp;
      sb.append(tmp);
      if (tmp > 1)
        sb.append(" hours ");
      else
        sb.append(" hour ");
    }
    if (sec >= 60)
    {
      tmp=sec/60;
      sec-=60*tmp;
      sb.append(tmp);
      if (tmp > 1)
        sb.append(" mins ");
      else
        sb.append(" min ");
    }
    sb.append(sec);
    sb.append(" sec");
    return new String(sb);
  }

  public static void main (String[] args) 
  {
    jmsadmin admin = new jmsadmin();
    admin.doit(args);
  }
}
