/**
 * $Id: kfnMysqlPreparedStatement.java,v 1.1 1997/11/25 21:21:21 xzhu Exp $
 * 
 * Copyright (c) 1997 Keystroke Financial Network, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of 
 * Keystroke Financial Network, Inc. ("Confidential Information").
 * 
 * Keystroke Financial Network MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT
 * THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package gwe.sql;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import java.util.Vector;
import java.sql.*;

/**
 * <P>A SQL statement is pre-compiled and stored in a
 * PreparedStatement object. This object can then be used to
 * efficiently execute this statement multiple times. 
 *
 * <P><B>Note:</B> The setXXX methods for setting IN parameter values
 * must specify types that are compatible with the defined SQL type of
 * the input parameter. For instance, if the IN parameter has SQL type
 * Integer then setInt should be used.
 *
 * <p>If arbitrary parameter type conversions are required then the
 * setObject method should be used with a target SQL type.
 *
 * @see Connection#prepareStatement
 * @see ResultSet 
 */

public class kfnMysqlPreparedStatement extends gweMysqlStatement
  implements java.sql.PreparedStatement
{
  public kfnMysqlPreparedStatement(gweMysqlConnection conn, String s)
    {
      super(conn);
      int count = 0;
      int parameter_count = 0;
      StringTokenizer toks = new StringTokenizer(s, "'?", true);
      template = new Vector();
      boolean in_quote = false;
      String part;
      while (toks.hasMoreElements())
	{
	  part = toks.nextToken();
	  if (in_quote)
	    {
	      String last = (String)template.elementAt(count - 1);
	      last = last.concat(part);
	      if (toks.hasMoreElements())
		{
		  String sep = toks.nextToken();
		  last = last.concat(sep);
		  in_quote = !sep.equals("'");
		}
	      template.setElementAt(last, count - 1);
	    }
	  else
	    {
	      count++;
	      template.addElement(part);
	      if (toks.hasMoreElements())
		{
		  String sep = toks.nextToken();
		  in_quote = sep.equals("'");
		  if (in_quote)
		    {
		      String last = (String)template.elementAt(count - 1);
		      last = last.concat(sep);
		      template.setElementAt(last, count - 1);
		    }
		  else
		    {
		      parameter_count++;
		    }
		}
	    }
	}
      parameters = new String[parameter_count];
    }

  public String toString()
    {
      int index = 0;
      StringBuffer sb = new StringBuffer();
      int last = parameters.length;

      for (index = 0 ; index < last; index++)
	{
	  sb.append((String)template.elementAt(index));
	  String part = parameters[index];
	  if (part == null)
	    {
	      sb.append("NULL");
	    }
	  else
	    {
	      sb.append(part);
	    }
	}
      if (last < template.size())
	{
	  sb.append((String)template.lastElement());
	}
      return(sb.toString());
    }
  /**
    * A prepared SQL query is executed and its ResultSet is returned.
    *
    * @return a ResultSet that contains the data produced by the
    * query; never null
    */
  public ResultSet executeQuery() throws SQLException
    {
      return(super.executeQuery(toString()));
    }

  /**
    * Execute a SQL INSERT, UPDATE or DELETE statement. In addition,
    * SQL statements that return nothing such as SQL DDL statements
    * can be executed.
    *
    * @return either the row count for INSERT, UPDATE or DELETE; or 0
    * for SQL statements that return nothing
    */
  public int executeUpdate() throws SQLException
    {
      return(super.executeUpdate(toString()));
    }

  /**
    * Set a parameter to SQL NULL.
    *
    * <P><B>Note:</B> You must specify the parameter's SQL type.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param sqlType SQL type code defined by java.sql.Types
    */
  public void setNull(int parameterIndex, int sqlType) throws SQLException
    {
      setParameter(parameterIndex, (String)null);
    }
  /**
    * Set a parameter to a Java boolean value.  The driver converts this
    * to a SQL BIT value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  public void setBoolean(int parameterIndex, boolean x) throws SQLException
    {
      throw new SQLException("boolean type not supported");
    }

  /**
    * Set a parameter to a Java byte value.  The driver converts this
    * to a SQL TINYINT value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  public void setByte(int parameterIndex, byte x) throws SQLException
    {
      setParameter(parameterIndex, String.valueOf(x));
    }

  /**
    * Set a parameter to a Java short value.  The driver converts this
    * to a SQL SMALLINT value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  public void setShort(int parameterIndex, short x) throws SQLException
    {
      setParameter(parameterIndex, String.valueOf(x));
    }

  /**
    * Set a parameter to a Java int value.  The driver converts this
    * to a SQL INTEGER value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  public void setInt(int parameterIndex, int x) throws SQLException
    {
      setParameter(parameterIndex, String.valueOf(x));
    }

  /**
    * Set a parameter to a Java long value.  The driver converts this
    * to a SQL BIGINT value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  public void setLong(int parameterIndex, long x) throws SQLException
    {
      setParameter(parameterIndex, String.valueOf(x));
    }

  /**
    * Set a parameter to a Java float value.  The driver converts this
    * to a SQL FLOAT value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  public void setFloat(int parameterIndex, float x) throws SQLException
    {
      setParameter(parameterIndex, String.valueOf(x));
    }

  /**
    * Set a parameter to a Java double value.  The driver converts this
    * to a SQL DOUBLE value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  public void setDouble(int parameterIndex, double x) throws SQLException
    {
      setParameter(parameterIndex, String.valueOf(x));
    }

  /**
    * Set a parameter to a java.lang.BigDecimal value.  
    * The driver converts this to a SQL NUMERIC value when
    * it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException
    {
      setParameter(parameterIndex, x.toString());
    }

  /**
    * Set a parameter to a Java String value.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  protected void setParameter(int parameterIndex, String x) throws SQLException
    {
      int last = parameters.length;

      if (parameterIndex <= 0 || parameterIndex > last)
	{
	  throw new SQLException("Invalid parameter index - "
+ parameterIndex + "< 1 or > " + last);
	}
      parameters[parameterIndex - 1] = x;
    }
  /**
    * Set a parameter to a Java String value.  The driver converts this
    * to a SQL VARCHAR or LONGVARCHAR value (depending on the arguments
    * size relative to the driver's limits on VARCHARs) when it sends
    * it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  public void setString(int parameterIndex, String x) throws SQLException
    {
      StringBuffer y = new StringBuffer("'");
      StringTokenizer toks = new StringTokenizer(x, "\\'", true);
      while (toks.hasMoreTokens())
	{
	  String part = toks.nextToken();
	  if (part.equals("\\") || part.equals("'"))
	    {
	      y.append("\\");
	    }
	  y.append(part);
	}
      y.append("'");
      setParameter(parameterIndex, y.toString());
    }
			

  /**
    * Set a parameter to a Java array of bytes.  The driver converts
    * this to a SQL VARBINARY or LONGVARBINARY (depending on the
    * argument's size relative to the driver's limits on VARBINARYs)
    * when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value 
    */
  public void setBytes(int parameterIndex, byte x[]) throws SQLException
    {
      String s = new String(x, 0);
      setString(parameterIndex, s);
    }

  /**
    * Set a parameter to a java.sql.Date value.  The driver converts this
    * to a SQL DATE value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  public void setDate(int parameterIndex, java.sql.Date x)
    throws SQLException
    {
      setString(parameterIndex, x.toString());
    }

  /**
    * Set a parameter to a java.sql.Time value.  The driver converts this
    * to a SQL TIME value when it sends it to the database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value
    */
  public void setTime(int parameterIndex, java.sql.Time x) 
    throws SQLException
    {
      setString(parameterIndex, x.toString());
    }

  /**
    * Set a parameter to a java.sql.Timestamp value.  The driver
    * converts this to a SQL TIMESTAMP value when it sends it to the
    * database.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the parameter value 
    */
  public void setTimestamp(int parameterIndex, java.sql.Timestamp x)
    throws SQLException
    {
      setString(parameterIndex, x.toString());
    }

  /**
    * When a very large ASCII value is input to a LONGVARCHAR
    * parameter, it may be more practical to send it via a
    * java.io.InputStream. JDBC will read the data from the stream
    * as needed, until it reaches end-of-file.  The JDBC driver will
    * do any necessary conversion from ASCII to the database char format.
    * 
    * <P><B>Note:</B> This stream object can either be a standard
    * Java stream object or your own subclass that implements the
    * standard interface.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the java input stream which contains the ASCII parameter value
    * @param length the number of bytes in the stream 
    */
  public void setAsciiStream(int parameterIndex, java.io.InputStream x, int length)
    throws SQLException
    {
      throw new SQLException("Unimplimented");
    }

  /**
    * When a very large UNICODE value is input to a LONGVARCHAR
    * parameter, it may be more practical to send it via a
    * java.io.InputStream. JDBC will read the data from the stream
    * as needed, until it reaches end-of-file.  The JDBC driver will
    * do any necessary conversion from UNICODE to the database char format.
    * 
    * <P><B>Note:</B> This stream object can either be a standard
    * Java stream object or your own subclass that implements the
    * standard interface.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...  
    * @param x the java input stream which contains the
    * UNICODE parameter value 
    * @param length the number of bytes in the stream 
    */
  public void setUnicodeStream(int parameterIndex, java.io.InputStream x, int length)
    throws SQLException
    {
      throw new SQLException("Unimplimented");
    }

  /**
    * When a very large binary value is input to a LONGVARBINARY
    * parameter, it may be more practical to send it via a
    * java.io.InputStream. JDBC will read the data from the stream
    * as needed, until it reaches end-of-file.
    * 
    * <P><B>Note:</B> This stream object can either be a standard
    * Java stream object or your own subclass that implements the
    * standard interface.
    *
    * @param parameterIndex the first parameter is 1, the second is 2, ...
    * @param x the java input stream which contains the binary parameter value
    * @param length the number of bytes in the stream 
    */
  public void setBinaryStream(int parameterIndex, java.io.InputStream x, int length) 
    throws SQLException
    {
      throw new SQLException("Unimplimented");
    }

  /**
    * <P>In general, parameter values remain in force for repeated use of a
    * Statement. Setting a parameter value automatically clears its
    * previous value.  However, in some cases it is useful to immediately
    * release the resources used by the current parameter values; this can
    * be done by calling clearParameters.
    */
  public void clearParameters() throws SQLException
    {
      int i;
      for (i = 0; i < parameters.length; i++)
	{
	  parameters[i] = null;
	}
    }

  //----------------------------------------------------------------------
  // Advanced features:

  /**
    * <p>Set the value of a parameter using an object; use the
    * java.lang equivalent objects for integral values.
    *
    * <p>The given Java object will be converted to the targetSqlType
    * before being sent to the database.
    *
    * <p>Note that this method may be used to pass datatabase-
    * specific abstract data types. This is done by using a Driver-
    * specific Java type and using a targetSqlType of
    * java.sql.types.OTHER.
    *
    * @param parameterIndex The first parameter is 1, the second is 2, ...
    * @param x The object containing the input parameter value
    * @param targetSqlType The SQL type (as defined in java.sql.Types) to be 
    * sent to the database. The scale argument may further qualify this type.
    * @param scale For java.sql.Types.DECIMAL or java.sql.Types.NUMERIC types
    *          this is the number of digits after the decimal.  For all other
    *          types this value will be ignored,
    * @see Types 
    */
  public void setObject(int parameterIndex, Object x, int targetSqlType, int scale)
    throws SQLException
    {
      throw new SQLException("Unimplimented");
    }

  /**
    * This method is like setObject above, but assumes a scale of zero.
    */
  public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException
    {
      throw new SQLException("Unimplimented");
    }

  /**
    * <p>Set the value of a parameter using an object; use the
    * java.lang equivalent objects for integral values.
    *
    * <p>The JDBC specification specifies a standard mapping from
    * Java Object types to SQL types.  The given argument java object
    * will be converted to the corresponding SQL type before being
    * sent to the database.
    *
    * <p>Note that this method may be used to pass datatabase
    * specific abstract data types, by using a Driver specific Java
    * type.
    *
    * @param parameterIndex The first parameter is 1, the second is 2, ...
    * @param x The object containing the input parameter value 
    */
  public void setObject(int parameterIndex, Object x) throws SQLException
    {
      throw new SQLException("Unimplimented");
    }

  /**
    * Some prepared statements return multiple results; the execute
    * method handles these complex statements as well as the simpler
    * form of statements handled by executeQuery and executeUpdate.
    *
    * @see Statement#execute
    */
  public boolean execute() throws SQLException
    {
      return(super.execute(toString()));
    }

  public int countParameters()
    {
      return(parameters.length);
    }

  public static void main(String[] args)
    {
      String driver = "gwe.sql.gweMysqlDriver";
      String dburl = "jdbc:mysql://localhost/test";
      try
	{
	  Class.forName(driver); // Driver
	  Connection con;

	  con = DriverManager.getConnection(dburl, "", "");

	  int i;

	  kfnMysqlPreparedStatement stmt = new kfnMysqlPreparedStatement((gweMysqlConnection)con, args[0]);

	  for (i = 0; i < stmt.countParameters(); i++)
	    {
	      stmt.setInt(i + 1, i + 1);
	      System.out.println(stmt.toString() + "\n\n");
	    }
				
	  stmt.clearParameters();

	  for (i = 1; i < args.length; i++)
	    {
	      stmt.setString(i, args[i]);
	      System.out.println("Arg[" + i + "] = " + args[i]);
	      System.out.println(stmt.toString() + "\n\n");
	    }
	}
      catch (SQLException e)
	{
	  System.out.println("SQL error " + e);
	}
      catch (java.lang.ClassNotFoundException e)
	{
	  System.out.println("Class error " + e);
	}
    }

  private Vector template;
  private String[] parameters;
}
