/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ICETracer {
    public static final String RCS_ID = "$Id: ICETracer.java,v 1.4 1998/04/29 16:30:13 time Exp $";
    public static final String RCS_REV = "$Revision: 1.4 $";
    private static PrintWriter out = null;
    private static boolean state;
    private static boolean ifOverOn;
    private static int traceState;
    private static boolean outIsSystem;
    private static boolean echoAccum;
    private static StringBuffer outBuffer;

    public static void setTraceState(boolean bl) {
        state = bl;
    }

    public static void setEchoAccumulation(boolean bl) {
        echoAccum = bl;
    }

    public static void accumulateInBuffer(StringBuffer stringBuffer) {
        outBuffer = stringBuffer;
    }

    public static void turnOffAccumulation() {
        outBuffer = null;
    }

    public static StringBuffer getAccumulationBuffer() {
        return outBuffer;
    }

    public static void println(String string) {
        if (string == null) {
            return;
        }
        if (outBuffer != null) {
            outBuffer.append(string);
            outBuffer.append("\n");
            if (!echoAccum) {
                return;
            }
        }
        if (out != null) {
            out.println(string);
            return;
        }
        System.err.println(string);
    }

    public static void trace(String string) {
        if (string == null) {
            return;
        }
        if (state) {
            ICETracer.println(string);
        }
    }

    public static void traceIf(boolean bl, String string) {
        if (!bl || string == null) {
            return;
        }
        if (ifOverOn) {
            ICETracer.println(string);
        }
    }

    public static void traceWithStack(String string) {
        if (string == null) {
            return;
        }
        Throwable throwable = new Throwable(string);
        if (state) {
            ICETracer.println(string);
        }
        if (out == null) {
            throwable.printStackTrace(System.err);
            return;
        }
        throwable.printStackTrace(out);
    }

    public static String getStackLines(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static String getStackLines(Throwable throwable, int n) {
        if (n == 0) {
            return ICETracer.getStackLines(throwable);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = stringWriter.getBuffer().toString();
        String string2 = System.getProperty("line.separator", "\n");
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n) {
            int n5 = string.indexOf(string2, n2);
            if (n5 == -1) break;
            n3 = n5;
            n2 = n5 + 1;
            ++n4;
        }
        return string.substring(0, n3);
    }

    public static void traceWithStack(int n, String string) {
        if (string == null || n < 1) {
            return;
        }
        Throwable throwable = new Throwable(string);
        if (state) {
            ICETracer.println(string);
        }
        String string2 = ICETracer.getStackLines(throwable, n);
        if (out == null) {
            System.err.println(string2);
            return;
        }
        out.println(string2);
    }

    public static void traceWithStack(Throwable throwable, String string) {
        if (throwable == null && string == null) {
            return;
        }
        if (string != null) {
            ICETracer.println(string);
        }
        String string2 = ICETracer.getStackLines(throwable, 0);
        if (out == null) {
            System.err.println(string2);
            return;
        }
        out.println(string2);
    }

    public static void traceWithStack(Throwable throwable, int n, String string) {
        if (throwable == null && string == null) {
            return;
        }
        if (string != null) {
            ICETracer.println(string);
        }
        String string2 = ICETracer.getStackLines(throwable, n);
        if (out == null) {
            System.err.println(string2);
            return;
        }
        out.println(string2);
    }

    private static void checkClose() {
        if (out != null && !outIsSystem) {
            out.close();
            out = null;
            outIsSystem = false;
        }
    }

    public static void setWriter(PrintWriter printWriter) {
        ICETracer.checkClose();
        out = printWriter;
        outIsSystem = false;
        outBuffer = null;
    }

    public static void setWriterToStdout() {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        if (printWriter != null) {
            ICETracer.checkClose();
            out = printWriter;
            outIsSystem = true;
            outBuffer = null;
        }
    }

    public static void setWriterToStderr() {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.err));
        if (printWriter != null) {
            ICETracer.checkClose();
            out = printWriter;
            outIsSystem = true;
            outBuffer = null;
        }
    }

    static {
        ifOverOn = true;
        outBuffer = null;
    }
}

