	    Appendixes / Additions to the MicroX Manual

XDM
----

MicroX uses the standard protocol specified by the X Consortium for use with
X terminals, the X Display Manager Control Protocol, or XDMCP.  XDMCP is
a part of revision 4 of X version 11 and is avaliable from Sun as part
of SunOS 4.1 or from DEC as part of Ultrix 4.2.  If you have a host on
your network with these versions or later, you should run MicroX in the
Revision 4 mode.

To get a login prompt from a host, that host must be running xdm as a
daemon.  To check if xdm is running and is of version X11R4, type the
following command on your host system:

% netstat -an | grep 177

If xdm is running and uses XDMCP, you will see this line:

udp        0      0  *.177                  *.*

If that line does not appear, get a system manager on your host to start
xdm.  If it still doesn't appear, then the xdm on your host may not be
of the necessary version.


HOST ACCESS LIST
----

When an X client attempts to open an X display, the server checks to see
if that client is authorized to connect before it allows the connection.
If the client is not authorized, it gives a message such as:

Xlib:  connection to "server:0.0" refused by server
Xlib:  Server is not authorized to connect to host
Error: Can't Open display

The X11 R3 release gave only one method of authorizing clients to connect.
That method is giving access based on the IP address of the host on which
the client runs, also known as "xhost".  The disadvantage of this method
is that when you give access to a host, call it "host1", everyone who
has an account on "host1" can access your display.  Once they have access,
they can move or delete windows, or even worse.

X11 R4 introduced a new method of authorizing hosts, called X authorization,
or MIT-MAGIC-COOKIE-1.  When you log in using X11, revision 4, xdm creates
a file named ".Xauthority" in your home directory.  In this file is
a 16-byte key, or cookie, that is sent to the server as part of the
connection setup information by X11 R4 clients.  If your host is not
in the "xhost" list, but sends the correct cookie, then it will still
be allowed to connect.  Thus, when using X11R4, your "xhost" access list
will typically be empty but clients will still be able to connect.

MicroX obtains the "magic cookie" from xdm using XDMCP.  The cookie is
generated by a random number generator in xdm.  If MicroX is started
this way, the initial "xhost" access list is empty, and access is
restricted.  If it is not started with XDMCP, then access control is
disabled (any client is allowed to connect).

If you use a revision 4 xdm to get your login window, and want to bring
up older (R3) clients on your display, you need to add the hosts on which
those clients run to your access list.  To do this, simply add the host
using the xhost command before bringing up the window.

You can make a permanent list of host that are in the access list of
MicroX by putting those hosts in a file named "HOSTS.X0" in the X11
directory.  You may want to do this in two instances:

1. You use MicroX in the non-XDMCP mode (any client is allowed to connect),
    and want to limit the access list to "trusted" hosts.
2. You use it in the XDMCP mode (only R4 clients with correct cookie
    allowed) and want to allow R3 clients from specific host(s) to
    connect to your server.

To make this permanent list, change to the X11 directory (its name is in the
DOS variable "X11") and edit the file "HOSTS.X0" (that's a zero, not an o)
with a standard text editor such as EDLIN.  On each line of this file put
an IP address (such as "192.1.1.31").


FONTS
----

MicroX comes supplied with [all - 386] [some - 286] of the fonts available
from the MIT X distribution.  [386 - These fonts are placed in mandatory
and optional groups according to their usefulness.]  If you have a need for
fonts that are not supplied you can create your own fonts with the MicroX
font compiler.

You must start with the BDF version of the font(s) you wish to install.  If
you do not have the BDF version you may extract it from a server on which
the font is installed with a public-domain program called getbdf (not
supplied).  Use the bdftosnf program to compile the BDF font(s) into the
SNF equivalent(s).  They syntax is slightly different from the bdftosnf
program on the MIT distribution.  Use this syntax:

C:\MICROX\LIB\FONTS\75DPI>bdftosnf -t -o font1.snf font1.bdf

After you have compiled the fonts you wish to install, run the mkfntdir
program on the font directory.  This program updates the fonts.dir file
to show the new font(s) installed.  If you have just compiled your font(s)
in the current directory, give the mkfntdir program no arguments.


DOS 5.0
----
[The following is only for the 286 version.  (Since the 386 version
runs in high memory itself, there is no need to load DOS into high
memory also.)]
If you run MS-DOS version 5.0 and have 1mB of RAM you can give MicroX
approximately 48kB more memory for such things as fonts, windows, pixmaps,
and as a buffer to prevent "Out of memory" conditions.  To give MicroX
this extra memory, you must load DOS into high memory (memory above 640k).
To do this add the HIMEM.SYS driver to CONFIG.SYS, then add the line
DOS=HIGH.  Here is an example of a CONFIG.SYS file when running under
DOS 5.0:

DEVICE=\DOS\HIMEM.SYS
DOS=HIGH
BUFFERS=20
FILES=10
SHELL=\COMMAND.COM /p/e:512
DEVICE=C:\MICROX\LIB\AHEADB.SYS


HOTKEYS
----
To exit MicroX:

If you have chosen to return to DOS after logging out of your X session,
then MicroX will exit to DOS when you log out of your XDM session.  If
you have chosen to stay in MicroX when you log out, or if you are
unable to log out of your session for some reason, then you may use
the "Exit" key.  The "Exit" key is activated by holding down the "Alt"
key and simultaneously pressing F10.  This will cleanly shutdown MicroX
and close all X clients.

[386 only]

You may suspend the execution of MicroX by using the "hot key to DOS".
To activate this hold down the "Alt" key and press "Sys Req" key.  This
will give you a DOS prompt.  You may do any DOS command at this point
except network programs.  If you wish, you may even install new fonts
at this point, exit back to MicroX, issue the command "xset fp rehash"
and the fonts you just installed will be availiable to X clients.

MicroX will do TCP processing while suspended so your clients will keep
their connection to the server, but no X requests will be processed.


RE-INSTALLATION
----

What if you change your Ethernet card, your VGA card, your monitor,
your IP address or the address of your XDMCP server?  Fortunately,
you don't need to re-install MicroX from the distribution.

1.  A change in your IP address, the XDMCP server's address, your
    nameserver, default domain, or monitor.

To change one of these, run installx.  Installx is the program that
is run last as part of the install process.  It asks you if you are
running xdm revision 4, prompts you for the address of the machine
running xdm, and the resolution supported by your monitor.  It then
prompts you for information used to create a CONFIG.TEL file:  Your
IP address, the address of your nameserver, and your defualt domain.

Experienced users may wish to make these changes manually by using
a text editor to edit the files X.BAT and CONFIG.TEL.  If MicroX
won't work after editing these files, you can run installx to have
them recreated for you.

2.  A new Ethernet card is installed.

A different Ethernet card requires a different packet driver.  If your
installation of MicroX installed the packet drivers, then they will
be in the directory MICROX/PKDRVR.  [Is this right?]  Your new Ethernet
board may have a different I/O address so you need to know it to
run the correct packet driver.

Using a text editor, edit your AUTOEXEC.BAT file and replace the line
which started your old packet driver with the packet driver and
appropriate arguments for the new board.  The first argument to most
packet drivers is the packet driver interrupt number which is usually
0x60 (60 Hex).  If you are not sure of the arguments to the packet
driver, you may experiment by removing the packet driver from the
AUTOEXEC.BAT file and running it manually with different arguments
until it reports that it has sucessfully initialized your Ethernet board.

3.  A new VGA card is installed.

[286]
There is a DEVICE= line in the CONFIG.SYS file for the current VGA card.
The install program found out what kind of VGA card is in your machine
and installed the appropriate line in the CONFIG.SYS file.  If you change
VGA card, you need to change this line to the VGA driver for the new VGA
card.

	[Should we include a list of VGA drivers here?]

[386]
In the MICROX\LIB directory are VGA drivers for all the VGA cards that
MicroX supports.  Also in this directory is a file named VGA.DRV.  This
file was copied from the VGA driver that was determined appropriate for
your VGA card by the install program.  To use MicroX with a new VGA card,
simply copy the driver for that card into VGA.DRV.
