#include <dos.h>
#include <io.h>

#include "netdef.h"
#include "in.h"
#include "shared.h"
#include "net.h"
#include "tcp.h"	/* for State #defines */
#include "../msdos/msdos.h"

#ifndef NULL
#define NULL 0
#endif

#define TCPCONN

#define OUTBUFSIZE	512
/* MAXBUFSIZE must be a multiple of 4.  It is the maximum size of an X request.
*/
#define MAXBUFSIZE	16384
#define MAXOUTBUF	8192
#define ANRSIZE		512

typedef struct _connection {
    struct _connection *next;
    char *buffer;               /* contains current client input */
    int  count;                /* count of bytes in buffer */
    int size;
} Connection, *ConnectionPtr;

typedef struct _osComm {
    struct tcpport tcpport;
    int fd;
    ConnectionPtr input;
    ConnectionPtr output;
    u_short flags;
    int client;
    unsigned long conn_time;
    int priority;
} OsCommRec, *OsCommPtr;

#define MAXPRIORITY	200

#define OS_REUSE	0x0001		/* re-use the request in the buffer */
#define OS_REQUEST	0x0002		/* full request left in input buffer */
#define OS_BLOCKED	0x0004		/* output write-blocked */
#define OS_CLOSING	0x0200		/* wait for output to drain first */

/* #define X_PRINT_PORT	5600 */
#define XDMCP
