/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: os.h,v 1.39 89/12/06 16:41:26 rws Exp $ */

#ifndef OS_H
#define OS_H
#include "misc.h"
#include <string.h>

#define bcopy(s,d,c)	memcpy(d,s,c)
#define ovbcopy(s,d,c)	memmove(d,s,c)
#define bzero(a,c)	memset(a, 0, c)
#define bcmp		memcmp

void	cli(void);
#pragma aux	cli = \
	"cli"	\
	parm	nomemory modify	nomemory;

void	sti(void);
#pragma aux	sti = \
	"sti"	\
	parm	nomemory modify	nomemory;

#define	STI	sti()
#define CLI	cli()

extern unsigned long n_clicks(void);

extern char *X11env;

#include <malloc.h>

#ifdef INCLUDE_ALLOCA
#include <alloca.h>
#endif

#define NullFID ((FID) 0)

#define SCREEN_SAVER_ON   0
#define SCREEN_SAVER_OFF  1
#define SCREEN_SAVER_FORCER 2

#if defined(stellar)
#define MAX_REQUEST_SIZE 65535
#else
/* #define MAX_REQUEST_SIZE 16384 */
/* this number is shifted left by 2.  If we use the above number on a
 * 16 bit machine we get 0!  Actually, using 8191 is pretty silly because
 * if it's bigger than that shifted left by 2 it's probably negative. */
#define MAX_REQUEST_SIZE 8191
#endif

typedef pointer	FID;
typedef struct _FontPathRec *FontPathPtr;
typedef struct _NewClientRec *NewClientPtr;

#ifndef NO_ALLOCA
/*
 * os-dependent definition of local allocation and deallocation
 * If you want something other than Xalloc/Xfree for ALLOCATE/DEALLOCATE
 * LOCAL then you add that in here.
 */
#if defined(__HIGHC__)

#if HCVERSION < 21003
extern char *_mwstack_limit[];
#define ALLOCATE_LOCAL(size)	((char *)alloca(0) - (size) < _mwstack_limit[0] ? 0 : alloca(size))
pragma on(alloca);
#else /* HCVERSION >= 21003 */
foo
#define	ALLOCATE_LOCAL(size)	_Alloca(size)
#endif /* HCVERSION < 21003 */

#define DEALLOCATE_LOCAL(ptr)  /* as nothing */

#endif /* defined(__HIGHC__) */


#ifdef __GNUC__
#define alloca __builtin_alloca
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#else /* ! __GNUC__ */
/*
 * warning: mips alloca is unsuitable in the server, do not use.
 */
#if defined(vax) || defined(sun) || defined(apollo) || defined(stellar)
/*
 * Some System V boxes extract alloca.o from /lib/libPW.a; if you
 * decide that you don't want to use alloca, you might want to fix 
 * ../os/4.2bsd/Imakefile
 */
char *alloca();
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#endif /* who does alloca */
#endif /* __GNUC__ */

#ifndef ALLOCATE_LOCAL
#ifdef __WATCOMC__
/* msdos */
#define ALLOCATE_LOCAL(size) alloca(size)
#endif
#endif

#define DEALLOCATE_LOCAL(ptr)  /* as nothing */

#endif /* NO_ALLOCA */

#ifndef ALLOCATE_LOCAL
#define ALLOCATE_LOCAL(size) Xalloc(size)
#define DEALLOCATE_LOCAL(ptr) Xfree((pointer)(ptr))
#endif /* ALLOCATE_LOCAL */

#define xalloc(size) Xalloc(size)
#define xrealloc(ptr, size) Xrealloc(ptr, size)
#define xfree(ptr) Xfree(ptr)

struct overlay { unsigned long off; unsigned short seg; };
extern unsigned char *bios;

/* memory functions */
int	delete_selector(unsigned short);
int	get_real_window(unsigned long, unsigned long);
int	get_window(unsigned char _far *base, unsigned long size);
int	code2data(unsigned char _far *code);

int		ReadRequestFromClient(struct _Client *);
Bool		CloseDownConnection(struct _Client *);
char  *ClientAuthorized(struct  _Client *client,unsigned short  proto_n,char  *auth_proto,unsigned short  string_n,char  *auth_string);
void  OnlyListenToOneClient(struct  _Client *client);
void ListenToAllClients(void);
int WaitForSomething(int *);
int  InsertFakeRequest(struct  _Client *client,char  *data,int  count);
void ResetCurrentRequest(struct  _Client *client);
int  WriteToClient(struct  _Client *who,int  count,char  *buf);
int  OsLookupColor(int, char *, unsigned int,
			unsigned short *, unsigned short *, unsigned short *);
int ChangeAccessControl(struct _Client *client, int fEnabled);
int  AddHost(struct  _Client *client,unsigned char  family,unsigned length,void *pAddr);
int  RemoveHost(struct  _Client *client,unsigned char  family,unsigned length,void *pAddr);
int GetHosts (void **, int *, int *, unsigned char *);
FontPathPtr	GetFontPath();
FontPathPtr ExpandFontNamePattern(unsigned lenpat,char  *countedPattern,
			unsigned int maxNames);
FID		FiOpenForRead();
int	FontFileRead(char *, unsigned, unsigned, FID);
int	FontFileSkip(unsigned, FID);
void		CreateWellKnownSockets(void);
void		ResetWellKnownSockets(void);
void		OsInit(void);
void		InitInput(int, char **);
int		SetDefaultFontPath(char *);
void		FreeFontRecord();
int  SetFontPath(struct  _Client *client,unsigned int  npaths,char  *countedStrings);
void		ErrorF(char *,...);
void		Error();
void		FatalError(char *,...);
void		GiveUp(int);
void		ProcessCommandLine(int, char **);
void		Xfree(void *);
void		FlushAllOutput();
void		FlushIfCriticalOutputPending();
void		*Xalloc(unsigned int);
void		*Xrealloc(void *, unsigned int);
unsigned long	GetTimeInMillis();

#endif /* OS_H */
