/*
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

*/
/* $XConsortium: colormap.h,v 1.22 90/01/13 17:30:13 rws Exp $ */
#ifndef CMAP_H
#define CMAP_H 1

/* these follow X.h's AllocNone and AllocAll */
#define CM_PSCREEN 2
#define CM_PWIN	   3
/* Passed internally in colormap.c */
#define REDMAP 0
#define GREENMAP 1
#define BLUEMAP 2
#define PSEUDOMAP 3
#define AllocPrivate (-1)
#define AllocTemporary (-2)
#define DynamicClass  1

#ifdef notdef
/* Gets the color from a cell as an Rvalue */
#define RRED(cell) (((cell)->fShared) ? ((cell)->co.shco.red->color): \
		    ((cell)->co.local.red))
#define RGREEN(cell) (((cell)->fShared) ? ((cell)->co.shco.green->color): \
		    ((cell)->co.local.green))
#define RBLUE(cell) (((cell)->fShared) ? ((cell)->co.shco.blue->color): \
		    ((cell)->co.local.blue))

/* Gets the color from a cell as an L value */
#define LRED(cell) (((cell)->fShared) ? (&((cell)->co.shco.red->color)) : \
		    (&((cell)->co.local.red)))
#define LGREEN(cell) (((cell)->fShared) ? (&((cell)->co.shco.green->color)) : \
		    (&((cell)->co.local.green)))
#define LBLUE(cell) (((cell)->fShared) ? (&((cell)->co.shco.blue->color)) : \
		    (&((cell)->co.local.blue)))
#endif

/* Values for the flags field of a colormap. These should have 1 bit set
 * and not overlap */
#define IsDefault 1
#define AllAllocated 2
#define BeingCreated 4


typedef unsigned long	Pixel;
typedef struct _CMEntry *EntryPtr;
typedef struct _ColormapRec *ColormapPtr;

int CreateColormap(unsigned long, struct _Screen *,
	struct _Visual *, ColormapPtr *, int, int);
/* extern int FindColor(); */
int  TellLostMap(struct  _Window  *pwin,unsigned long  *pmid);
int  TellGainedMap(struct  _Window  *pwin,unsigned long  *pmid);
int  IsMapInstalled(unsigned long  map,struct  _Window  *pWin);
void UninstallColormap(ColormapPtr);
int  CopyColormapAndFree(unsigned long  mid, ColormapPtr pSrc,
				int  client);

int  AllocColor(ColormapPtr pmap,unsigned short  *pred,unsigned short  *pgreen,
		unsigned short  *pblue,unsigned long  *pPix,int  client);
void  FakeAllocColor(ColormapPtr pmap,struct  _xColorItem *item);
void  FakeFreeColor(ColormapPtr pmap,unsigned long  pixel);
int  QueryColors(ColormapPtr pmap,int  count,unsigned long  *ppixIn,
		struct  _xrgb *prgbList);

int  AllocColorCells(int  client,ColormapPtr pmap,int  colors,int  planes,
	int  contig,unsigned long  *ppix,unsigned long  *masks);
int  AllocColorPlanes(int  client,ColormapPtr pmap,int  colors,int  r,int  g,
			int  b,int  contig,unsigned long  *pixels,
			unsigned long  *prmask,unsigned long  *pgmask,
			unsigned long  *pbmask);

int  FreeColors(ColormapPtr pmap,int  client,int  count,unsigned long  *pixels,
			unsigned long  mask);
int  StoreColors(struct  _ColormapRec *pmap,int  count,
			struct  _xColorItem *defs);

#endif /* CMAP_H */
