#define FAR _far
#include "c:/os386/aiacode/os386.h"
#include "shared.h"
#include "funcdef.h"

extern struct real_data near shared;

typedef unsigned short u_short;

void
dump_regs(taskid, status)
u_short taskid;
u_short status;
{
	int i;
	TSS_386 tss;

	taskid = OS386_Get_Task_ID();
	dfputs("Process faulted ");
	printn(status);
	dfputs("\r\n");
	if (shared.flags & KBD_OPEN)
		kbd_shutdown();
	if (shared.flags & MOUSE_OPEN)
		mouse_shutdown();
	if ((i = OS386_Read_Mem(taskid, OS386_Get_TSS(taskid), 0L,
	    sizeof (tss), &tss)) != R_OK) {
		dfputs("Can't read TSS ");
		printn(i);
		dfputs("\r\n");
		return;
	}
	dfputs("eip=");
	printn((u_short)(tss.eip >> 16));
	printn((u_short)tss.eip);
	dfputs("\tcs=");
	printn(tss.cs);
	dfputs("\tds=");
	printn(tss.ds);
	dfputs("\tes=");
	printn(tss.es);
	dfputs("\tfs=");
	printn(tss.fs);
	dfputs("\tgs=");
	printn(tss.gs);
	dfputs("\tss=");
	printn(tss.ss);
	dfputs("\r\nesi=");
	printn((u_short)(tss.esi >> 16));
	printn((u_short)tss.esi);
	dfputs("\tedi=");
	printn((u_short)(tss.edi >> 16));
	printn((u_short)tss.edi);
	dfputs("\tesp=");
	printn((u_short)(tss.esp >> 16));
	printn((u_short)tss.esp);
	dfputs("\tebp=");
	printn((u_short)(tss.ebp >> 16));
	printn((u_short)tss.ebp);
	dfputs("\r\neax=");
	printn((u_short)(tss.eax >> 16));
	printn((u_short)tss.eax);
	dfputs("\tebx=");
	printn((u_short)(tss.ebx >> 16));
	printn((u_short)tss.ebx);
	dfputs("\tecx=");
	printn((u_short)(tss.ecx >> 16));
	printn((u_short)tss.ecx);
	dfputs("\tedx=");
	printn((u_short)(tss.edx >> 16));
	printn((u_short)tss.edx);
	dfputs("\r\n");
	return;
}
