/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: miglblt.c,v 1.18 88/09/06 14:49:13 jim Exp $ */

#include	"X.h"
#include	"Xmd.h"
#include	"Xproto.h"
#include	"fontstruct.h"
#include	"dixfontstr.h"
#include	"gcstruct.h"
#include	"windowstr.h"
#include	"scrnintstr.h"
#include	"pixmap.h"
#include	"servermd.h"
#include	"svga.h"
#include	"svgafuncs.h"
#include	"funcs.h"
#include "mxfuncs.h"

void
mxPolyGlyphBlt(pDrawable, pGC, x, y, nglyph, ppci, pglyphBase)
    DrawablePtr pDrawable;
    GC 		*pGC;
    int 	x, y;
    unsigned int nglyph;
    CharInfoPtr *ppci;		/* array of character info */
    unsigned char *pglyphBase;	/* start of array of glyphs */
{
    FontRec *pfont;
    CharInfoPtr pci;			/* currect char info */
    PixmapRec Pixmap;
    ExtentInfoRec info;		/* used by QueryGlyphExtents() */

    if (pGC->miTranslate) {
	x += pDrawable->x;
	y += pDrawable->y;
    }
    pfont = pGC->font;

    /* Make enough space to hold all characters */
    pci = *ppci;
    if (nglyph == 1) {
	Pixmap.drawable.width = GLYPHWIDTHPIXELS(pci);
	info.overallAscent = pci->metrics.ascent;
	Pixmap.drawable.height = info.overallAscent + pci->metrics.descent;
    } else {
	QueryGlyphExtents(pfont, ppci, nglyph, &info);
	Pixmap.drawable.width = info.overallRight - info.overallLeft;
	Pixmap.drawable.height = info.overallAscent + info.overallDescent;
    }
    Pixmap.drawable.pScreen = pDrawable->pScreen;
    Pixmap.devKind = PixmapBytePad(Pixmap.drawable.width, 1);
    Pixmap.devPrivate.ptr =
	    ALLOCATE_LOCAL(Pixmap.devKind * Pixmap.drawable.height);
    draw_chars(&Pixmap, ppci, nglyph, info.overallAscent, pglyphBase);

    x += pci->metrics.leftSideBearing;	/* first char */
    y -= info.overallAscent;

    mxPushPixels(pGC, &Pixmap, pDrawable,
	    Pixmap.drawable.width, Pixmap.drawable.height, x, y);
    DEALLOCATE_LOCAL(Pixmap.devPrivate.ptr);
}

void
mxImageGlyphBlt(pDrawable, pGC, x, y, nglyph, ppci, pglyphBase)
    DrawablePtr pDrawable;
    GC 		*pGC;
    int 	x, y;
    unsigned int nglyph;
    CharInfoPtr *ppci;		/* array of character info */
    unsigned char *pglyphBase;	/* start of array of glyphs */
{
    FontRec *pfont;
    ExtentInfoRec info;		/* used by QueryGlyphExtents() */
    GC gc;
    svgaPrivGC	*pPriv = (svgaPrivGC *)(pGC->devPrivates[svgaGCPrivateIndex].ptr);
    void (* movebyte)(u_char *, u_char, int, u_char) = pPriv->movebyte;
    PixmapRec Pixmap;

    gc = *pGC;
    gc.alu = GXcopy;
    gc.planemask = 0xff;
    pPriv->movebyte = copybyte;

    pfont = gc.font;
    if (nglyph == 1) {
	Pixmap.drawable.width = GLYPHWIDTHPIXELS(*ppci);
	info.overallAscent = (*ppci)->metrics.ascent;
	info.overallWidth = (*ppci)->metrics.characterWidth;
	info.fontAscent = pfont->pFI->fontAscent;
	info.fontDescent = pfont->pFI->fontDescent;
	Pixmap.drawable.height = info.overallAscent + (*ppci)->metrics.descent;
    } else {
	QueryGlyphExtents(pfont, ppci, nglyph, &info);
	Pixmap.drawable.width = info.overallRight - info.overallLeft;
	Pixmap.drawable.height = info.overallAscent + info.overallDescent;
    }
    /* According to the protocol, we first fill the rectangle with the
     * background pixel.
     */
    gc.fillStyle = FillSolid;
    gc.fgPixel = gc.bgPixel;
    mxBox(pDrawable, &gc, x, y - info.fontAscent, info.overallWidth,
	info.fontAscent + info.fontDescent);

    Pixmap.drawable.pScreen = pDrawable->pScreen;
    Pixmap.devKind = PixmapBytePad(Pixmap.drawable.width, 1);
    Pixmap.devPrivate.ptr = ALLOCATE_LOCAL(Pixmap.devKind * Pixmap.drawable.height);
    draw_chars(&Pixmap, ppci, nglyph, info.overallAscent, pglyphBase);

    x += (*ppci)->metrics.leftSideBearing;	/* first char */
    y -= info.overallAscent;

    gc.fillStyle = FillStippled;
    gc.patOrg.x = x;
    gc.patOrg.y = y;
    gc.stipple = &Pixmap;
    gc.fgPixel = pGC->fgPixel;
    mxBox(pDrawable, &gc, x, y, Pixmap.drawable.width, Pixmap.drawable.height);

    pPriv->movebyte = movebyte;
}

static void
mxBox(pDrawable, pGC, x, y, w, h)
DrawablePtr pDrawable;
GCPtr pGC;
int x, y, w, h;
{
    BoxRec box;
    DDXPointPtr		ppt, pptFirst;
    int	*pw, *pwFirst;

    x += pDrawable->x;
    y += pDrawable->y;

    box.x1 = x;
    box.x2 = x + w;
    box.y1 = y;
    box.y2 = y + h;
    pptFirst = (DDXPointPtr) ALLOCATE_LOCAL(h * sizeof(DDXPointRec));
    ppt = pptFirst;
    pwFirst = (int *) ALLOCATE_LOCAL(h * sizeof(int));
    pw = pwFirst;
    while (y < box.y2) {
	ppt->x = x;
	ppt->y = y++;
	ppt++;
	*pw++ = w;
    }

    mxFillSpans(pDrawable, pGC, h, pptFirst, pwFirst,
	SPANS_SORTED|SPANS_RECT, &box);

    DEALLOCATE_LOCAL(pwFirst);
    DEALLOCATE_LOCAL(pptFirst);
}

static void
draw_chars(pPixmap, ppci, nglyph, maxAscent, pglyphBase)
PixmapPtr pPixmap;
CharInfoPtr *ppci;		/* array of character info */
int nglyph;
int maxAscent;
unsigned char *pglyphBase;	/* start of array of glyphs */
{
    int nbytes = pPixmap->devKind;
    u_char *ptr;
    CharInfoPtr pci;			/* currect char info */
    int xshift;
    int height = pPixmap->drawable.height;
    unsigned char *pglyph;		/* pointer bits in glyph */

    pPixmap->drawable.type = DRAWABLE_PIXMAP;
    pPixmap->drawable.class = 0;
    pPixmap->drawable.depth = 1;
    pPixmap->drawable.bitsPerPixel = 1;
    pPixmap->drawable.serialNumber = NEXT_SERIAL_NUMBER;
    pPixmap->drawable.x = 0;
    pPixmap->drawable.y = 0;
    pPixmap->refcnt = 1;
    pPixmap->devKind = nbytes;
    ptr = pPixmap->devPrivate.ptr;
    bzero(ptr, nbytes * height);

    xshift = 0;			/* First character starts at 0. */

    pci = *ppci;

    for (;;) {
	int gHeight, gWidth, nbyGlyphWidth;
	u_char rshift, lshift;
	u_char *line;
	int i;

	gHeight = GLYPHHEIGHTPIXELS(pci);
	gWidth = GLYPHWIDTHPIXELS(pci);
	nbyGlyphWidth = GLYPHWIDTHBYTESPADDED(pci);

	rshift = (u_char)(xshift & 7);
	lshift = (u_char)8 - rshift;
	line = ptr + xshift / 8 + nbytes * (maxAscent - pci->metrics.ascent);
	pglyph = pglyphBase + pci->byteOffset;

	/* Change gWidth into number of bytes - 1 */
	gWidth = gWidth - 1 >> 3;

	if (!gWidth) {
	    /* This glyph is 8 bits or less */
	    gWidth = nbytes - 1;
	    for (i = gHeight; i > 0; i--) {
		*line++ |= *pglyph >> rshift;
		*line   |= *pglyph << lshift;
		line += gWidth;
		pglyph += nbyGlyphWidth;
	    }
	} else {
	    int w, j;

	    gWidth++;
	    w = nbytes - gWidth;
	    for (i = 0; i < gHeight; i++) {
		for (j = 0; j < gWidth; j++) {
		    *line++ |= pglyph[j] >> rshift;
		    *line   |= pglyph[j] << lshift;
		}
		line += w;
		pglyph += nbyGlyphWidth;
	    }
	}

	/* Are there more characters? */
	if (!--nglyph)
	    break;

	/* Point xshift to "center" of character. */
	xshift -= pci->metrics.leftSideBearing;

	/* Bump xshift to "center" of next character. */
	xshift += pci->metrics.characterWidth;

	pci = *++ppci;	/* next character */

	/* Back xshift to left of next character. */
	xshift += pci->metrics.leftSideBearing;
    }
}
