#include "X.h"
#include "Xmd.h"
#include "Xproto.h"

#include "misc.h"
#include "regionstr.h"
#include "gcstruct.h"
#include "windowstr.h"
#include "pixmapstr.h"
#include "scrnintstr.h"

#include "ega.h"

#include "servermd.h"
#include "../common/ibmmouse.h"
#include "egafuncs.h"
#include "mxfuncs.h"
#include <dos.h>

void
mxGetSpans(pDrawable, wMax, ppt, pwidth, nspans, pdst)
    DrawablePtr		pDrawable;
    int			wMax;		/* largest value of all *pwidths */
    register DDXPointPtr ppt;
    int	*pwidth;
    int			nspans;
    unsigned char	*pdst;
{
    register DDXPointPtr pptLast;	/* one past last point to get */
    int 		widthSrc;	/* width of bitmap in bytes */
    int	 		srcBit;
    int			xEnd, w;
    int			iswin;
    unsigned char	VGA_BASED *psrcBase, VGA_BASED *psrc;

    pptLast = ppt + nspans;

    wMax = PixmapBytePad(wMax, 1);
    if (pDrawable->type == DRAWABLE_WINDOW)
    {

	iswin = 1;
	psrcBase = vga_mem(0);
	widthSrc = vga_width;
	/* Turn cursor off */
	if (CUR_OVERLAP(pDrawable->x, pDrawable->y,
	    pDrawable->x + pDrawable->width,
	    pDrawable->y + pDrawable->height))
		HideCursor();
    }
    else
    {
	iswin = 0;
	psrcBase = ((PixmapPtr)pDrawable)->devPrivate.ptr;
	widthSrc = (int)(((PixmapPtr)pDrawable)->devKind);
    }

    while(ppt < pptLast)
    {
	xEnd = min(ppt->x + *pwidth, widthSrc << 3);
	pwidth++;
	psrc = psrcBase + (ppt->y * widthSrc) + (ppt->x >> 3); 
#ifdef EGA_HIRES
	if (iswin && vga_hires) {
	    if (psrc > vga_mem(0xffff)) {
		psrc -= 0x10000;
		if (!vga_curpage) {
		    vga_curpage = 1;
		    SetPage();
		}
	    } else if (vga_curpage) {
		vga_curpage = 0;
		SetPage();
	    }
	}
#endif
	w = xEnd - ppt->x;
	srcBit = ppt->x & 7;

	copybits(pdst, psrc, 0, srcBit, w);
        pdst += wMax;
	ppt++;
    }
}

void
mxGetImage(pDrawable, x, y, width, height, format, planeMask, pDst)
DrawablePtr pDrawable;
unsigned x, y;
int width, height;
unsigned int format;
unsigned long planeMask;
pointer pDst;
{
    int iswin;
    unsigned char VGA_BASED *psrcBase;
    int bytewidth;
#ifdef EGA_HIRES
    int extra;
#endif

    format = format;	/* Because this is monochrome, all formats are
			 * the same.
			 */
    planeMask = planeMask;
    if (pDrawable->type == DRAWABLE_WINDOW) {

	x += pDrawable->x;
	y += pDrawable->y;

	iswin = 1;
	psrcBase = vga_mem(0);
	bytewidth = vga_width;
	if (CUR_OVERLAP(pDrawable->x, pDrawable->y,
	    pDrawable->x + pDrawable->width,
	    pDrawable->y + pDrawable->height))
		HideCursor();
    }
    else
    {
	iswin = 0;
	psrcBase = ((PixmapPtr)pDrawable)->devPrivate.ptr;
	bytewidth = (int)(((PixmapPtr)pDrawable)->devKind);
    }
    psrcBase += y * bytewidth;
#ifdef EGA_HIRES
    if (iswin && vga_hires) {
	if (psrcBase > vga_mem(0xffff)) {
	    psrcBase -= 0x10000;
	    if (!vga_curpage) {
		vga_curpage = 1;
		SetPage();
	    }
	    extra = 0;
	} else {
	    if (vga_curpage) {
		vga_curpage = 0;
		SetPage();
	    }
	    if (y + height > HIRES_LPP) {
		extra = y + height - HIRES_LPP;
		height -= extra;
	    } else
		extra = 0;
	}
    } else
	extra = 0;
#endif
    y = bytewidth;
    bytewidth = PixmapBytePad(width, 1);
more:
    while (height-- > 0) {
	copybits(pDst, psrcBase, 0, x, width);
	pDst = (char *)pDst + bytewidth;
	psrcBase += y;	/* go to next line */
    }
#ifdef EGA_HIRES
    if (extra) {
	psrcBase -= 0x10000;
	height = extra;
	extra = 0;
	vga_curpage = 1;
	SetPage();
	goto more;
    }
#endif
}
