#include <stdio.h>
#include "X.h"
#include "Xproto.h"
#include "scrnintstr.h"
#include "cmapst.h"
#include "resource.h"
#include "funcs.h"
#include "mxfuncs.h"

static ColormapPtr InstalledMaps[MAXSCREENS];

int
mxListInstalledColormaps(pScreen, pmaps)
ScreenPtr	pScreen;
Colormap	*pmaps;
{
	*pmaps = InstalledMaps[pScreen->myNum]->mid;
	return 1;
}

void
mxInstallColormap(pmap)
    ColormapPtr	pmap;
{
    int index = pmap->pScreen->myNum;
    ColormapPtr oldpmap = InstalledMaps[index];

    if(pmap != oldpmap)
    {
	/* Uninstall pInstalledMap. No hardware changes required, just
	 * notify all interested parties. */
	if(oldpmap != (ColormapPtr)None)
	    WalkTree(pmap->pScreen, TellLostMap, (pointer)&oldpmap->mid);
	/* Install pmap */
	InstalledMaps[index] = pmap;
	WalkTree(pmap->pScreen, TellGainedMap, (pointer)&pmap->mid);

    }
}

void
mxUninstallColormap(pmap)
    ColormapPtr	pmap;
{
    int index = pmap->pScreen->myNum;
    ColormapPtr curpmap = InstalledMaps[index];

    if(pmap == curpmap)
    {
        /* Uninstall pmap */
	WalkTree(pmap->pScreen, TellLostMap, (pointer)&pmap->mid);
	curpmap = (ColormapPtr) LookupIDByType(pmap->pScreen->defColormap,
					 RT_COLORMAP);
	/* Install default map */
	InstalledMaps[index] = curpmap;
	WalkTree(pmap->pScreen, TellGainedMap, (pointer)&curpmap->mid);
    }
	
}

void
mxResolveColor(pred, pgreen, pblue, pVisual)
unsigned short	*pred, *pgreen, *pblue;
VisualPtr	pVisual;
{
	pVisual = pVisual;
	*pred = *pgreen = *pblue =
		(*pred>>2) + (*pgreen>>2) + (*pblue>>2) > 0x6000 ? ~0 : 0;
}

int
mxCreateColormap(pmap)
ColormapPtr pmap;
{
	unsigned short red, green, blue;
	Pixel pix;

	pix = 0;
	red = green = blue = 0;
	AllocColor(pmap, &red, &green, &blue, &pix, 0);

	red = green = blue = ~0;
	AllocColor(pmap, &red, &green, &blue, &pix, 0);
	return TRUE;
}

void
mxDestroyColormap(pmap)
ColormapPtr pmap;
{
    pmap = pmap;
}

void
mxStoreColors(pmap, ndef, pdefs)
ColormapPtr pmap;
int ndef;
xColorItem *pdefs;
{
    pmap = pmap;
    ndef = ndef;
    pdefs = pdefs;
}
