#include "Xmd.h"
#include "misc.h"
#include "pixmapstr.h"
#include "os.h"		/* for malloc.h */
#include "regionstr.h"

#include "ega.h"
#include "../../mi/mi.h"

#include "servermd.h"

#include "site.h"
#include <dos.h>
#include "egafuncs.h"
#include "mxfuncs.h"

/*
 *	egaSaveAreas:
 *	    Take an area of the screen (specified in pRegion), and save
 *	    those areas in pPixmap.  The region is in the pixmap's
 *	    coordinate system so we have to add x and y to get the screen
 *	    coordinates.
 */
void
mxSaveAreas(pPixmap, pRegion, x, y)
PixmapPtr pPixmap;
RegionPtr pRegion;
int x, y;
{
    BoxRec 	*prect;
    int i, xMin, yMin, height, width;
    u_char	VGA_BASED *psrc;
    u_char	*pdst, *pdstBase;
    int		dstWidth;
    u_long	bytenum;

    pdstBase = pPixmap->devPrivate.ptr;
    dstWidth = pPixmap->devKind;
    prect = REGION_RECTS(pRegion);
    for(i = 0; i < REGION_NUM_RECTS(pRegion); i++, prect++) {
	width = prect->x2 - prect->x1;
  	xMin = prect->x1 + x;
	height = prect->y2 - prect->y1;
  	yMin = prect->y1 + y;
	if (CUR_OVERLAP(xMin, yMin, xMin + width, yMin + height))
	    HideCursor();
/*
printf("save %d,%d to %d,%d %dx%d %#x %d\n", xMin, yMin, prect->x1, prect->y1, width, height, pdstBase, dstWidth);
*/
	bytenum = yMin * vga_width;
	psrc = vga_mem((u_short)bytenum);
	bytenum >>= 16;
	if (vga_hires) {
	    if (bytenum) {
		if (!vga_curpage) {
		    vga_curpage = 1;
		    SetPage();
		}
	    } else if (vga_curpage) {
		vga_curpage = 0;
		SetPage();
	    }
	}
	pdst = pdstBase + prect->y1 * dstWidth;
	while (height--) {
	    copybits(pdst, psrc, prect->x1, xMin, width);
	    psrc += vga_width;
	    if (vga_hires && psrc > vga_mem(0xffff)) {
		psrc -= 0x10000;
		vga_curpage = 1;
		SetPage();
	    }
	    pdst += dstWidth;
	}
    }
}

/*
 *	egaRestoreAreas:
 *	    Does the opposite of egaSaveAreas, except in this case the
 *	    region is in the screen's coordinate system.
 */
void
mxRestoreAreas(pPixmap, pRegion, x, y)
PixmapPtr pPixmap;
RegionPtr pRegion;
int x, y;
{
    BoxRec 	*prect;
    int i, xMin, yMin, height, width;
    u_char	VGA_BASED *pdst;
    u_char	*psrc, *psrcBase;
    int		srcWidth;
    u_long	bytenum;

    psrcBase = pPixmap->devPrivate.ptr;
    srcWidth = pPixmap->devKind;
    prect = REGION_RECTS(pRegion);
    for(i = 0; i < REGION_NUM_RECTS(pRegion); i++, prect++) {
	width = prect->x2 - prect->x1;
  	xMin = prect->x1 - x;
	height = prect->y2 - prect->y1;
  	yMin = prect->y1 - y;
	if (CUR_OVERLAP(prect->x1, prect->y1, prect->x2, prect->y2))
	    HideCursor();
/*
printf("restore %d,%d to %d,%d %dx%d\n", xMin, yMin, prect->x1, prect->y1, width, height);
*/
	bytenum = prect->y1 * vga_width;
	pdst = vga_mem((u_short)bytenum);
	bytenum >>= 16;
	if (vga_hires) {
	    if (bytenum) {
		if (!vga_curpage) {
		    vga_curpage = 1;
		    SetPage();
		}
	    } else if (vga_curpage) {
		vga_curpage = 0;
		SetPage();
	    }
	}
	psrc = psrcBase + yMin * srcWidth;
	while (height--) {
	    copybits(pdst, psrc, prect->x1, xMin, width);
	    pdst += vga_width;
	    if (vga_hires && pdst > vga_mem(0xffff)) {
		pdst -= 0x10000;
		vga_curpage = 1;
		SetPage();
	    }
	    psrc += srcWidth;
	}
    }
}

/*
 *	egaSetClipmaskRgn
 *	    If the client clip in the GC is of the CT_PIXMAP type, this
 *	    function is called to merge pRegion into that pixmap.  This
 *	    probably won't be called since client clips in a GC are
 *	    stored as CT_REGION clip lists.
 */
void
mxSetClipmaskRgn(pGC, pRegion)
GCPtr pGC;
RegionPtr pRegion;
{
	pGC = pGC;
	pRegion = pRegion;
}

PixmapPtr
mxGetImagePixmap()
{
	return NULL;
}

PixmapPtr
mxGetSpansPixmap()
{
	return NULL;
}
