/* Combined Purdue/PurduePlus patches, level 2.0, 1/17/89 */
/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: ega.h,v 1.9 88/09/06 14:53:21 jim Exp $ */
/* Monochrome Frame Buffer definitions 
   written by drewry, september 1986
*/
#include <stdio.h>
#include <conio.h>
#include "pixmap.h"
#include "region.h"
#include "gc.h"
#include "colormap.h"
#include "miscstruct.h"
#include "../../mi/mibstore.h"
#include "../common/ibmfuncs.h"

#ifndef WINDOW_DEFINED
#define WINDOW_DEFINED
typedef struct _Window *WindowPtr;
#endif

#define EGA_HIRES
#define HIRES_LPP	512	/* scan lines per page */
/* #define EGA_1280 */

#ifdef ERGO
extern const __segment	vga_base;
#define vga_memcpy	_fmemcpy
#define vga_mem(x)	((u_char __based(vga_base) *)((u_short)(x)))
#define VGA_BASED __based(vga_base)
#else
#define vga_memcpy	memcpy
#define vga_mem(x)	((u_char *)(0xa0000 + (u_short)(x)))
#define VGA_BASED
#endif

extern int	vga_width;	/* width of screen in bytes */
extern u_char	vga_curpage;
extern u_char	vga_page_shift;	/* for VESA support */
extern char	vga_hires;
extern int	scr_width, scr_height;

#define SetPage()	VGASetPage(vga_curpage << vga_page_shift)

extern int InverseAlu[];

extern void clearbits(u_char *, u_char *, int, int, int);
extern void andbits(u_char *, u_char *, int, int, int);
extern void andReversebits(u_char *, u_char *, int, int, int);
extern void copybits(u_char *, u_char *, int, int, int);
extern void andInvertedbits(u_char *, u_char *, int, int, int);
extern void noopbits(u_char *, u_char *, int, int, int);
extern void xorbits(u_char *, u_char *, int, int, int);
extern void orbits(u_char *, u_char *, int, int, int);
extern void norbits(u_char *, u_char *, int, int, int);
extern void equivbits(u_char *, u_char *, int, int, int);
extern void invertbits(u_char *, u_char *, int, int, int);
extern void orReversebits(u_char *, u_char *, int, int, int);
extern void copyInvertedbits(u_char *, u_char *, int, int, int);
extern void orInvertedbits(u_char *, u_char *, int, int, int);
extern void nandbits(u_char *, u_char *, int, int, int);
extern void setbits(u_char *, u_char *, int, int, int);

extern int egaGeneration;
extern int egaGCPrivateIndex;
extern int egaScrPrivateIndex;

/*
   private filed of pixmap
   pixmap.devPrivate = (unsigned int *)pointer_to_bits
   pixmap.devKind = width_of_pixmap_in_bytes

   private field of screen
   a pixmap, for which we allocate storage.  devPrivate is a pointer to
the bits in the hardware framebuffer.  note that devKind can be poked to
make the code work for framebuffers that are wider than their
displayable screen (e.g. the early vsII, which displayed 960 pixels
across, but was 1024 in the hardware.)  this is left to the
code that calls egaScreenInit(), rather than having vgaScreenInit()
take yet another parameter.

   private field of GC 
	pAbsClientRegion is always a real region, although perhaps
an empty one.
	Freeing pCompositeClip is done based on the value of
freeCompClip; if freeCompClip is not carefully maintained, we will end
up losing storage or freeing something that isn't ours.
*/

typedef struct {
    unsigned char	rop;		/* reduction of rasterop to 1 of 3 */
    short	fExpose;		/* callexposure handling ? */
    short	freeCompClip;
    PixmapPtr	pRotatedTile;		/* tile/stipple  rotated to align */
    PixmapPtr	pRotatedStipple;	/* with window and using offsets */
    RegionPtr	pAbsClientRegion;	/* client region in screen coords */
    RegionPtr	pCompositeClip;		/* free this based on freeCompClip
					   flag rather than NULLness */
    void 	(* FillArea)(u_char *, u_char *, int, int, int);
    void	(* movebits)(u_char *, u_char *, int, int, int);
    PixmapPtr	*ppPixmap;		/* pointer to tile/stipple ptr */
    short	flags;
    } egaPrivGC;
typedef egaPrivGC	*vgaPrivGCPtr;

#define EGA_FILLSOLID		0x0001
#define EGA_FASTFILL		0x0002

/* freeCompositeClip values */
#define REPLACE_CC	0		/* compsite clip is a copy of a
					   pointer, so it doesn't need to 
					   be freed; just overwrite it.
					   this happens if there is no
					   client clip and the gc has
					   ClipByChildren in it.
					*/
#define FREE_CC		1		/* composite clip is a real
					   region that we need to free
					*/

/* precomputed information about each glyph for GlyphBlt code.
   this saves recalculating the per glyph information for each
box.
*/
typedef struct _pos{
    int xpos;		/* xposition of glyph's origin */
    int xchar;		/* x position mod 32 */
    int leftEdge;
    int rightEdge;
    int topEdge;
    int bottomEdge;
    unsigned int *pdstBase;	/* longword with character origin */
    int widthGlyph;	/* width in bytes of this glyph */
} TEXTPOS;

/* reduced raster ops for ega */
#define RROP_BLACK	GXclear
#define RROP_WHITE	GXset
#define RROP_NOP	GXnoop
#define RROP_INVERT	GXinvert

/* out of clip region codes */
#define OUT_LEFT 0x08
#define OUT_RIGHT 0x04
#define OUT_ABOVE 0x02
#define OUT_BELOW 0x01

/* major axis for bresenham's line */
#define X_AXIS	0
#define Y_AXIS	1

/* optimization codes for FONT's devPrivate field */
#define FT_VARPITCH	0
#define FT_SMALLPITCH	1
#define FT_FIXPITCH	2

struct egaCursor {
	struct _Screen *pScreen;
	struct _CursorBits *pBits;
	int pos_x, pos_y;
	u_char isUp;
	u_char validSaved;
	u_char reDraw;
	u_char shouldBeUp;
	BoxRec saved;		/* region under cursor saved */
	u_char *pSaved;		/* pointer to saved data */
	int save_size;		/* size in bytes of pSaved */
	int screen_width, screen_height;
	int saved_bwidth;	/* width in bytes of pSaved */
};

extern int	mouse_X, mouse_Y;

extern struct egaCursor egaCursor;

#define CUR_OVERLAP(X1,Y1,X2,Y2) ((egaCursor.isUp || egaCursor.validSaved) && \
				(X1) < egaCursor.saved.x2 && \
				(X2) > egaCursor.saved.x1 && \
				(Y1) < egaCursor.saved.y2 && \
				(Y2) > egaCursor.saved.y1)
