#include "scrnintstr.h"
#include "cursorstr.h"

struct _IBM_Cur {
	unsigned int	screenMask[16],
			cursorMask[16];
	int		hotX, hotY;
};

#define	MOUSE_CURPOS	0x0001
#define MOUSE_LEFTDOWN	0x0002
#define MOUSE_LEFTUP	0x0004
#define MOUSE_RIGHTDOWN	0x0008
#define MOUSE_RIGHTUP	0x0010
#define MOUSE_MIDDLEDOWN	0x0020
#define MOUSE_MIDDLEUP	0x0040
#define MOUSE_BUTTONPRESS (MOUSE_LEFTDOWN|MOUSE_RIGHTDOWN|MOUSE_MIDDLEDOWN)
#define MOUSE_BUTTONRELSE (MOUSE_LEFTUP|MOUSE_RIGHTUP|MOUSE_MIDDLEUP)

Bool mouseRealizeCursor(ScreenPtr, CursorPtr);
Bool mouseUnrealizeCursor(ScreenPtr, CursorPtr);
Bool mouseDisplayCursor(ScreenPtr, CursorPtr);
Bool mouseSetCursorPosition(ScreenPtr, int, int, Bool);
void mouseCursorLimits(ScreenPtr, CursorPtr, BoxPtr, BoxPtr);
void mouseConstrainCursor(ScreenPtr, BoxPtr);
void mousePointerNonInterestBox(ScreenPtr, BoxPtr);

int FlagReset(void);
void HideCursor(void);
void ShowCursor(void);
void msHideCursor(void);
void SetMouseSensitivity(int, int, int);
void SetCursorPos(int, int);
void SetHorizontalLimits(int, int);
void SetVerticalLimits(int, int);
void SetMickeysPerPixel(int, int);
void SetSpeedThreshold(int);

#define INPUT_MOUSE	0x0002
#define INPUT_KBD	0x0001

extern int mouse_flags;
#define MOUSE_ON	0x0001
#define MOUSE_OPEN	0x0004
#define MOUSE_SIM3	0x0008		/* simulate button 3 */
#define MOUSE_PEND	0x0010		/* button 3 simulation pending */
#define MOUSE_DOWN	0x0020		/* fake button 3 is down */
#define MOUSE_ATEXIT	0x0040		/* atexit called */
