#include <stdio.h>
#include <dos.h>
#include "pcdefs.h"
#include "rpc.h"
#include "funcs.h"
#include "shared.h"

struct net_data _far *pkshared;
unsigned char net_handle;
extern char *net_file;

int
pglue_open(address, ioaddr, myip)
short address;
short ioaddr;
unsigned long myip;
{
    int i;
    int addr;
    short buf[10];

    i = rpc_init(net_file);
    if (i < 0) {
	perror(net_file);
	return -1;
    }
    net_handle = i;
    buf[0] = FUNC_INIT;
    buf[1] = address;
    buf[2] = ioaddr;
    *(unsigned long *)&buf[4] = myip;
    i = rpc_call(net_handle, sizeof buf, sizeof buf, buf);
    if (!i)
	return -9;
    /* The buffer is organized like this:
     * (short) word 0:	status
     *		    1:  pad
     *		    2:  offset of shared address
     *		    3:	segment of shared address
     *		    4:	size of of shared buffer
     */
    /* convert to real address (20 bits) */
    addr = (buf[3] << 4) + buf[2];
    i = get_real_window(addr & 0xffff0, (buf[4] + 15 + (addr & 0x0f)) & 0xfff0);
    if (!i)
	return -10;
    *(int *)&pkshared = addr & 0x000f;
    ((short *)&pkshared)[2] = (short)i;

    return buf[0];
}

void
pglue_close()
{
    short buf[1];

    buf[0] = FUNC_SHUTDOWN;
    rpc_call(net_handle, 0, 2, buf);
}

void
send_pkt(size)
{
    pkshared->xmitlen = size;
    rpc_call(net_handle, 0, 0, 0);
}
