	TITLE   pglue

	.386p

	include	data.inc

; Glue routines on the '386 side that interface to the glue routines
; on the 286 side.

_DATA	segment dword public use32 'DATA'
pglue_path	db	"PGLUE.EXE",0
_DATA	ends

_BSS	segment dword public use32 'BSS'
	align	4
PUBLIC	_pkshared
_pkshared	dd	?		; _Far pointer to shared area
shared_seg	dw	?
rps_buf		dw	6 dup(?)	; 12 bytes
rpc_handle	db	?
_BSS	ends
DGROUP	group _DATA,_BSS

	ASSUME	cs:_TEXT, ds:DGROUP, es:nothing, ss:nothing

_TEXT	segment	dword public use32 'CODE'
		align	4

PUBLIC  pglue_open_
;
;	pglue_open(address, ioaddr, myip)
;	short address;	/* EAX */
;	short ioaddr;	/* EDX */
;	u_long myip;	/* EBX */
;
;
;     pglue_open() start the pglue.exe file and return 0 on success
;	or an error code (a negative number) on error.
;

pglue_open_      PROC NEAR
	push	ecx
	push	esi

	mov	ecx,eax		; save address

	push	edx		; save ioaddr
	mov	ah,0e0h
	mov	edx,offset pglue_path
	int	21h
	pop	edx		; restore ioaddr
	jc	bad

	mov	rpc_handle,al

	; the '286 glue code is initialized.  Now call the "init" function.
	mov	esi,offset rps_buf
	mov	word ptr [esi],1	; function = init
	mov	[esi+2],cx		; address
	mov	[esi+4],dx		; ioaddr
	mov	[esi+8],ebx		; myip
	mov	edx,esi
	mov	ecx,12			; number of bytes passed
	mov	ebx,ecx			; max number of return bytes
	mov	ah,0e1h
	int	21h			; make the call

	or	bx,bx
	jnz	short open_1		; if 0, then error
	mov	eax,-9			; error code
	jmp	short bad
open_1:
	mov	eax,dword ptr [esi+4]	; address of shared
	movzx	ebx,ax			; LSW of shared
	shr	eax,16			; get segment
	shl	eax,4			; multiply by 16
	add	eax,ebx			; converted to physical address
	movzx	ebx,ax			; LSW in BX
	shr	eax,16			; MSW in SI
	mov	esi,eax			; put in SI:BX
	sub	ecx,ecx			; upper 16 of length
	mov	edx,(size real_data + 15) AND 0fff0h
	mov	ax,0e803h
	int	21h
	jc	bad
	mov	shared_seg,ax
	sub	eax,eax
	mov	_pkshared,eax
	movsx	eax,rps_buf		; status code
bad:
	pop	esi
	pop	ecx
	ret
pglue_open_	ENDP

PUBLIC  pglue_close_

pglue_close_      PROC NEAR
	push	eax
	push	ebx
	push	ecx
	push	edx
	mov	edx,offset rps_buf
	mov	ecx,2			; passed bytes
	mov	word ptr [edx],2	; function 2 = shutdown
	mov	al,rpc_handle
	sub	ebx,ebx			; max result bytes
	mov	ah,0e1h
	int	21h
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	ret
pglue_close_	ENDP

PUBLIC	send_pkt_
; int send_pkt(len)
; u_int len;	/* EAX */
send_pkt_	PROC NEAR
	push	ecx
	push	ebx
	mov	gs,shared_seg
	mov	gs:xmitlen,ax
	mov	al,rpc_handle
	mov	ah,0e1h
	sub	ecx,ecx			; no bytes
	mov	ebx,ecx			; no return bytes
	int	21h			; make the call
	movsx	eax,word ptr gs:xmitlen
	sub	ecx,ecx
	mov	gs:xmitlen,cx
	pop	ebx
	pop	ecx
	ret
send_pkt_	ENDP

	PUBLIC	kbd_init_
kbd_init_	PROC NEAR
	push	eax
	push	ebx
	push	ecx
	push	edx
	mov	edx,offset rps_buf
	mov	ecx,2			; passed bytes
	mov	word ptr [edx],3	; function 3 = kbd_init
	mov	al,rpc_handle
	sub	ebx,ebx			; max result bytes
	mov	ah,0e1h
	int	21h
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	ret
kbd_init_	ENDP

	PUBLIC	kbd_exit_
kbd_exit_	PROC NEAR
	push	eax
	push	ebx
	push	ecx
	push	edx
	mov	edx,offset rps_buf
	mov	ecx,2			; passed bytes
	mov	word ptr [edx],4	; function 4 = kbd_shutdown
	mov	al,rpc_handle
	sub	ebx,ebx			; max result bytes
	mov	ah,0e1h
	int	21h
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	ret
kbd_exit_	ENDP

	PUBLIC	kbd_command_
kbd_command_	PROC NEAR
	push	ebx
	push	ecx
	push	edx
	mov	edx,offset rps_buf
	mov	ecx,2			; passed bytes
	mov	ah,al			; command to be sent
	mov	al,5			; function 5 = kbd_command
	mov	word ptr [edx],ax
	mov	al,rpc_handle
	sub	ebx,ebx			; max result bytes
	mov	ah,0e1h
	int	21h
	pop	edx
	pop	ecx
	pop	ebx
	ret
kbd_command_	ENDP

	PUBLIC	mouse_init_
mouse_init_	PROC NEAR
	push	ebx
	push	ecx
	push	edx
	mov	edx,offset rps_buf
	mov	ecx,4			; passed bytes
	mov	word ptr [edx],6	; function 6 = mouse_init
	mov	word ptr [edx+2],ax	; flags
	mov	al,rpc_handle
	sub	ebx,ebx			; max result bytes
	mov	ah,0e1h
	int	21h
	pop	edx
	pop	ecx
	pop	ebx
	ret
mouse_init_	ENDP

	PUBLIC	mouse_exit_
mouse_exit_	PROC NEAR
	push	eax
	push	ebx
	push	ecx
	push	edx
	mov	edx,offset rps_buf
	mov	ecx,2			; passed bytes
	mov	word ptr [edx],7	; function 7 = mouse_shutdown
	mov	al,rpc_handle
	sub	ebx,ebx			; max result bytes
	mov	ah,0e1h
	int	21h
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	ret
mouse_exit_	ENDP

_TEXT	ends
	end
