/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1994 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include "../defs.h"
#include <sys/errno.h>

static int map[] = {
	NETERR_WOULD_BLOCK,	/* 100 = EWOULDBLOCK */
	NETERR_OTHER+1,		/* 101 = EINPROGRESS */
	NETERR_OTHER+2,		/* 102 = EALREADY */
	NETERR_BADFD,		/* 103 = ENOTSOCK */
	NETERR_BADARGS,		/* 104 = EDESTADDRREQ */
	NETERR_NOMEM,		/* 105 = EMSGSIZE */
	NETERR_BADARGS,		/* 106 = EPROTOTYPE */
	NETERR_NOSUPPORT,	/* 107 = ENOPROTOOPT */
	NETERR_NOSUPPORT,	/* 108 = EPROTONOSUPPORT */
	NETERR_NOSUPPORT,	/* 109 = ESOCKONOSUPPORT */
	NETERR_NOSUPPORT,	/* 110 = EOPNOTSUPP */
	NETERR_NOSUPPORT,	/* 111 = EPFNOSUPPORT */
	NETERR_NOSUPPORT,	/* 112 = EAFNOSUPPORT */
	NETERR_ADDRINUSE,	/* 113 = EADDRINUSE */
	NETERR_NOSUPPORT,	/* 114 = EADDRNOTAVAIL */
	NETERR_NETUNREACH,	/* 115 = ENETDOWN */
	NETERR_NETUNREACH,	/* 116 = ENETUNREACH */
	NETERR_NETUNREACH,	/* 117 = ENETRESET */
	NETERR_CONNREFUSED,	/* 118 = ECONNABORTED */
	NETERR_CONNREFUSED,	/* 119 = ECONNRESET */
	NETERR_NOMEM,		/* 120 = ENOBUFS */
	NETERR_OTHER+3,		/* 121 = EISCONN */
	NETERR_NOTESTAB,	/* 122 = ENOTCONN */
	NETERR_NOTESTAB,	/* 123 = ENOTCONN */
	NETERR_SYSTEM,		/* 124 = ETOOMANYREFS */
	NETERR_TIMEOUT,		/* 125 = ETIMEDOUT */
	NETERR_CONNREFUSED,	/* 126 = ECONNREFUSED */
	NETERR_SYSTEM,		/* 127 = ENOFILE */
	NETERR_BADFD,		/* 128 = ESKTID */
	NETERR_TIMEOUT,		/* 129 = ERETRY */
	NETERR_BADARGS,		/* 130 = ENAMETOOLONG */
	NETERR_HOSTUNREACH,	/* 131 = EHOSTDOWN */
	NETERR_HOSTUNREACH,	/* 132 = EHOSTUNREACH */
	NETERR_SYSTEM,		/* 133 = ENOIVEC */
	NETERR_SYSTEM,		/* 134 = ENETDEATH */
	NETERR_NOMEM,		/* 135 = ENOSOCK */
	NETERR_NOMEM,		/* 136 = EQFULL */
	NETERR_NOTLOADED,	/* 137 = ENOTCP */
	NETERR_SYSTEM,		/* 138 = EUNDEF */
	NETERR_NOTLOADED,	/* 139 = EUNIQUE */
	NETERR_NOTLOADED,	/* 140 = EATNOSUPPORT */
	NETERR_NOSUPPORT,	/* 141 = ENETBIND */
	NETERR_NOSUPPORT,	/* 142 = ETCPOPEN */
	NETERR_NOSUPPORT,	/* 143 = ETOOLONG */
	NETERR_SYSTEM,		/* 144 = EOPFAIL */
	NETERR_NOMEM,		/* 145 = ETABFULL */
	NETERR_HOST,		/* 146 = ENOHOST */
	NETERR_OTHER+4,		/* 147 = ENOUSER */
	NETERR_NOTLOADED,	/* 148 = ETCPHOME */
	NETERR_NOTLOADED,	/* 149 = EENVLONG */
	NETERR_NOTLOADED,	/* 150 = ENOIPADDR */
	NETERR_NOTLOADED,	/* 151 = ESERIAL */
};

#define nerrors (sizeof map / sizeof map[0])

int _fastcall _near
convert_error(err)
int err;
{
    if (IS_SOCK_ERR(err)) {
	err -= SOCK_ERROR;
	return map[err];
    }
    return NETERR_ERRNO;
}
