	title MISC - PC/TCP system calls

; Micro-X -- an X server for DOS
; Copyright (C) 1994 StarNet Communications Corp.

; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

; StarNet Communications Corp.
; 550 Lakeside Dr. #3
; Sunnyvale CA 94086 US
; http://www.starnet.com
; x-dos@starnet.com

	.286p

X	equ	4		; for near calls
;X	equ	6		; for far calls

_DATA	SEGMENT PARA PUBLIC 'DATA'
_DATA	ENDS
_TEXT	SEGMENT  para PUBLIC 'CODE'
_TEXT	ENDS

DGROUP	GROUP	_DATA

	ASSUME cs:_TEXT, ds:nothing, es:nothing, ss:nothing
	EXTRN	__dosyscall:NEAR
	EXTRN	_neterrno:WORD, _netsuberrno:WORD

_TEXT	SEGMENT

	; Note: parameter number 4 is a _far pointer, no matter which
	; memory model we're using.
	PUBLIC	_set_option
_set_option	PROC NEAR
	push	bp
	mov	bp,sp
	push	si
	push	di
	push	ds
	mov	bx,[bp+X]	; nd
	mov	si,[bp+X+2]	; level
	mov	di,[bp+X+4]	; option
	lds	dx,[bp+X+6]	; opt_val
	mov	cx,[bp+X+10]	; length
	mov	ah,020h
	call	__dosyscall
	pop	ds
	pop	di
	pop	si
	jc	short error
	xor	ax,ax		; return 0 on success
	pop	bp
	ret
_set_option	ENDP

	PUBLIC	_net_listen
_net_listen	PROC NEAR
	push	bp
	mov	bp,sp
	push	si
	mov	bx,[bp+X]	; nd
	mov	dx,[bp+X+2]	; type
	mov	si,[bp+X+4]	; addr
	mov	ah,023h
	jmp	short do_si
_net_listen	ENDP

	PUBLIC	__net_read
__net_read	PROC NEAR
	mov	ah,01bh
do_read:
	push	bp
	mov	bp,sp
	push	si
	push	di
	push	ds
	mov	bx,[bp+X]	; nd
	lds	si,[bp+X+2]	; buf
	mov	cx,[bp+X+6]	; len
	les	di,[bp+X+8]	; from
	mov	dx,[bp+X+12]	; flags
	call	__dosyscall
	pop	ds
	pop	di
	pop	si
	jc	error
	mov	ax,cx		; len returned in cx
	pop	bp
	ret
__net_read	ENDP

	PUBLIC	__net_readfrom
__net_readfrom	PROC NEAR
	mov	ah,01dh
	jmp	short do_read
__net_readfrom	ENDP

	PUBLIC	_net_release
_net_release	PROC NEAR
	mov	ah,008h
	jmp	short nd_only
_net_release	ENDP

	PUBLIC	_net_getdesc
_net_getdesc	PROC NEAR
	push	bp
	mov	ah,022h
	call	__dosyscall
	jc	error
	pop	bp
	ret
_net_getdesc	ENDP

	PUBLIC	_net_eof
_net_eof	PROC NEAR
	mov	ah,018h
nd_only:
	push	bp
	mov	bp,sp
	mov	bx,[bp+X]	; nd
	call	__dosyscall
	jc	error
	pop	bp
	ret
_net_eof	ENDP

	PUBLIC	_net_info
_net_info	PROC NEAR
	push	bp
	mov	bp,sp
	push	si
	mov	bx,[bp+X]	; nd
	mov	si,[bp+X+2]	; ni
	mov	ah,006h
do_si:
	call	__dosyscall
	pop	si
	jc	error
	pop	bp
	ret
error:
	mov	bl,ah		; save netsuberrno
	cbw			; convert al to word
	mov	_neterrno,ax
	mov	al,bl
	cbw
	mov	_netsuberrno,ax
	mov	ax,-1
	pop	bp
	ret
_net_info	ENDP

	PUBLIC	__net_select
__net_select	PROC NEAR
	push	bp
	mov	bp,sp
	push	di
	mov	bx,ds
	mov	es,bx
	mov	bx,[bp+X]	; maxid
	mov	dx,[bp+X+2]	; ifds
	mov	di,[bp+X+4]	; ofds
	mov	ah,00eh
	call	__dosyscall
	pop	di
	jc	error
	xor	ax,ax
	pop	bp
	ret
__net_select	ENDP

	PUBLIC	_get_peer
_get_peer	PROC NEAR
	push	bp
	mov	bp,sp
	mov	bx,[bp+X]	; nd
	mov	dx,[bp+X+2]	; addr
	mov	ah,016h
	call	__dosyscall
	jc	error
	xor	ax,ax
	pop	bp
	ret
_get_peer	ENDP

	PUBLIC	__net_write
__net_write	PROC NEAR
	mov	ah,01ah
	push	bp
	mov	bp,sp
	push	si
	push	ds
	mov	bx,[bp+X]	; nd
	lds	si,[bp+X+2]	; buf
	mov	cx,[bp+X+6]	; len
	mov	dx,[bp+X+8]	; flags
	call	__dosyscall
	pop	ds
	pop	si
	jc	error
	pop	bp
	ret
__net_write	ENDP

	PUBLIC	__net_writeto
__net_writeto	PROC NEAR
	mov	ah,01ch
	push	bp
	mov	bp,sp
	push	si
	push	di
	push	ds
	mov	bx,[bp+X]	; nd
	lds	si,[bp+X+2]	; buf
	mov	cx,[bp+X+6]	; len
	les	di,[bp+X+8]	; to
	mov	dx,[bp+X+12]	; flags
	call	__dosyscall
	pop	ds
	pop	di
	pop	si
	jc	error
	pop	bp
	ret
__net_writeto	ENDP

	PUBLIC	_net_abortall
_net_abortall	PROC NEAR
	mov	ah,024h
	call	__dosyscall
	ret
_net_abortall	ENDP

	PUBLIC	_net_releaseall
_net_releaseall	PROC NEAR
	mov	ah,009h
	call	__dosyscall
	ret
_net_releaseall	ENDP

_TEXT	ENDS
	END
