; Micro-X -- an X server for DOS
; Copyright (C) 1994 StarNet Communications Corp.

; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

; StarNet Communications Corp.
; 550 Lakeside Dr. #3
; Sunnyvale CA 94086 US
; http://www.starnet.com
; x-dos@starnet.com

	title INIT - Initialization routines

	.286p

X	equ	4		; for near calls
FX	equ	6		; for far calls

_DATA	SEGMENT PARA PUBLIC 'DATA'
n_buf	db	6 dup (0)
nums	db	'0123456789abcdef'
_DATA	ENDS
_BSS	SEGMENT PARA PUBLIC 'BSS'
savesp	dw	?
savess	dw	?
_BSS	ENDS
STACK	SEGMENT WORD STACK 'STACK'
	PUBLIC	mystack
mystack	db	200h dup (?)
estack	label	word
STACK	ENDS
_TEXT	SEGMENT  para PUBLIC 'CODE'
_TEXT	ENDS

DGROUP	GROUP	_DATA,_BSS,STACK

	ASSUME cs:_TEXT, ds:nothing, es:nothing, ss:nothing

_TEXT	SEGMENT
	EXTRN	_rpc_entry:NEAR

	; real procedure entry point
	; called from MicroX with:
	; AX	= function
	; BX	= arg
	; CX	= size of buffer
	; DS:0 = transaction buffer
	; return AX = return value
	;	 BX = neterrno
	;	 CX = errno or bytes returned
	;
	; push this stuff on the stack and call the C routine.
	ASSUME	ds:nothing
p_rpc		PROC	FAR
	push	si
	push	es
	mov	si,ax		; save function
	mov	ax,ds
	mov	es,ax		; save buffer
	mov	ax,DGROUP
	mov	ds,ax
	ASSUME	ds:DGROUP

	; setup my stack
	mov	savess,ss
	mov	savesp,sp

	mov	ss,ax
	ASSUME	ss:DGROUP
	lea	sp,estack

	push	es
	push	word ptr 0	; buffer
	push	cx		; len
	push	bx		; arg
	push	si		; func
	call	_rpc_entry
	add	sp,2		; don't pop ax
	pop	bx
	pop	cx		; data modified on stack by C routine
	add	sp,4		; buffer

	; restore our stack
	mov	ss,savess
	mov	sp,savesp

	pop	es
	pop	si
	iret
p_rpc		ENDP

	ASSUME	ds:DGROUP

	PUBLIC	@dfputs
; void _fastcall dfputs(cp)
; char near *cp;
@dfputs	PROC NEAR
	push	si
	mov	si,bx
	mov	ah,2
put_loop:
	lodsb
	or	al,al
	jz	put_exit
	mov	dl,al
	int	21h
	jmp	short put_loop
put_exit:
	pop	si
	ret
@dfputs	ENDP

	PUBLIC	@printn
@printn PROC NEAR
	xor	bl,bl
	mov	n_buf+4,bl
	mov	bx,ax
	and	bx,0fh
	mov	bl,nums[bx]
	mov	n_buf+3,bl
	shr	ax,4
	mov	bx,ax
	and	bx,0fh
	mov	bl,nums[bx]
	mov	n_buf+2,bl
	shr	ax,4
	mov	bx,ax
	and	bx,0fh
	mov	bl,nums[bx]
	mov	n_buf+1,bl
	shr	ax,4
	mov	bx,ax
	and	bx,0fh
	mov	bl,nums[bx]
	mov	n_buf,bl
	mov	bx,offset n_buf
	jmp	short @dfputs
@printn	ENDP

	PUBLIC	@printd
@printd PROC NEAR
	mov	bx,offset n_buf+5
	xor	cl,cl
	mov	[bx],cl
	mov	cx,10		; divide by 10
pd_1:
	xor	dx,dx		; divide number by 10
	div	cx
	add	dx,'0'		; remainder is in dx
	dec	bx
	mov	[bx],dl
	or	ax,ax
	jnz	pd_1		; more to divide
	jmp	short @dfputs
@printd	ENDP

	public	__dosyscall
__dosyscall	PROC NEAR
	int	061h		; this instruction will be modified
	ret
__dosyscall	ENDP

	public	_patch_vec
_patch_vec PROC NEAR
	push	bp
	mov	bp,sp
	mov	ax,[bp+X]	; vector
	mov	byte ptr cs:__dosyscall+1,al
	pop	bp
	ret
_patch_vec ENDP

_TEXT	ENDS
	END	p_rpc
