/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1994 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include <sys/types.h>
#include <errno.h>
#include "funcdef.h"
#include "../defs.h"
#include "../funcs.h"

struct novell_func {
	int (_fastcall *proc)(int, int _near *, void _far *);
} _near novell_funcs[] = {
	0,
	novell_init,
	novell_shutdown,
	novell_socket,
	novell_info,
	novell_accept,
	novell_drain,
	novell_release,
	novell_eof,
	novell_read,
	novell_write,
	novell_recv,
	novell_sendto,
	novell_select,
	0
};

#define N_FUNCS (sizeof (novell_funcs) / sizeof (novell_funcs[0]))

int
main(argc, argv, envp)
int argc;
char **argv;
char **envp;
{
	leave(0);
	/*NOTREACHED*/
	return 0;
}

int
rpc_entry(func, arg, len, buf)
int func, arg, len;
void _far *buf;
{
    struct novell_func _near *nfp;
    int i;

    nfp = &novell_funcs[func];
    if ((unsigned)func >= N_FUNCS || !nfp->proc) {
	arg = NETERR_BADCALL;
	len = 0;
	return -1;
    }
    i = (nfp->proc)(arg, &len, buf);
    if (i < 0) {
	len = errno;
	arg = convert_error(errno);
	if (arg)
	    return -1;
	return -1;
    }
    return i;
}

int _fastcall
novell_shutdown(arg, len, buf)
int arg, _near *len;
void _far *buf;
{
    return 0;
}
