/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1994 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "funcdef.h"
#include "../defs.h"
#include "../funcs.h"

int _fastcall
novell_init(arg, len, buf)
int arg, _near *len;
void _far *buf;
{
    dfputs("Novell LAN WP transport layer version 2.0\r\n");
    *len = 0;
    return 0;
}

int _fastcall
novell_drain(arg, len, buf)
int arg, _near *len;
void _far *buf;
{
    char junk[512];

    return soread(arg, junk, sizeof junk);
}

int _fastcall
novell_read(arg, len, buf)
int arg, _near *len;
void _far *buf;
{
    int ret;

    ret = soread(arg, buf, *len);
    if (ret < 0)
	return ret;
    *len = ret;
    return ret;
}

int _fastcall
novell_write(arg, len, buf)
int arg, _near *len;
void _far *buf;
{
    return sowrite(arg, buf, *len);
}

int _fastcall
novell_recv(arg, len, buf)
int arg, _near *len;
void _far *buf;
{
    int ret;
    struct sockaddr_in in;

    ret = sizeof in;
    *len -= sizeof (struct net_addr);
    ret = recvfrom(arg, (char _far *)buf + sizeof (struct net_addr),
	    *len, 0, (SADDR_PTR)&in, &ret);
    if (ret < 0)
	return ret;
    *len = ret + sizeof (struct net_addr);
    ((struct net_addr _far *)buf)->socket = ntohs(in.sin_port);
    ((struct net_addr _far *)buf)->host = in.sin_addr.s_addr;
    return ret;
}

int _fastcall
novell_sendto(arg, len, buf)
int arg, _near *len;
void _far *buf;
{
    struct sockaddr_in in;
    struct sendto_head head = *(struct sendto_head _far *)buf;

    in.sin_family = AF_INET;
    in.sin_addr.s_addr = head.addr.host;
    in.sin_port = htons(head.addr.socket);
    memset(in.sin_zero, 0, sizeof in.sin_zero);
    buf = (char _far *)buf + sizeof (struct sendto_head);
    *len -= sizeof (struct sendto_head);
    return sendto(arg, buf, *len, 0, (SADDR_PTR)&in, sizeof in);
}
