/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1994 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include "defs.h"
#include "rpc.h"
#include "funcs.h"

int
net_socket(type, addr)
int type;
struct net_addr *addr;
{
    return rpc_call(net_rpc, FUNC_SOCKET, type, sizeof *addr, RPC_READ|RPC_WRITE, addr);
}

int
net_info(fd, ni)
int fd;
struct net_info *ni;
{
    return rpc_call(net_rpc, FUNC_INFO, fd, sizeof *ni, RPC_READ, ni);
}

int
net_accept(fd, addr)
int fd;
struct net_addr *addr;
{
    return rpc_call(net_rpc, FUNC_ACCEPT, fd, sizeof *addr, RPC_READ, addr);
}

int
net_select(nfds, ifds, ofds)
int nfds;
unsigned long *ifds, *ofds;
{
    unsigned long fds[2];
    int ret;

    fds[0] = ifds ? *ifds : 0;
    fds[1] = ofds ? *ofds : 0;
    ret = rpc_call(net_rpc, FUNC_SELECT, nfds, sizeof fds, RPC_READ|RPC_WRITE, fds);

    if (ifds)
	*ifds = fds[0];
    if (ofds)
	*ofds = fds[1];
    return ret;
}
