/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1992 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include "pcdefs.h"
#include "protocol.h"
#include "route.h"
#include "config.h"
#include "funcdef.h"

struct route_st route[NROUTE];	/* our routing table */
extern u_long nmask;

u_long
find_route(ipn)
u_long	ipn;
{
	int	i;

	if ((ipn & nmask) == (Scon.myip & nmask)) {
		if ((ipn & Scon.snetmask) == (Scon.myip & Scon.snetmask))
			return(ipn);
		ipn &= Scon.snetmask;
	} else {
		switch ((u_char)ipn >> 6) {
		    case 0:
		    case 1:
			ipn &= 0x000000ffL;
			break;
		    case 2:
			ipn &= 0x0000ffffL;
			break;
		    case 3:
			ipn &= 0x00ffffffL;
			break;
		}
	}
	for (i = 1; i < NROUTE; i++)
		if (route[i].to == ipn)
			break;

	if (i == NROUTE)
		i = 0;

	return(route[i].real);
}

void
setgate(net, gate)
u_long	net;
u_long	gate;
{
	int	i;

	if (net) {
		switch ((u_char)net >> 6) {
		    case 0:
		    case 1:
			net &= 0x000000ffL;
			break;
		    case 2:
			net &= 0x0000ffffL;
			break;
		    case 3:
			net &= 0x00ffffffL;
			break;
		}
		for (i = 1; i < NROUTE ; i++) {
			if (route[i].to == net) {
				route[i].real = gate;
				break;
			}
			if (!route[i].to) {
				route[i].to = net;
				route[i].real = gate;
				break;
			}
		}
	} else {
		route[0].to = 0;
		route[0].real = gate;
	}
}
