/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1993 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */
/*   
*     rarp.c
*/
#include "pcdefs.h"
#include "protocol.h"
#include "config.h"
#include "funcdef.h"
#include "../defs.h"

extern u_char myether[DADDLEN];
extern int neterrno;

int
rarp_process()
{
    int	i;
    u_long	end_time;

    for (i = 0; i < RARP_RETRIES; i++) {
	if (sendarp(myether, 0, htons(RARPQ)) < 0) {
		neterrno = NETERR_SYSTEM;
		return -1;
	}
	end_time = n_clicks() + 18L;
	while (n_clicks() < end_time) {
		netsleep();
		if (Scon.myip)
			return 0;
	}
    }
    neterrno = NETERR_TIMEOUT;
    return -1;
}
