/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1994 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include "pcdefs.h"
#include "funcdef.h"
#include "../defs.h"
#include "../funcs.h"
#include "config.h"

#include "mbuf.h"

extern struct mbuf _near *mbfree, _near *mbprocess, _near * _near *mbnext;
extern struct mbuf mb[NMBUFS];
extern struct ebuf eb[NEBUFS+1];
extern int slip_mode;

char _far *environ;

int _near errno;
int _near neterrno;
char net_inited = 0;

struct tcp_func {
	int (_fastcall *proc)(int, int *, void _far *);
} _near tcp_funcs[] = {
	tcp_startup,
	tcp_init,		/*  1 */
	tcp_shutdown,		/*  2 */
	tcp_socket,		/*  3 */
	tcp_info,		/*  4 */
	tcp_accept,		/*  5 */
	tcp_drain,		/*  6 */
	tcp_release,		/*  7 */
	tcp_eof,		/*  8 */
	tcp_read,		/*  9 */
	tcp_write,		/* 10 */
	tcp_recv,		/* 11 */
	tcp_sendto,		/* 12 */
	tcp_select,		/* 13 */
	0
};

#define n_funcs (sizeof (tcp_funcs) / sizeof (tcp_funcs[0]))

/*
 * Arg and len are passed by reference; they are passed on the stack, but
 * the asm routine that calls this function retrieves the values from the
 * stack after this routine modifies them.  Because of this, we have to
 * fool the optimizer at times because it things these variables aren't
 * used after this function returns.
 */
int
rpc_entry(func, arg, len, buf)
int func, arg, len;
void _far *buf;
{
    struct tcp_func near *nfp;
    int i;

    if (net_inited)
	netsleep();
    nfp = &tcp_funcs[func];
    if ((unsigned)func >= n_funcs || !nfp->proc) {
	arg = NETERR_BADCALL;
	len = 0;
	return -1;
    }
/*
if (nfp->proc != tcp_select) {
printd(i);
}
*/
    i = (nfp->proc)(arg, &len, buf);
    if (i < 0) {
	len = errno;
	arg = neterrno;
	if (arg)
	    return -1;
/*
dfputs(":");
*/
	return -1;
    }
/*
if (nfp->proc != tcp_select)
dfputs(";");
*/
    return i;
}

int _fastcall
tcp_startup(arg, len, buf)
int arg, *len;
void _far *buf;
{
    *len = 0;
    return 0;
}

char wattcp[] = "WATTCP.CFG";

int _fastcall
tcp_init(arg, len, buf)
int arg, *len;
void _far *buf;
{
    char _far *cp;

    dfputs("StarNet TCP/IP transport layer version 2.0\r\n");

    cp = getenv("CONFIG.TEL");
    if (!cp)
	cp = getenv("CONFIGTEL");
    if (cp) {
	if (Sconfigure(cp, 0) < 0)
	    return -1;
    } else {
	cp = getenv(wattcp);
	if (!cp)
	    cp = wattcp;
	if (Sconfigure(cp, 1) < 0)
	    return -1;
    }
    /* If user didn't specify rarp or give an IP address, then assume BOOTP */
    if ((Scon.flags & (H_MYIP|H_BOOTP|H_RARP)) == 0)
	Scon.flags |= H_BOOTP;

    if (pkopen(Scon.address, Scon.ioaddr, Scon.flags) < 0) {
	dfputs("Can't find packet driver.\r\n");
	return -1;
    }

    intr_init();
    if (Scon.flags & H_BOOTP) {
	if (!Scon.broadcast)
	    Scon.broadcast = 0xffffffff;
	protinit();
	if (bootp_process()) {
	    pkclose();
	    intr_exit();
	    neterrno = NETERR_TIMEOUT;
	    return -1;
	}
	Scon.flags &= ~H_BOOTP;
	if (Scon.broadcast == 0xffffffff)
	    Scon.broadcast = 0;
    }
    if (Scon.flags & H_RARP) {
	if (slip_mode) {
	    pkclose();
	    intr_exit();
	    neterrno = NETERR_BADARGS;
	    return -1;
	}
	arpinit();
	if (rarp_process()) {
	    pkclose();
	    intr_exit();
	    neterrno = NETERR_TIMEOUT;
	    return -1;
	}
	Scon.flags &= ~H_RARP;
    }
    protinit();
    arpinit();
    net_inited++;

    *len = 0;
    return 0;
}

int _fastcall
tcp_info(arg, len, buf)
int arg, *len;
void _far *buf;
{
    ((struct net_info _far *)buf)->ip_address = Scon.myip;
    ((struct net_info _far *)buf)->ip_broadcast = Scon.broadcast;
    *len = sizeof (struct net_info);
    return 0;
}
