/*****************************************************************
 * i/o functions
 *
 *   WriteToClient, ReadRequestFromClient
 *
 *****************************************************************/

#include <stdio.h>
#include "Xos.h"
#include "Xmd.h"
#include <errno.h>
#include "X.h"
#include "Xproto.h"
#include "os.h"
#include "opaque.h"
#include "dixstruct.h"
#include "osdep.h"
#include "misc.h"

static int timesThisConnection = 0;
int _near OutputBufferSize = BUFSIZ;
static ConnectionPtr FreeInputs = (ConnectionPtr)NULL;
static ConnectionPtr FreeOutputs = (ConnectionPtr)NULL;
static OsCommPtr AvailableInput = (OsCommPtr)NULL;
static Bool CriticalOutputPending;
Bool _near AnyClientsWriteBlocked;
Bool _near NewOutputPending;
extern u_long _near AllClients, _near ClosingClients;

char _near isItTimeToYield = 1;

extern Bool near mouse_moved;

extern OsCommPtr near MyPrivate[NPORTS];

extern int AutoResetServer();

static ConnectionPtr _near AllocateBuffer(size_t);
static void _fastcall _near osXfer(OsCommPtr oc, ConnectionPtr oci);

int near lastRequest;

#define request_length(req, cli) ((cli->swapped ? \
	lswaps((req)->length) : (req)->length) << 2)
#define MAX_TIMES_PER         5

/*****************************************************************
 * ReadRequestFromClient
 *    Returns one request in client->requestBuffer.  Return status is:
 *
 *    > 0  if  successful, specifies length in bytes of the request
 *    = 0  if  entire request is not yet available
 *    < 0  if  client should be terminated
 *
 *    The request returned must be contiguous so that it can be
 *    cast in the dispatcher to the correct request type.  Because requests
 *    are variable length, ReadRequestFromClient() must look at the first 4
 *    bytes of a request to determine the length (the request length is
 *    always the 3rd and 4th bytes of the request).  
 *
 *****************************************************************/

#define YieldControl()				\
        { isItTimeToYield = TRUE;		\
	  mouseBlockHandler();			\
	  timesThisConnection = 0; }
#define YieldControlDeath()			\
        { timesThisConnection = 0; }

/* for debug */
extern int (_fastcall _near * _far InitialVector[3]) (ClientPtr);

int _near max_request_size = MAXBUFSIZE >> 2;

int
ReadRequestFromClient(client)
    ClientPtr client;
{

    OsCommPtr oc = (OsCommPtr)client->osPrivate;
    ConnectionPtr oci = oc->input;
    int fd = oc->fd;
    int needed, gotnow, result;
    xReq *request;

    if (AvailableInput)
    {
	if (AvailableInput != oc)
	{
	    AvailableInput->input->next = FreeInputs;
	    FreeInputs = AvailableInput->input;
	    AvailableInput->input = (ConnectionPtr)NULL;
	}
	AvailableInput = (OsCommPtr)NULL;
    }
    if (!oci)
    {
	if (oci = FreeInputs)
	{
	    FreeInputs = oci->next;
	}
	else if (!(oci = AllocateBuffer(OUTBUFSIZE)))
	{
	    YieldControlDeath();
	    return -1;
	}
	oc->input = oci;
	oci->count = 0;
    }
    /* reuse the last request */
    if (oc->flags & OS_REUSE) {
	oc->flags &= ~OS_REUSE;
	request = (xReq *)oci->buffer;
	needed = request_length(request, client);
	goto gotreq;
    }
    if (oc->flags & OS_REQUEST) {
	/* This code puts only one request into the buffer at a time.
	 * If we have a full request in buffer, then we can toss it now.
	 */
	oc->flags &= ~OS_REQUEST;
	oci->count = 0;
    }

/*
if (client->requestVector == InitialVector)
printf(".");
*/
    gotnow = oci->count;

    needed = sizeof (xReq) - gotnow;
    if (needed > 0) {
	result = net_read(fd, oci->buffer + gotnow, needed, 0, 0);
	if (result != needed) {
		if (result > 0) {
			oci->count += result;
			result = 0;
		} else if (result < 0 && neterrno != NET_ERR_WOULD_BLOCK) {
		    YieldControlDeath();
		    return -1;
		}
		YieldControl();
		return 0;
	}
	oci->count = sizeof (xReq);
	gotnow = sizeof (xReq);
	request = (xReq *)oci->buffer;
	needed = request_length(request, client);
	if (needed == 0)
	    needed = sizeof (xReq);
	if (needed > MAXBUFSIZE || needed < sizeof (xReq)) {
printf("needed=%u\n", needed);
	    /* Naughty client */
	    YieldControlDeath();
	    return -1;
	}

	/* see if we have enough memory */
	if (needed > oci->size)
	{
		xReq xBuf;

		xBuf = *request;
		xfree(oci->buffer);
		oci->buffer = (char *)xalloc(needed);
		if (oci->buffer == 0) {	/* ran out of memory */
		    /* Try freeing some other memory */
		    FlushAllOutput();
		    ResetOsBuffers();
		    if ((oci->buffer = (char *)xalloc(needed)) == 0) {
			YieldControlDeath();
			return -1;
		    }
		}
		oci->size = needed;
		request = (xReq *)oci->buffer;
		*request = xBuf;
	}
    } else {
	/* We know we have enough memory because we called the above
	 * code last time. */
	request = (xReq *)oci->buffer;
	needed = request_length(request, client);
    }

/*
printf("request=%d, client=%d len=%d, seq=%d\n", request->reqType, client->index, needed, client->sequence);
*/

lastRequest = request->reqType;
    if (needed > gotnow) {
	result = net_read(fd, oci->buffer + gotnow, needed - gotnow, 0, 0);
	if (result < 0 && neterrno != NET_ERR_WOULD_BLOCK) {
	    YieldControlDeath();
	    return -1;
	}
	if (result > 0)
	    oci->count += result;
	if (oci->count < needed) {
	    YieldControl();
/* printf("not ready\n"); */
	    return 0;
	}
    }

gotreq:
/*
if (client->requestVector == InitialVector)
printf("=");
*/
    oc->flags |= OS_REQUEST;
/* printf("complete\n"); */

    AvailableInput = oc;

    if (++timesThisConnection >= MAX_TIMES_PER)
	YieldControl()
    else if (mouse_moved)
	mouseBlockHandler();

    client->requestBuffer = (pointer)oci->buffer;
    return needed;
}

/*****************************************************************
 * InsertFakeRequest
 *    Splice a consed up (possibly partial) request in as the next request.
 * This routine will only be called once per session and it will be called
 * before ReadRequestFromClient is called for this client.  Therefore,
 * we know the buffer will be empty.
 *
 * I am assuming this code will only be called from NextAvalibleClient.
 * If it's called from other places, certain modifications must be made.
 *
 **********************/

Bool
InsertFakeRequest(client, data, count)
    ClientPtr client;
    char *data;
    int count;
{
    OsCommPtr oc = (OsCommPtr)client->osPrivate;
    ConnectionPtr oci = oc->input;

    if (AvailableInput)
    {
	if (AvailableInput != oc)
	{
	    AvailableInput->input->next = FreeInputs;
	    FreeInputs = AvailableInput->input;
	    AvailableInput->input = (ConnectionPtr)NULL;
	}
	AvailableInput = (OsCommPtr)NULL;
    }
    if (!oci)
    {
	if (oci = FreeInputs)
	    FreeInputs = oci->next;
	else if (!(oci = AllocateBuffer(OUTBUFSIZE)))
	    return FALSE;
	oc->input = oci;
    }
    /* This is cheating, but it doesn't matter. */
    memcpy(oci->buffer, data, count);
    oci->count = count;
    /* The request inserted is always partial.  Therefore nothing needs
     * to be checked until more data is avaliable.  This bit shouldn't
     * be set anyway, but just in case... */
    oc->flags &= ~OS_REQUEST;
    return(TRUE);
}

/*****************************************************************
 * ResetRequestFromClient
 *    Reset to reexecute the current request, and yield.
 *
 * This code is pretty easy since the current request begins at the
 * start of the buffer.
 *
 **********************/

ResetCurrentRequest(client)
    ClientPtr client;
{
    OsCommPtr oc = (OsCommPtr)client->osPrivate;
    xReq *request = (xReq *)oc->input->buffer;

    if (AvailableInput == oc)
	AvailableInput = (OsCommPtr)NULL;
    /* Check if we need more (probably authorization data).  From the
     * place where this code is called, oc->input is never NULL. */
    if (request_length(request, client) > oc->input->count)
	oc->flags &= ~OS_REQUEST;
    else
	oc->flags |= OS_REUSE;		/* just re-use this request */
/*
printf("flags = %x\n", oc->flags);
*/
    YieldControl();
}

 /********************
 * FlushClient()
 *    If the client isn't keeping up with us, then we try to continue
 *    buffering the data and set the apropriate bit in ClientsWritable
 *    (which is used by WaitFor in the select).  If the connection yields
 *    a permanent error, or we can't allocate any more space, we then
 *    close the connection.
 *
 **********************/

int near
FlushClient(oc, extraBuf, extraCount)
    OsCommPtr oc;
    char *extraBuf;
    int extraCount;
{
    int connection = oc->fd, n, i, notWritten;
    ConnectionPtr oco = oc->output;

    if (!oco)
	return 0;
    i = extraCount;
    extraCount += -extraCount & 3;
/*
printf("flush client %d: %d %d.\n", connection, oc->count, extraCount);
*/
retry:
    if (oco->count)
    {
	n = net_write(connection, oco->buffer, oco->count, 0);
	if (n < 0 && neterrno != NET_ERR_WOULD_BLOCK)
		goto bad;
	if (n > 0 && (oco->count -= n))
		(void) memcpy(oco->buffer, oco->buffer + n, oco->count);
	notWritten = oco->count;
        /* Notice that padding isn't needed for oc->outbuf since
           it is alreay padded by WriteToClient */
    } else
	notWritten = 0;
    if (extraCount) {
	if (notWritten)
	    notWritten += extraCount;
	else {
	    n = net_write(connection, extraBuf, extraCount, 0);
	    if (n < 0 && neterrno != NET_ERR_WOULD_BLOCK)
		goto bad;
	    if (n > 0) {
		extraBuf += n;
		extraCount -= n;
	    }
	    notWritten = extraCount;
	}
    }

    if (notWritten == 0) {
	/* everything was flushed out */
	oc->flags &= ~OS_BLOCKED;
	oco->next = FreeOutputs;
	FreeOutputs = oco;
	oc->output = 0;
	return i; /* return only the amount explicitly requested */
    }

    /* If we've arrived here, then the client is stuffed to the gills
       and not ready to accept more.  Make a note of it and buffer
       the rest. */
    AnyClientsWriteBlocked = TRUE;
    oc->flags |= OS_BLOCKED;

    if (notWritten > oco->size)
    {
	if (notWritten > MAXOUTBUF) {
		goto retry;
	}
	/* allocate at least enough to contain it plus one
	   OutputBufferSize */
	oco->size = notWritten + OutputBufferSize;
	oco->buffer = (unsigned char *)realloc(oco->buffer, oco->size);
	if (oco->buffer == NULL)
	{
    outOfMem:
printf("Out of memory! notWritten=%d.\n", notWritten);
	    _nfree(oco);
	    oc->output = 0;
	    MarkClientException(clients[oc->client]);
	    return(-1);
	}
    }

    if (extraCount)
	memcpy ( (char *)oco->buffer + oco->count, extraBuf, extraCount);

    oco->count = notWritten; /* this will include the pad */

    return i; /* return only the amount explicitly requested */

bad:
    MarkClientException(clients[oc->client]);
    return(-1);
}

 /********************
 * FlushAllOutput()
 *    Flush all clients with output.  However, if some client still
 *    has input in the queue (more requests), then don't flush.  This
 *    will prevent the output queue from being flushed every time around
 *    the round robin queue.  Now, some say that it SHOULD be flushed
 *    every time around, but...
 *
 * This routine is called from dix and WaitForSomething().
 *
 **********************/

void
FlushAllOutput()
{
    int i;
    OsCommPtr oc;

    CriticalOutputPending = FALSE;
    NewOutputPending = FALSE;

    for (i = 0; i < NPORTS; i++) {
	oc = MyPrivate[i];
	if (!oc || !oc->output || !oc->output->count)
		continue;
	FlushClient(oc, (char *)NULL, 0);
    }
}

void
FlushIfCriticalOutputPending()
{
    if (CriticalOutputPending)
	FlushAllOutput();
}

void
SetCriticalOutputPending()
{
    CriticalOutputPending = TRUE;
}

/*****************
 * WriteToClient
 *    Copies buf into ClientPtr.buf if it fits (with padding), else
 *    flushes ClientPtr.buf and buf to client.  As of this writing,
 *    every use of WriteToClient is cast to void, and the result
 *    is ignored.  Potentially, this could be used by requests
 *    that are sending several chunks of data and want to break
 *    out of a loop on error.  Thus, we will leave the type of
 *    this routine as int.
 *****************/

int
WriteToClient (client, count, buf)
    ClientPtr client;
    int count;
    char *buf;
{
    OsCommPtr oc = (OsCommPtr)client->osPrivate;
    ConnectionPtr oco = oc->output;
    int padBytes;

    if (oc->fd < 0) 
    {
	ErrorF( "OH NO, %d translates to %d\n", client->index, oc->fd);
	return(-1);
    }

    if (!oco)
    {
	if (oco = FreeOutputs)
	{
	    FreeOutputs = oco->next;
	}
	else if (!(oco = AllocateBuffer(OutputBufferSize)))
	{
	    MarkClientException(client);
	    return -1;
	}
	oc->output = oco;
    }

    padBytes = -count & 3;
    if (oco->count + count + padBytes > oco->size) {
	return FlushClient(oc, buf, count);
    }

    NewOutputPending = TRUE;
    memcpy((char *)oco->buffer + oco->count, buf, count);
    oco->count += count + padBytes;

    return count;
}

static ConnectionPtr _near
AllocateBuffer(size)
size_t size;
{
    register ConnectionPtr occ;

    occ = (ConnectionPtr)_nmalloc(sizeof(Connection));
    if (!occ)
{
printf("AllocateBuffer: nmalloc failed\n");
	return (ConnectionPtr)NULL;
}
    occ->buffer = (char *)xalloc(size);
    if (!occ->buffer)
    {
printf("AllocateBuffer: xalloc failed\n");
	_nfree(occ);
	return (ConnectionPtr)NULL;
    }
    occ->size = size;
    occ->count = 0;
    return occ;
}

void _fastcall _near
CloseDownFileDescriptor(oc)
    OsCommPtr oc;
{
    ConnectionPtr occ;

    net_eof(oc->fd);
    oc->flags |= OS_CLOSING;
    AllClients &= ~(1L << oc->fd);
    ClosingClients |= 1L << oc->fd;
    if (AvailableInput == oc)
	AvailableInput = (OsCommPtr)NULL;
    if (occ = oc->input)
    {
	oc->input = 0;
	if (FreeInputs)
	{
	    xfree(occ->buffer);
	    _nfree(occ);
	}
	else
	{
	    FreeInputs = occ;
	    occ->next = (ConnectionPtr)NULL;
	    occ->count = 0;
	}
    }
    if (occ = oc->output)
    {
	oc->output = 0;
	if (FreeOutputs)
	{
	    xfree(occ->buffer);
	    _nfree(occ);
	}
	else
	{
	    FreeOutputs = occ;
	    occ->next = (ConnectionPtr)NULL;
	    occ->count = 0;
	}
    }
}

void _near
ResetOsBuffers()
{
    ConnectionPtr occ;
    int i;

    while (occ = FreeInputs)
    {
	FreeInputs = occ->next;
	xfree(occ->buffer);
	_nfree(occ);
    }
    while (occ = FreeOutputs)
    {
	FreeOutputs = occ->next;
	xfree(occ->buffer);
	_nfree(occ);
    }
}
