#include <stdlib.h>
#include <stdio.h>
#include "misc.h"
#include "osdep.h"
#include "config.h"
#include <fcntl.h>

extern struct conf far Scon;

static void _far netshut(void);

void
start_network()
{
    char confname[128], *cp;
    int fd, i;

    cp = X11env;
    if (cp) {
	strcpy(confname, cp);
	strcat(confname, "\\");
    } else
	confname[0] = 0;
    strcat(confname, "config.bin");
    fd = open(confname, O_BINARY|O_RDONLY);
    if (fd < 0) {
	perror(confname);
	exit(1);
    }
    i = read(fd, &Scon, sizeof (struct conf));
    if (i != sizeof (struct conf)) {
	close(fd);
	FatalError("%s: truncated\n", confname);
    }
    close(fd);
    Ssetgate((u_long)Scon.gateip);
    Scon.gateip = 0;
    i = Snetinit();
    if (i)
	FatalError("Net error %d\n", i);
    atexit(netshut);
}

static void _far
netshut()
{
	fprintf(stderr, "Please wait while network is shut down...");
	Snetshut();
	fprintf(stderr, "\n");
}
